/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.dynamic.ui.editor.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.vdb.TranslatorOverride;
import org.teiid.designer.vdb.ui.VdbUiConstants;

public class AddTranslatorOverrideDialog
extends MessageDialog {
    static final String PREFIX = I18nUtil.getPropertyPrefix(AddTranslatorOverrideDialog.class);
    private Button btnOk;
    private final List<String> existingNames;
    private String name;
    private String type;

    public AddTranslatorOverrideDialog(Shell parentShell, List<String> existingOverrideNames) {
        super(parentShell, VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "title", new Object[0]), null, VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "message", new Object[0]), 2, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.existingNames = existingOverrideNames;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button btn = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.btnOk = btn;
            btn.setEnabled(false);
        }
        return btn;
    }

    protected Control createCustomArea(Composite parent) {
        Composite pnl = new Composite(parent, 0);
        pnl.setLayout((Layout)new GridLayout(2, false));
        pnl.setLayoutData((Object)new GridData(4, 4, true, true));
        Label lblName = new Label(pnl, 0);
        lblName.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        lblName.setText(VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "lblName.text", new Object[0]));
        Text txtName = new Text(pnl, 2048);
        txtName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        txtName.setToolTipText(VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "txtName.toolTip", new Object[0]));
        txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddTranslatorOverrideDialog.this.handleNameChanged(((Text)e.widget).getText());
            }
        });
        Label lblType = new Label(pnl, 0);
        lblType.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        lblType.setText(VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "lblType.text", new Object[0]));
        Text txtType = new Text(pnl, 2048);
        txtType.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        txtType.setToolTipText(VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "txtType.toolTip", new Object[0]));
        txtType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddTranslatorOverrideDialog.this.handleTypeChanged(((Text)e.widget).getText());
            }
        });
        return pnl;
    }

    public String getName() {
        assert (this.getReturnCode() == 0);
        return this.name;
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    public String getType() {
        assert (this.getReturnCode() == 0);
        return this.type;
    }

    void handleNameChanged(String newName) {
        this.name = newName;
        this.updateState();
    }

    void handleTypeChanged(String newType) {
        this.type = newType;
        this.updateState();
    }

    private void updateState() {
        String msg = this.validateName();
        if (StringUtilities.isEmpty((String)msg)) {
            msg = this.validateType();
        }
        if (StringUtilities.isEmpty((String)msg)) {
            if (!this.btnOk.isEnabled()) {
                this.btnOk.setEnabled(true);
            }
            if (this.imageLabel.getImage() != null) {
                this.imageLabel.setImage(null);
            }
            this.imageLabel.setImage(this.getInfoImage());
            msg = VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "message", new Object[0]);
        } else {
            if (this.btnOk.isEnabled()) {
                this.btnOk.setEnabled(false);
            }
            this.imageLabel.setImage(this.getErrorImage());
        }
        this.messageLabel.setText(msg);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)this.messageLabel);
    }

    private String validateName() {
        String errorMsg = TranslatorOverride.validateName((String)this.name);
        if (errorMsg == null && this.existingNames.contains(this.name)) {
            errorMsg = VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "translatorNameAlreadyExists", (Object)this.name);
        }
        if (this.name.equalsIgnoreCase(this.type)) {
            return VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "translatorOverrideNameMatchesTranslatorType", new Object[0]);
        }
        return errorMsg;
    }

    private String validateType() {
        return TranslatorOverride.validateType((String)this.type);
    }
}

