/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.vdb.dynamic.ui.editor.dialogs;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.vdb.ui.VdbUiConstants;

public class AddLanguagePropertyDialog
extends MessageDialog {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(AddLanguagePropertyDialog.class);
    private Button btnOk;
    private final Set<String> existingNames;
    private String name;

    public AddLanguagePropertyDialog(Shell parentShell, Set<String> existingPropertyNames) {
        super(parentShell, VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "title", new Object[0]), null, VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "message", new Object[0]), 2, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.existingNames = existingPropertyNames == null ? new HashSet<String>(0) : existingPropertyNames;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button btn = super.createButton(parent, id, label, defaultButton);
        if (id == 0) {
            this.btnOk = btn;
            btn.setEnabled(false);
        }
        return btn;
    }

    protected Control createCustomArea(Composite parent) {
        Composite pnl = new Composite(parent, 0);
        pnl.setLayout((Layout)new GridLayout(2, false));
        pnl.setLayoutData((Object)new GridData(4, 4, true, true));
        Label lblName = new Label(pnl, 0);
        lblName.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        lblName.setText(VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "language", new Object[0]));
        Text txtName = new Text(pnl, 2048);
        txtName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        txtName.setToolTipText(VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "languageText.tooltip", new Object[0]));
        txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddLanguagePropertyDialog.this.handleNameChanged(((Text)e.widget).getText());
            }
        });
        return pnl;
    }

    public String getLanguage() {
        CoreArgCheck.isEqual((int)this.getReturnCode(), (int)0);
        return this.name;
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    void handleNameChanged(String newName) {
        this.name = newName;
        this.updateState();
    }

    private void updateState() {
        String msg = this.validateName();
        if (StringUtilities.isEmpty((String)msg)) {
            if (!this.btnOk.isEnabled()) {
                this.btnOk.setEnabled(true);
            }
            if (this.imageLabel.getImage() != null) {
                this.imageLabel.setImage(null);
            }
            this.imageLabel.setImage(this.getInfoImage());
            msg = VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "message", new Object[0]);
        } else {
            if (this.btnOk.isEnabled()) {
                this.btnOk.setEnabled(false);
            }
            this.imageLabel.setImage(this.getErrorImage());
        }
        this.messageLabel.setText(msg);
        this.messageLabel.pack();
    }

    private String validateName() {
        String errorMsg = this.validateName(this.name);
        if (errorMsg == null) {
            for (String existingName : this.existingNames) {
                if (!existingName.equals(this.name)) continue;
                errorMsg = VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "languageAlreadyExists", (Object)this.name);
                break;
            }
        }
        return errorMsg;
    }

    public String validateName(String proposedName) {
        if (StringUtilities.isEmpty((String)proposedName)) {
            return VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "emptyLanguageName", new Object[0]);
        }
        char[] cArray = proposedName.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isLetter(c)) {
                return VdbUiConstants.Util.getString(String.valueOf(PREFIX) + "invalidLanguageName", (Object)proposedName);
            }
            ++n2;
        }
        return null;
    }
}

