/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xsd.ui.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDConstrainingFacet;
import org.eclipse.xsd.XSDFacet;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDVariety;
import org.eclipse.xsd.provider.XSDSemanticItemProviderAdapterFactory;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.TransactionRunnable;
import org.teiid.designer.core.notification.util.SourcedNotificationUtilities;
import org.teiid.designer.core.transaction.SourcedNotification;
import org.teiid.designer.core.transaction.UnitOfWork;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.custom.impl.XsdModelAnnotationImpl;
import org.teiid.designer.ui.common.eventsupport.SelectionProvider;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;
import org.teiid.designer.ui.common.widget.DefaultContentProvider;
import org.teiid.designer.ui.editors.AbstractModelEditorPageActionBarContributor;
import org.teiid.designer.ui.editors.ModelEditorPage;
import org.teiid.designer.ui.editors.ModelEditorPageOutline;
import org.teiid.designer.ui.event.ModelResourceEvent;
import org.teiid.designer.ui.filter.StructuredViewerTextFilterer;
import org.teiid.designer.ui.forms.FormTextObjectEditor;
import org.teiid.designer.ui.forms.FormUtil;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.xsd.ui.ModelerXsdUiConstants;
import org.teiid.designer.xsd.ui.ModelerXsdUiPlugin;
import org.teiid.designer.xsd.ui.editor.GUIFacetHelper;
import org.teiid.designer.xsd.ui.editor.SimpleDatatypeEditorPanel;

public class XsdSimpleDatatypesEditorPage
extends EditorPart
implements ModelEditorPage {
    private static final String PAGE_NAME = GUIFacetHelper.getString("SimpleDatatypeEditor.name");
    private static final String PAGE_TOOLTIP = GUIFacetHelper.getString("SimpleDatatypeEditor.tooltip");
    private static final String BUTTON_DELETE = GUIFacetHelper.getString("SimpleDatatypeEditor.delete");
    private static final String BUTTON_NEW = GUIFacetHelper.getString("SimpleDatatypeEditor.new");
    private static final String BUTTON_CLEAR = GUIFacetHelper.getString("SimpleDatatypeEditor.clear");
    private static final String DEFAULT_FILTER_TEXT = GUIFacetHelper.getString("SimpleDatatypeEditor.defaultFilter");
    private static final String LABEL_LOCAL_ID = "SimpleDatatypeEditor.labelLocal";
    private static final String LABEL_BUILTIN = GUIFacetHelper.getString("SimpleDatatypeEditor.labelBuiltin");
    static final String LINK_SHOW_BUILT_IN_TYPES = GUIFacetHelper.getString("SimpleDatatypeEditor.show");
    static final String LINK_HIDE_BUILT_IN_TYPES = GUIFacetHelper.getString("SimpleDatatypeEditor.hide");
    static final String TRANSACTION_NEW = GUIFacetHelper.getString("SimpleDatatypeEditor.transaction_new");
    protected XSDSchema xsdSchema;
    Resource xsdResource;
    SimpleDatatypeEditorPanel editorPanel;
    private Composite mainControl;
    ListViewer localTypes;
    ListViewer builtInTypes;
    Object lastSel;
    private MyNotifyChangedListener myChgList = new MyNotifyChangedListener();
    private MyModelSelectionProvider mySelProv = new MyModelSelectionProvider();
    Button newBtn;
    Button rmvBtn;
    Object selectAtNextRefresh;
    boolean xsdResourceIsStale = false;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public String getTitle() {
        return PAGE_NAME;
    }

    public String getTitleToolTip() {
        return PAGE_TOOLTIP;
    }

    public boolean canDisplay(IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            return ModelUtil.isXsdFile((IResource)((IFileEditorInput)input).getFile());
        }
        return false;
    }

    public boolean canOpenContext(Object input) {
        if (input instanceof XsdModelAnnotationImpl) {
            return ((XsdModelAnnotationImpl)input).getResource().equals(this.xsdResource);
        }
        if (input instanceof XSDConcreteComponent) {
            return ((XSDConcreteComponent)input).getSchema().equals(this.getXsdSchema());
        }
        return false;
    }

    public void initializeEditorPage() {
    }

    public void openContext(Object input, boolean forceRefresh) {
        this.openContext(input);
    }

    public void openContext(final Object input) {
        final Resource resource = this.xsdResource;
        if (this.editorPanel != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ISelection selection;
                    ISelection newSel;
                    XSDSimpleTypeDefinition std = null;
                    if (input instanceof XSDSimpleTypeDefinition) {
                        std = (XSDSimpleTypeDefinition)ModelObjectUtilities.getRealEObject((EObject)((XSDSimpleTypeDefinition)input));
                    } else if (input instanceof XSDConstrainingFacet) {
                        XSDConstrainingFacet facet = (XSDConstrainingFacet)ModelObjectUtilities.getRealEObject((EObject)((XSDConstrainingFacet)input));
                        std = facet.getSimpleTypeDefinition();
                    }
                    if (ModelerCore.getDatatypeManager((EObject)XsdSimpleDatatypesEditorPage.this.getXsdSchema(), (boolean)true).isBuiltInDatatype((EObject)std)) {
                        XsdSimpleDatatypesEditorPage.this.builtInTypes.setSelection((ISelection)(std == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)std)));
                        newSel = XsdSimpleDatatypesEditorPage.this.builtInTypes.getSelection();
                    } else {
                        XsdSimpleDatatypesEditorPage.this.localTypes.setSelection((ISelection)(std == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)std)));
                        newSel = XsdSimpleDatatypesEditorPage.this.localTypes.getSelection();
                    }
                    XsdSimpleDatatypesEditorPage.this.editorPanel.setFocus();
                    if (newSel.isEmpty()) {
                        XsdSimpleDatatypesEditorPage.this.editorPanel.setInput(std);
                    }
                    if ((selection = newSel).isEmpty()) {
                        selection = new StructuredSelection(resource);
                    }
                    XsdSimpleDatatypesEditorPage.this.getModelObjectSelectionProvider().setSelection(selection);
                }
            });
        }
    }

    public Control getControl() {
        return this.mainControl;
    }

    public ISelectionProvider getModelObjectSelectionProvider() {
        return this.mySelProv;
    }

    public ISelectionChangedListener getModelObjectSelectionChangedListener() {
        return null;
    }

    public AbstractModelEditorPageActionBarContributor getActionBarContributor() {
        return null;
    }

    public void setLabelProvider(ILabelProvider provider) {
    }

    public INotifyChangedListener getNotifyChangedListener() {
        return this.myChgList;
    }

    public ModelEditorPageOutline getOutlineContribution() {
        return null;
    }

    public void updateReadOnlyState(boolean isReadOnly) {
        if (this.editorPanel != null && !this.editorPanel.isDisposed()) {
            this.editorPanel.setReadOnly(isReadOnly);
            this.rmvBtn.setEnabled(!isReadOnly);
            this.newBtn.setEnabled(!isReadOnly);
        }
    }

    public void setTitleText(String title) {
    }

    public void preDispose() {
    }

    public void openComplete() {
    }

    public void processEvent(EventObject obj) {
        ModelResourceEvent event = (ModelResourceEvent)obj;
        if (event.getType() == 6) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    XsdSimpleDatatypesEditorPage.this.refreshListAndEditor();
                }
            });
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        if (input instanceof IFileEditorInput) {
            try {
                IFile xsdFile = ((IFileEditorInput)input).getFile();
                if (xsdFile == null) {
                    String msg = ModelerXsdUiConstants.Util.getString("XsdEditor.Input_Error__Model_Editor_cannot_open_{0}_2", (Object)input.getName());
                    throw new PartInitException(msg);
                }
                String xsdLocation = xsdFile.getLocation().toString();
                URI xsdUri = URI.createFileURI((String)xsdLocation);
                this.xsdResource = ModelerCore.getModelContainer().getResource(xsdUri, true);
                if (this.xsdResource == null) {
                    String msg = ModelerXsdUiConstants.Util.getString("XsdEditor.Input_Error__Model_Editor_cannot_open_{0}_1", (Object)input.getName());
                    throw new PartInitException(msg);
                }
                xsdFile.getProject();
            }
            catch (ModelWorkspaceException e) {
                String msg = ModelerXsdUiConstants.Util.getString("XsdEditor.Input_Error__Model_Editor_cannot_open_{0}_2", (Object)input.getName());
                throw new PartInitException(msg, (Throwable)e);
            }
            catch (CoreException e) {
                String msg = ModelerXsdUiConstants.Util.getString("XsdEditor.Input_Error__Model_Editor_cannot_open_{0}_2", (Object)input.getName());
                throw new PartInitException(msg, (Throwable)e);
            }
        } else {
            throw new PartInitException(ModelerXsdUiConstants.Util.getString("XsdEditor.Invalid_Input__Must_be_IFileEditorInput._33", new Object[0]));
        }
    }

    public boolean isDirty() {
        Resource resource;
        XSDSchema xsdSchema = this.getXsdSchema();
        if (xsdSchema != null && (resource = xsdSchema.eResource()) != null) {
            return resource.isModified();
        }
        return false;
    }

    public void createPartControl(Composite parent) {
        this.mainControl = parent;
        parent.setLayout((Layout)new FillLayout());
        SashForm mainSash = new SashForm(parent, 256);
        FormToolkit ftk = ModelerXsdUiPlugin.getDefault().getFormToolkit(parent.getDisplay());
        Form leftPanel = ftk.createForm((Composite)mainSash);
        GridLayout gl = new GridLayout(2, false);
        leftPanel.getBody().setLayout((Layout)gl);
        this.newBtn = ftk.createButton(leftPanel.getBody(), BUTTON_NEW, 0);
        this.newBtn.setLayoutData((Object)new GridData(1, 1, true, false));
        this.rmvBtn = ftk.createButton(leftPanel.getBody(), BUTTON_DELETE, 0);
        this.rmvBtn.setLayoutData((Object)new GridData(0x1000008, 1, true, false));
        AdapterFactoryLabelProvider labelProv = new AdapterFactoryLabelProvider((AdapterFactory)new XSDSemanticItemProviderAdapterFactory());
        StructuredViewerTextFilterer svf = new StructuredViewerTextFilterer(DEFAULT_FILTER_TEXT, BUTTON_CLEAR, null, (ILabelProvider)labelProv);
        Control svfComp = svf.addControl(leftPanel.getBody(), ftk);
        svfComp.setLayoutData((Object)new GridData(4, 0x1000008, true, false, 2, 1));
        final SashForm typeSash = new SashForm(leftPanel.getBody(), 512);
        typeSash.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        final Section upperSection = ftk.createSection((Composite)typeSash, 352);
        upperSection.marginHeight = 0;
        upperSection.marginWidth = 0;
        Composite upperSectionContents = ftk.createComposite((Composite)upperSection);
        gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        upperSectionContents.setLayout((Layout)gl);
        upperSection.setClient((Control)upperSectionContents);
        IFile xsdFile = ((IFileEditorInput)this.getEditorInput()).getFile();
        upperSection.setText(ModelerXsdUiConstants.Util.getString(LABEL_LOCAL_ID, (Object)xsdFile.getName()));
        this.localTypes = new ListViewer(upperSectionContents, 2820);
        this.localTypes.setContentProvider((IContentProvider)new AtomicSimpleTypesContentProvider());
        this.localTypes.setLabelProvider((IBaseLabelProvider)labelProv);
        this.localTypes.setInput((Object)this.getXsdSchema());
        this.localTypes.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        FormTextObjectEditor ftoe = new FormTextObjectEditor(null, null, true){

            protected void valueClicked(Object value) {
                if (typeSash.getMaximizedControl() != null) {
                    typeSash.setMaximizedControl(null);
                    this.setValue(LINK_HIDE_BUILT_IN_TYPES);
                } else {
                    typeSash.setMaximizedControl((Control)upperSection);
                    this.setValue(LINK_SHOW_BUILT_IN_TYPES);
                }
            }
        };
        ftoe.addControl(FormUtil.getScrolledForm((Control)upperSectionContents), upperSectionContents, ftk);
        ftoe.getFormText().setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        ftoe.setValue((Object)LINK_HIDE_BUILT_IN_TYPES);
        Section lowerSection = ftk.createSection((Composite)typeSash, 352);
        lowerSection.marginHeight = 0;
        lowerSection.marginWidth = 0;
        lowerSection.setText(LABEL_BUILTIN);
        this.builtInTypes = new ListViewer((Composite)lowerSection, 2820);
        this.builtInTypes.setContentProvider((IContentProvider)new AtomicSimpleTypeArrayContentProvider());
        this.builtInTypes.setLabelProvider((IBaseLabelProvider)labelProv);
        try {
            this.builtInTypes.setInput((Object)ModelerCore.getDatatypeManager((EObject)this.getXsdSchema(), (boolean)true).getBuiltInDatatypes());
        }
        catch (ModelerCoreException err) {
            ModelerXsdUiConstants.Util.log((Throwable)err);
        }
        this.builtInTypes.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        lowerSection.setClient(this.builtInTypes.getControl());
        typeSash.setWeights(new int[]{1, 1});
        this.editorPanel = new SimpleDatatypeEditorPanel((Composite)mainSash);
        this.editorPanel.setSchema(this.getXsdSchema());
        mainSash.setWeights(new int[]{2, 7});
        svf.attachToViewer((StructuredViewer)this.localTypes, false);
        svf.attachToViewer((StructuredViewer)this.builtInTypes, false);
        this.localTypes.addSelectionChangedListener((ISelectionChangedListener)this.mySelProv);
        this.builtInTypes.addSelectionChangedListener((ISelectionChangedListener)this.mySelProv);
        this.localTypes.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (!selection.isEmpty()) {
                    boolean canRemove = false;
                    EObject selected = SelectionUtilities.getSelectedEObject((ISelection)selection);
                    final EObject resolvedSelected = ModelObjectUtilities.getRealEObject((EObject)selected);
                    if (resolvedSelected != selected) {
                        XsdSimpleDatatypesEditorPage.this.localTypes.refresh();
                    }
                    if (!FormUtil.safeEquals((Object)resolvedSelected, (Object)XsdSimpleDatatypesEditorPage.this.lastSel)) {
                        XsdSimpleDatatypesEditorPage.this.builtInTypes.setSelection(null);
                        XsdSimpleDatatypesEditorPage.this.lastSel = resolvedSelected;
                        UiBusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                (this).XsdSimpleDatatypesEditorPage.this.editorPanel.setInput((XSDSimpleTypeDefinition)resolvedSelected);
                            }
                        });
                    }
                    if (resolvedSelected != null) {
                        canRemove = !ModelObjectUtilities.isReadOnly((EObject)resolvedSelected);
                    }
                    XsdSimpleDatatypesEditorPage.this.rmvBtn.setEnabled(canRemove);
                } else {
                    XsdSimpleDatatypesEditorPage.this.lastSel = null;
                    XsdSimpleDatatypesEditorPage.this.rmvBtn.setEnabled(false);
                }
            }
        });
        this.builtInTypes.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (!selection.isEmpty()) {
                    final EObject selected = ModelObjectUtilities.getRealEObject((EObject)SelectionUtilities.getSelectedEObject((ISelection)selection));
                    if (!FormUtil.safeEquals((Object)selected, (Object)XsdSimpleDatatypesEditorPage.this.lastSel)) {
                        XsdSimpleDatatypesEditorPage.this.localTypes.setSelection(null);
                        XsdSimpleDatatypesEditorPage.this.lastSel = selected;
                        UiBusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                (this).XsdSimpleDatatypesEditorPage.this.editorPanel.setInput((XSDSimpleTypeDefinition)selected);
                            }
                        });
                    }
                } else {
                    XsdSimpleDatatypesEditorPage.this.lastSel = null;
                }
            }
        });
        this.newBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransactionRunnable runnable = new TransactionRunnable(){

                    public Object run(UnitOfWork uow) {
                        final XSDSimpleTypeDefinition newType = GUIFacetHelper.createType((this).XsdSimpleDatatypesEditorPage.this.newBtn.getShell(), XsdSimpleDatatypesEditorPage.this.getXsdSchema(), null);
                        if (newType != null) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ((this).this).XsdSimpleDatatypesEditorPage.this.localTypes.setSelection((ISelection)new StructuredSelection((Object)newType));
                                    if (((this).this).XsdSimpleDatatypesEditorPage.this.localTypes.getSelection().isEmpty()) {
                                        ((this).this).XsdSimpleDatatypesEditorPage.this.selectAtNextRefresh = newType;
                                    }
                                }
                            });
                        }
                        return null;
                    }
                };
                try {
                    ModelerCore.getModelEditor().executeAsTransaction(runnable, TRANSACTION_NEW, true, true, (Object)this);
                }
                catch (ModelerCoreException mce) {
                    ModelerXsdUiConstants.Util.log((Throwable)mce);
                }
            }
        });
        this.rmvBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EObject sel = SelectionUtilities.getSelectedEObject((ISelection)XsdSimpleDatatypesEditorPage.this.localTypes.getSelection());
                if (sel != null) {
                    ModelObjectUtilities.delete((EObject)sel, (boolean)true, (boolean)true, (Object)((Object)XsdSimpleDatatypesEditorPage.this));
                    XsdSimpleDatatypesEditorPage.this.editorPanel.setInput(null);
                }
            }
        });
    }

    public void setFocus() {
    }

    public XSDSchema getXsdSchema() {
        if (this.xsdSchema == null) {
            if (this.xsdResource != null && this.xsdResource instanceof XSDResourceImpl) {
                XSDResourceImpl rsrc = (XSDResourceImpl)this.xsdResource;
                this.xsdSchema = rsrc.getSchema();
            }
        } else if (this.xsdSchema.eIsProxy()) {
            this.xsdSchema = (XSDSchema)ModelObjectUtilities.getRealEObject((EObject)this.xsdSchema);
            if (this.xsdSchema != null && GUIFacetHelper.isReady((Control)this.editorPanel)) {
                this.editorPanel.setSchema(this.xsdSchema);
            }
        }
        return this.xsdSchema;
    }

    void refreshListAndEditor() {
        if (this.localTypes != null && !this.localTypes.getList().isDisposed()) {
            Object newSelection = null;
            if (this.selectAtNextRefresh == null) {
                EObject oldSelection = SelectionUtilities.getSelectedEObject((ISelection)this.localTypes.getSelection());
                if (oldSelection != null && oldSelection.eIsProxy()) {
                    newSelection = ModelObjectUtilities.getRealEObject((EObject)oldSelection);
                }
            } else {
                newSelection = this.selectAtNextRefresh;
                this.selectAtNextRefresh = null;
            }
            this.localTypes.refresh();
            ISelection selection = this.localTypes.getSelection();
            if (selection.isEmpty()) {
                if (newSelection != null) {
                    this.localTypes.setSelection((ISelection)new StructuredSelection(newSelection));
                } else {
                    this.editorPanel.setInput(null);
                }
            } else {
                this.editorPanel.setInput((XSDSimpleTypeDefinition)SelectionUtilities.getSelectedObject((ISelection)selection));
            }
        }
    }

    void validateResource() {
        if (!this.xsdResourceIsStale) {
            if (this.xsdResource == null) {
                this.xsdResourceIsStale = true;
            } else {
                XSDSchema schema = this.getXsdSchema();
                if (schema == null || schema.eResource() == null) {
                    this.xsdResourceIsStale = true;
                }
            }
        }
    }

    public boolean isSelectedFirst(IEditorInput input) {
        return false;
    }

    static class AtomicSimpleTypeArrayContentProvider
    extends DefaultContentProvider {
        AtomicSimpleTypeArrayContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] objects = (Object[])inputElement;
            ArrayList<XSDSimpleTypeDefinition> rv = new ArrayList<XSDSimpleTypeDefinition>(objects.length);
            int i = 0;
            while (i < objects.length) {
                XSDSimpleTypeDefinition std = (XSDSimpleTypeDefinition)objects[i];
                if (std.getVariety() == XSDVariety.ATOMIC_LITERAL) {
                    rv.add(std);
                }
                ++i;
            }
            return rv.toArray();
        }
    }

    static class AtomicSimpleTypesContentProvider
    extends DefaultContentProvider {
        AtomicSimpleTypesContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            XSDSchema x = (XSDSchema)ModelObjectUtilities.getRealEObject((EObject)((EObject)inputElement));
            EList allTypes = x.getTypeDefinitions();
            ArrayList<XSDSimpleTypeDefinition> rv = new ArrayList<XSDSimpleTypeDefinition>(allTypes.size());
            for (XSDTypeDefinition type : allTypes) {
                XSDSimpleTypeDefinition simptype;
                if (type.getSchema() != x || !(type instanceof XSDSimpleTypeDefinition) || (simptype = (XSDSimpleTypeDefinition)ModelObjectUtilities.getRealEObject((EObject)type)).getVariety() != XSDVariety.ATOMIC_LITERAL) continue;
                rv.add(simptype);
            }
            return rv.toArray();
        }
    }

    class MyModelSelectionProvider
    extends SelectionProvider
    implements ISelectionChangedListener {
        MyModelSelectionProvider() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            if (selection.isEmpty()) {
                if (XsdSimpleDatatypesEditorPage.this.localTypes.getSelection().isEmpty() && XsdSimpleDatatypesEditorPage.this.builtInTypes.getSelection().isEmpty()) {
                    this.setSelection(selection);
                }
            } else {
                this.setSelection(selection);
            }
        }
    }

    class MyNotifyChangedListener
    implements INotifyChangedListener {
        MyNotifyChangedListener() {
        }

        public void notifyChanged(Notification notification) {
            SourcedNotification sn;
            XsdSimpleDatatypesEditorPage.this.validateResource();
            if (XsdSimpleDatatypesEditorPage.this.xsdResourceIsStale) {
                return;
            }
            if (notification instanceof SourcedNotification) {
                sn = (SourcedNotification)notification;
                Object src = sn.getSource();
                if (src == XsdSimpleDatatypesEditorPage.this.editorPanel.getModel()) {
                    Set changedFeatures = SourcedNotificationUtilities.getAffectedFeatureIDs((SourcedNotification)sn, XSDSimpleTypeDefinition.class);
                    if (changedFeatures.contains(new Integer(5)) || changedFeatures.contains(new Integer(17))) {
                        this.safeRefreshLocal();
                    }
                    return;
                }
            } else {
                sn = null;
            }
            Set<Object> notifiers = sn != null ? SourcedNotificationUtilities.getAllNotifiers((SourcedNotification)sn) : Collections.singleton(notification.getNotifier());
            for (Object notifier : notifiers) {
                XSDSchema xsdc = null;
                if (notifier == XsdSimpleDatatypesEditorPage.this.xsdResource) {
                    xsdc = XsdSimpleDatatypesEditorPage.this.xsdSchema;
                } else if (notifier instanceof XSDSchema) {
                    xsdc = (XSDSchema)notifier;
                } else if (notifier instanceof XSDSimpleTypeDefinition) {
                    XSDSimpleTypeDefinition xstd = (XSDSimpleTypeDefinition)notifier;
                    xsdc = xstd.getSchema();
                } else if (notifier instanceof XSDFacet) {
                    XSDFacet xf = (XSDFacet)notifier;
                    XSDSimpleTypeDefinition simpleTypeDefinition = xf.getSimpleTypeDefinition();
                    if (simpleTypeDefinition == null && notification instanceof SourcedNotification) {
                        simpleTypeDefinition = this.findSimpleTypeDefinition(((SourcedNotification)notification).getNotifications());
                    }
                    if (XsdSimpleDatatypesEditorPage.this.lastSel != null && XsdSimpleDatatypesEditorPage.this.lastSel.equals(simpleTypeDefinition)) {
                        xsdc = simpleTypeDefinition.getSchema();
                    }
                } else if (notifier instanceof XSDAnnotation) {
                    XSDAnnotation xa = (XSDAnnotation)notifier;
                    if (XsdSimpleDatatypesEditorPage.this.lastSel != null && XsdSimpleDatatypesEditorPage.this.lastSel.equals(this.findSimpleType((XSDConcreteComponent)xa))) {
                        xsdc = xa.getSchema();
                    }
                }
                if (!XsdSimpleDatatypesEditorPage.this.getXsdSchema().equals(xsdc)) continue;
                XsdSimpleDatatypesEditorPage.this.refreshListAndEditor();
                break;
            }
        }

        private void safeRefreshLocal() {
            if (XsdSimpleDatatypesEditorPage.this.localTypes != null && !XsdSimpleDatatypesEditorPage.this.localTypes.getControl().isDisposed()) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ((MyNotifyChangedListener)MyNotifyChangedListener.this).XsdSimpleDatatypesEditorPage.this.localTypes.refresh();
                    }
                });
            }
        }

        private XSDSimpleTypeDefinition findSimpleTypeDefinition(Collection notifications) {
            for (Notification not : notifications) {
                Object notifier = not.getNotifier();
                if (!(notifier instanceof XSDSimpleTypeDefinition)) continue;
                return (XSDSimpleTypeDefinition)notifier;
            }
            return null;
        }

        private XSDSimpleTypeDefinition findSimpleType(XSDConcreteComponent xc) {
            XSDSimpleTypeDefinition rv = null;
            XSDConcreteComponent parent = xc.getContainer();
            while (parent != null) {
                if (parent instanceof XSDSimpleTypeDefinition) {
                    rv = (XSDSimpleTypeDefinition)parent;
                    break;
                }
                parent = parent.getContainer();
            }
            return rv;
        }
    }
}

