/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xsd.ui.editor;

import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.teiid.designer.ui.forms.DialogProvider;
import org.teiid.designer.xsd.ui.ModelerXsdUiConstants;
import org.teiid.designer.xsd.ui.editor.GUIFacetHelper;

public class TextDialogProvider
implements DialogProvider {
    private final String buttonText;
    protected Object value;
    private final String dialogTitle;
    private final String dialogDescriptionKey;

    public TextDialogProvider(String launchButtonText, String titleKey, String descriptionKey) {
        this.buttonText = launchButtonText;
        this.dialogTitle = titleKey != null ? GUIFacetHelper.getString(titleKey) : null;
        this.dialogDescriptionKey = descriptionKey;
    }

    public void showDialog(Shell shell, Object initialValue) {
        this.value = initialValue;
        String desc = this.getDescriptionText(initialValue);
        InputDialog idlg = new InputDialog(shell, this.dialogTitle, desc, (String)initialValue, null){

            protected Control createDialogArea(Composite parent) {
                Control control = super.createDialogArea(parent);
                this.getText().addTraverseListener(new TraverseListener(){

                    public void keyTraversed(TraverseEvent e) {
                        this.handleKeyTraversed(e);
                    }
                });
                return control;
            }

            void handleKeyTraversed(TraverseEvent e) {
                if (e.detail == 16) {
                    e.doit = false;
                    this.getButton(0).setFocus();
                }
            }
        };
        idlg.setBlockOnOpen(true);
        idlg.open();
        this.value = idlg.getValue();
    }

    public boolean wasCancelled() {
        return this.value == null;
    }

    public Object getValue() {
        return this.value;
    }

    public String getLaunchButtonText() {
        return this.buttonText;
    }

    protected String getDescriptionText(Object initialValue) {
        if (initialValue != null) {
            return ModelerXsdUiConstants.Util.getString(this.dialogDescriptionKey, initialValue);
        }
        return ModelerXsdUiConstants.Util.getString(this.dialogDescriptionKey, new Object[0]);
    }

    protected String getDialogTitleText() {
        return this.dialogTitle;
    }
}

