/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.xsd.ui.editor;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.teiid.designer.ui.forms.ComponentSetEvent;
import org.teiid.designer.ui.forms.ComponentSetMonitor;
import org.teiid.designer.ui.forms.LinkedComponentSet;
import org.teiid.designer.xsd.ui.editor.AbstractFacetSet;
import org.teiid.designer.xsd.ui.editor.GUIFacetHelper;
import org.teiid.designer.xsd.ui.editor.InclusiveInteger;

public class SpinnerFacetSet
extends AbstractFacetSet {
    private static final InclusiveInteger DEFAULT_VALUE = new InclusiveInteger(0, true);
    Spinner sp;
    Button incl;
    private MyListener myList;
    InclusiveInteger val;
    private final boolean needsInclusive;
    private final int min;
    private final int max;

    public SpinnerFacetSet(String id, String labelName, boolean needsInclusiveBox, int min, int max) {
        super(id, labelName, true, true);
        this.needsInclusive = needsInclusiveBox;
        this.min = min;
        this.max = max;
    }

    @Override
    protected void addMainControl(Composite parent, FormToolkit ftk, ComponentSetMonitor mon) {
        this.val = new InclusiveInteger(DEFAULT_VALUE);
        this.myList = new MyListener();
        this.sp = new Spinner(parent, 2112);
        this.sp.setMinimum(this.min);
        this.sp.setMaximum(this.max);
        ftk.adapt((Composite)this.sp);
        this.sp.addModifyListener((ModifyListener)this.myList);
        if (this.needsInclusive) {
            this.incl = ftk.createButton(parent, GUIFacetHelper.getString("SpinnerFacetSet.facetbutton.inclusive"), 32);
            this.incl.addSelectionListener((SelectionListener)this.myList);
        }
        this.myList.mon = mon;
    }

    @Override
    protected void setMainValue(Object value) {
        if (value == null || value == DEFAULT_VALUE) {
            this.val.copyValuesOf(DEFAULT_VALUE);
        } else if (value instanceof InclusiveInteger) {
            this.val.copyValuesOf((InclusiveInteger)value);
        } else if (value instanceof Integer) {
            Integer i = (Integer)value;
            this.val.value = i;
            this.val.isInclusive = false;
        }
        if (GUIFacetHelper.isReady((Control)this.sp)) {
            this.sp.setSelection(this.val.value);
        }
        if (this.needsInclusive && GUIFacetHelper.isReady((Control)this.incl)) {
            this.incl.setSelection(this.val.isInclusive);
        }
    }

    @Override
    public int getControlCount() {
        int cc = super.getControlCount();
        if (this.needsInclusive) {
            ++cc;
        }
        return cc;
    }

    class MyListener
    implements ModifyListener,
    SelectionListener {
        public ComponentSetMonitor mon;

        MyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (this.mon != null) {
                SpinnerFacetSet.this.sp.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        int newVal;
                        if (!((MyListener)MyListener.this).SpinnerFacetSet.this.sp.isDisposed() && ((MyListener)MyListener.this).SpinnerFacetSet.this.val.value != (newVal = ((MyListener)MyListener.this).SpinnerFacetSet.this.sp.getSelection())) {
                            ((MyListener)MyListener.this).SpinnerFacetSet.this.val.value = newVal;
                            MyListener.this.fireUpdate();
                        }
                    }
                });
            }
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.mon != null) {
                SpinnerFacetSet.this.val.isInclusive = SpinnerFacetSet.this.incl.getSelection();
                this.fireUpdate();
            }
        }

        void fireUpdate() {
            this.mon.update(new ComponentSetEvent((LinkedComponentSet)SpinnerFacetSet.this, false, (Object)SpinnerFacetSet.this.val.cloneValue()));
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

