/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.teiidimporter.ui.panels;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.TableItem;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.translators.SimpleProperty;
import org.teiid.designer.teiidimporter.ui.Activator;
import org.teiid.designer.teiidimporter.ui.Messages;
import org.teiid.designer.teiidimporter.ui.panels.AddGeneralPropertyDialog;
import org.teiid.designer.teiidimporter.ui.wizard.TeiidImportManager;
import org.teiid.designer.ui.common.table.TableViewerBuilder;
import org.teiid.designer.ui.common.util.WidgetFactory;

public class ImportPropertiesPanel {
    static final String PREFIX = I18nUtil.getPropertyPrefix(ImportPropertiesPanel.class);
    TableViewerBuilder propertiesViewerBuilder;
    Button addPropertyButton;
    Button removePropertyButton;
    TeiidImportManager importManager;

    public ImportPropertiesPanel(Composite parent, TeiidImportManager importManager) {
        this.importManager = importManager;
        this.createPanel(parent);
    }

    private void createPanel(Composite parent) {
        Group panel = WidgetFactory.createGroup((Composite)parent, (String)Messages.ImportPropertiesPanel_groupTitle, (int)4, (int)1, (int)1);
        GridData gd = new GridData(4, 4, true, false);
        gd.heightHint = 150;
        panel.setLayoutData((Object)gd);
        this.propertiesViewerBuilder = new TableViewerBuilder((Composite)panel, 68352);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.propertiesViewerBuilder.getTableViewer());
        this.propertiesViewerBuilder.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                Map<String, String> props = ImportPropertiesPanel.this.importManager.getOptionalImportProps();
                if (props.isEmpty()) {
                    return new Object[0];
                }
                ArrayList<SimpleProperty> properties = new ArrayList<SimpleProperty>();
                for (String key : props.keySet()) {
                    properties.add(new SimpleProperty(key, props.get(key)));
                }
                return properties.toArray(new SimpleProperty[0]);
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.propertiesViewerBuilder.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                SimpleProperty prop1 = (SimpleProperty)e1;
                SimpleProperty prop2 = (SimpleProperty)e2;
                return super.compare(viewer, (Object)prop1.getName(), (Object)prop2.getName());
            }
        });
        TableViewerColumn column = this.propertiesViewerBuilder.createColumn(16384, 50, 50, true);
        column.getColumn().setText(Messages.ImportPropertiesPanel_name);
        column.setLabelProvider((CellLabelProvider)new PropertyLabelProvider(0));
        column = this.propertiesViewerBuilder.createColumn(16384, 50, 50, true);
        column.getColumn().setText(Messages.ImportPropertiesPanel_value);
        column.setLabelProvider((CellLabelProvider)new PropertyLabelProvider(1));
        column.setEditingSupport((EditingSupport)new PropertyNameEditingSupport((ColumnViewer)this.propertiesViewerBuilder.getTableViewer(), 1));
        this.propertiesViewerBuilder.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ImportPropertiesPanel.this.handlePropertySelected();
            }
        });
        Composite toolbarPanel = WidgetFactory.createPanel((Composite)panel, (int)0, (int)2, (int)1, (int)2);
        this.addPropertyButton = WidgetFactory.createButton((Composite)toolbarPanel, (int)4);
        this.addPropertyButton.setImage(Activator.getDefault().getImage("icons/add_property.png"));
        this.addPropertyButton.setToolTipText(Messages.ImportPropertiesPanel_addNewPropertyButton_tooltip);
        this.addPropertyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImportPropertiesPanel.this.handleAddProperty();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removePropertyButton = WidgetFactory.createButton((Composite)toolbarPanel, (int)4);
        this.removePropertyButton.setImage(Activator.getDefault().getImage("icons/remove_property.png"));
        this.removePropertyButton.setToolTipText(Messages.ImportPropertiesPanel_removePropertyButton_tooltip);
        this.removePropertyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImportPropertiesPanel.this.handleRemoveProperty();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removePropertyButton.setEnabled(false);
        this.propertiesViewerBuilder.setInput((Object)this);
    }

    void handlePropertySelected() {
        boolean hasSelection = !this.propertiesViewerBuilder.getSelection().isEmpty();
        this.removePropertyButton.setEnabled(hasSelection);
    }

    private SimpleProperty getSelectedProperty() {
        IStructuredSelection selection = (IStructuredSelection)this.propertiesViewerBuilder.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return (SimpleProperty)selection.getFirstElement();
    }

    void handleAddProperty() {
        assert (!this.propertiesViewerBuilder.getSelection().isEmpty());
        AddGeneralPropertyDialog dialog = new AddGeneralPropertyDialog(this.propertiesViewerBuilder.getControl().getShell(), this.importManager.getOptionalImportProps().keySet());
        if (dialog.open() == 0) {
            String name = dialog.getName();
            String value = dialog.getValue();
            this.importManager.addOptionalImportProperty(name, value);
            this.propertiesViewerBuilder.getTableViewer().refresh();
            SimpleProperty prop = null;
            TableItem[] tableItemArray = this.propertiesViewerBuilder.getTable().getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item.getData() instanceof SimpleProperty && ((SimpleProperty)item.getData()).getName().equals(name)) {
                    prop = (SimpleProperty)item.getData();
                    break;
                }
                ++n2;
            }
            if (prop != null) {
                this.propertiesViewerBuilder.getTableViewer().setSelection((ISelection)new StructuredSelection(prop), true);
            }
        }
    }

    void handleRemoveProperty() {
        SimpleProperty selectedProperty = this.getSelectedProperty();
        assert (selectedProperty != null);
        this.importManager.removeOptionalImportProperty(selectedProperty.getName());
        this.propertiesViewerBuilder.getTableViewer().refresh();
    }

    class PropertyLabelProvider
    extends ColumnLabelProvider {
        private final int columnID;

        public PropertyLabelProvider(int columnID) {
            this.columnID = columnID;
        }

        public String getText(Object element) {
            if (element instanceof SimpleProperty) {
                if (this.columnID == 0) {
                    return ((SimpleProperty)element).getName();
                }
                if (this.columnID == 1) {
                    return ((SimpleProperty)element).getValue();
                }
            }
            return super.getText(element);
        }
    }

    class PropertyNameEditingSupport
    extends EditingSupport {
        int columnID;
        private TextCellEditor editor;

        public PropertyNameEditingSupport(ColumnViewer viewer, int columnID) {
            super(viewer);
            this.columnID = columnID;
            this.editor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            if (element instanceof SimpleProperty) {
                if (this.columnID == 0) {
                    return ((SimpleProperty)element).getName();
                }
                if (this.columnID == 1) {
                    return ((SimpleProperty)element).getValue();
                }
            }
            return 0;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof SimpleProperty) {
                if (this.columnID == 0) {
                    String oldKey = ((SimpleProperty)element).getName();
                    String oldValue = ((SimpleProperty)element).getValue();
                    String newKey = (String)value;
                    if (newKey != null && newKey.length() > 0 && !newKey.equalsIgnoreCase(oldKey)) {
                        ImportPropertiesPanel.this.importManager.removeOptionalImportProperty(oldKey);
                        ImportPropertiesPanel.this.importManager.addOptionalImportProperty(newKey, oldValue);
                        ImportPropertiesPanel.this.propertiesViewerBuilder.getTableViewer().refresh();
                    }
                } else if (this.columnID == 1) {
                    String key = ((SimpleProperty)element).getName();
                    String oldValue = ((SimpleProperty)element).getValue();
                    String newValue = (String)value;
                    if (newValue != null && newValue.length() > 0 && !newValue.equalsIgnoreCase(oldValue)) {
                        ImportPropertiesPanel.this.importManager.addOptionalImportProperty(key, newValue);
                        ImportPropertiesPanel.this.propertiesViewerBuilder.getTableViewer().refresh();
                    }
                }
            }
        }
    }
}

