/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.modeshape.jcr.attributes;

import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.modeshape.jcr.Messages;
import org.jboss.tools.modeshape.jcr.Utils;
import org.jboss.tools.modeshape.jcr.attributes.ListAttributeState;
import org.jboss.tools.modeshape.jcr.cnd.CndElement;

public final class QueryOperators
extends ListAttributeState<QueryOperator> {
    public static final String[] NOTATION = new String[]{"queryops", "qop", "qop"};

    public QueryOperators() {
        QueryOperator[] queryOperatorArray = QueryOperator.values();
        int n = queryOperatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            QueryOperator operator = queryOperatorArray[n2];
            this.add(operator);
            ++n2;
        }
    }

    @Override
    public boolean add(String operator) {
        Utils.verifyIsNotEmpty(operator, "operator");
        return this.add(QueryOperator.find(operator));
    }

    @Override
    protected String getCndNotationPrefix(CndElement.NotationType notationType) {
        if (CndElement.NotationType.LONG == notationType) {
            return NOTATION[0];
        }
        if (CndElement.NotationType.COMPRESSED == notationType) {
            return NOTATION[1];
        }
        return NOTATION[2];
    }

    @Override
    protected String getCndNotationSuffix(CndElement.NotationType notationType) {
        return this.isVariant() ? "" : "'";
    }

    @Override
    protected String getItemQuoteCharacter() {
        return "";
    }

    @Override
    protected String getPrefixEndDelimiter(CndElement.NotationType notationType) {
        return " " + (this.isVariant() ? "" : "'");
    }

    @Override
    public int hashCode() {
        int result = 0;
        QueryOperator[] queryOperatorArray = QueryOperator.values();
        int n = queryOperatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            QueryOperator operator = queryOperatorArray[n2];
            if (this.supports(operator)) {
                result = Utils.hashCode(result, operator);
            }
            ++n2;
        }
        return super.hashCode();
    }

    @Override
    public boolean remove(String operator) {
        Utils.verifyIsNotEmpty(operator, "operator");
        return this.remove(QueryOperator.find(operator));
    }

    private boolean supportsAll() {
        QueryOperator[] queryOperatorArray = QueryOperator.values();
        int n = queryOperatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            QueryOperator operator = queryOperatorArray[n2];
            if (!this.supports(operator)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String[] toArray() {
        List operators = this.getSupportedItems();
        if (Utils.isEmpty(operators)) {
            return Utils.EMPTY_STRING_ARRAY;
        }
        String[] result = new String[operators.size()];
        int i = 0;
        for (QueryOperator operator : operators) {
            result[i++] = operator.toString();
        }
        return result;
    }

    @Override
    public String toCndNotation(CndElement.NotationType notationType) {
        if (this.supportsAll()) {
            return "";
        }
        return super.toCndNotation(notationType);
    }

    public static enum QueryOperator implements CndElement
    {
        EQUALS("=", "jcr.operator.equal.to"),
        GREATER_THAN(">", "jcr.operator.equal.to"),
        GREATER_THAN_EQUALS(">=", "jcr.operator.equal.to"),
        LESS_THAN("<", "jcr.operator.equal.to"),
        LESS_THAN_EQUALS("<=", "jcr.operator.equal.to"),
        LIKE("LIKE", "jcr.operator.equal.to"),
        NOT_EQUALS("<>", "jcr.operator.equal.to");

        private final String jcrValue;
        private final String notation;

        public static QueryOperator find(String notation) {
            QueryOperator[] queryOperatorArray = QueryOperator.values();
            int n = queryOperatorArray.length;
            int n2 = 0;
            while (n2 < n) {
                QueryOperator operator = queryOperatorArray[n2];
                if (operator.notation.equals(notation)) {
                    return operator;
                }
                ++n2;
            }
            throw new IllegalArgumentException(NLS.bind((String)Messages.invalidFindRequest, (Object)notation));
        }

        public static QueryOperator findUsingJcrValue(String jcrValue) {
            QueryOperator[] queryOperatorArray = QueryOperator.values();
            int n = queryOperatorArray.length;
            int n2 = 0;
            while (n2 < n) {
                QueryOperator operator = queryOperatorArray[n2];
                if (operator.asJcrValue().equals(jcrValue)) {
                    return operator;
                }
                ++n2;
            }
            throw new IllegalArgumentException(NLS.bind((String)Messages.invalidFindUsingJcrValueRequest, (Object)jcrValue));
        }

        private QueryOperator(String notation, String jcrValue) {
            this.notation = notation;
            this.jcrValue = jcrValue;
        }

        public String asJcrValue() {
            return this.jcrValue;
        }

        @Override
        public String toCndNotation(CndElement.NotationType notationType) {
            return this.toString();
        }

        public String toString() {
            return this.notation;
        }
    }
}

