/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;
import org.teiid.core.designer.util.ModelType;
import org.teiid.designer.metamodels.core.CoreMetamodelPlugin;

public final class ModelType
extends AbstractEnumerator {
    public static final String copyright = "See the LEGAL.txt file distributed with this work for information regarding copyright ownership and licensing.";
    public static final int PHYSICAL = ModelType.Type.PHYSICAL.getValue();
    public static final int VIRTUAL = ModelType.Type.VIRTUAL.getValue();
    public static final int TYPE = ModelType.Type.TYPE.getValue();
    public static final int VDB_ARCHIVE = ModelType.Type.VDB_ARCHIVE.getValue();
    public static final int UNKNOWN = ModelType.Type.UNKNOWN.getValue();
    public static final int FUNCTION = ModelType.Type.FUNCTION.getValue();
    public static final int CONFIGURATION = ModelType.Type.CONFIGURATION.getValue();
    public static final int METAMODEL = ModelType.Type.METAMODEL.getValue();
    public static final int EXTENSION = ModelType.Type.EXTENSION.getValue();
    public static final int LOGICAL = ModelType.Type.LOGICAL.getValue();
    public static final int MATERIALIZATION = ModelType.Type.MATERIALIZATION.getValue();
    public static final ModelType PHYSICAL_LITERAL = new ModelType(ModelType.Type.PHYSICAL);
    public static final ModelType VIRTUAL_LITERAL = new ModelType(ModelType.Type.VIRTUAL);
    public static final ModelType TYPE_LITERAL = new ModelType(ModelType.Type.TYPE);
    public static final ModelType VDB_ARCHIVE_LITERAL = new ModelType(ModelType.Type.VDB_ARCHIVE);
    public static final ModelType UNKNOWN_LITERAL = new ModelType(ModelType.Type.UNKNOWN);
    public static final ModelType FUNCTION_LITERAL = new ModelType(ModelType.Type.FUNCTION);
    public static final ModelType CONFIGURATION_LITERAL = new ModelType(ModelType.Type.CONFIGURATION);
    public static final ModelType METAMODEL_LITERAL = new ModelType(ModelType.Type.METAMODEL);
    public static final ModelType EXTENSION_LITERAL = new ModelType(ModelType.Type.EXTENSION);
    public static final ModelType LOGICAL_LITERAL = new ModelType(ModelType.Type.LOGICAL);
    public static final ModelType MATERIALIZATION_LITERAL = new ModelType(ModelType.Type.MATERIALIZATION);
    private static final ModelType[] VALUES_ARRAY = new ModelType[]{PHYSICAL_LITERAL, VIRTUAL_LITERAL, TYPE_LITERAL, VDB_ARCHIVE_LITERAL, UNKNOWN_LITERAL, FUNCTION_LITERAL, CONFIGURATION_LITERAL, METAMODEL_LITERAL, EXTENSION_LITERAL, LOGICAL_LITERAL, MATERIALIZATION_LITERAL};
    public static final List<ModelType> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static ModelType get(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ModelType result = VALUES_ARRAY[i];
            if (result.toString().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ModelType get(int value) {
        ModelType.Type type = ModelType.Type.getType((int)value);
        switch (type) {
            case PHYSICAL: {
                return PHYSICAL_LITERAL;
            }
            case VIRTUAL: {
                return VIRTUAL_LITERAL;
            }
            case TYPE: {
                return TYPE_LITERAL;
            }
            case VDB_ARCHIVE: {
                return VDB_ARCHIVE_LITERAL;
            }
            case UNKNOWN: {
                return UNKNOWN_LITERAL;
            }
            case FUNCTION: {
                return FUNCTION_LITERAL;
            }
            case CONFIGURATION: {
                return CONFIGURATION_LITERAL;
            }
            case METAMODEL: {
                return METAMODEL_LITERAL;
            }
            case EXTENSION: {
                return EXTENSION_LITERAL;
            }
            case LOGICAL: {
                return LOGICAL_LITERAL;
            }
            case MATERIALIZATION: {
                return MATERIALIZATION_LITERAL;
            }
        }
        return null;
    }

    public ModelType(ModelType.Type type) {
        super(type.getValue(), type.getName());
    }

    public final String getDisplayName() {
        String label = CoreMetamodelPlugin.getPluginResourceLocator().getString("_UI_ModelType_" + this.getName());
        return label == null || label.length() == 0 ? this.getName() : label;
    }
}

