/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.util;

import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.metamodels.relational.DirectionKind;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.ProcedureParameter;

public class PushdownFunctionUtil {
    private PushdownFunctionUtil() {
    }

    public static String getSignature(Procedure proc) {
        String paramSig;
        int directionKind;
        DirectionKind direction;
        String name = proc.getName();
        StringBuffer sb = new StringBuffer();
        sb.append(name);
        sb.append('(');
        boolean isFirst = true;
        for (ProcedureParameter param : proc.getParameters()) {
            direction = param.getDirection();
            directionKind = direction.getValue();
            if (directionKind != 0 && directionKind != 2) continue;
            if (!isFirst) {
                sb.append(',');
            }
            paramSig = PushdownFunctionUtil.getSignature(param);
            sb.append(paramSig);
            isFirst = false;
        }
        sb.append(')');
        for (ProcedureParameter param : proc.getParameters()) {
            direction = param.getDirection();
            directionKind = direction.getValue();
            if (directionKind != 3) continue;
            sb.append(':');
            paramSig = PushdownFunctionUtil.getSignature(param);
            sb.append(paramSig);
        }
        return sb.toString();
    }

    public static String getSignature(ProcedureParameter param) {
        EObject type = param.getType();
        DatatypeManager dtMgr = ModelerCore.getDatatypeManager((EObject)param, (boolean)true);
        String typeName = dtMgr.getName(type);
        return typeName;
    }
}

