/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.aspects.validation.rules;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.validation.StructuralFeatureValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.RelationalPlugin;
import org.teiid.designer.metamodels.relational.Table;

public class TableMaterializedRule
implements StructuralFeatureValidationRule {
    private final int featureID;
    private static Collection COLUMN_TYPES_THAT_CANNOT_BE_MATERIALIZED;

    public TableMaterializedRule(int featureID) {
        this.featureID = featureID;
    }

    public void validate(EStructuralFeature eStructuralFeature, EObject eObject, Object value, ValidationContext context) {
        boolean materialized;
        if (eStructuralFeature.getFeatureID() != this.featureID) {
            return;
        }
        if (eObject == null || !(eObject instanceof Table)) {
            return;
        }
        ValidationResultImpl result = null;
        if (value instanceof Boolean && (materialized = ((Boolean)value).booleanValue())) {
            EmfResource emfResource;
            ModelAnnotation modelAnn;
            boolean virtual = false;
            Resource resource = eObject.eResource();
            if (resource instanceof EmfResource && (modelAnn = (emfResource = (EmfResource)resource).getModelAnnotation()) != null && ModelType.VIRTUAL_LITERAL.equals(modelAnn.getModelType())) {
                virtual = true;
            }
            if (virtual) {
                Table table = (Table)eObject;
                Collection invalidTypes = this.getColumnTypesThatCannotBeMaterialized(context);
                EList columns = table.getColumns();
                for (Column column : columns) {
                    boolean invalid;
                    EObject datatype = column.getType();
                    if (datatype == null || !(invalid = invalidTypes.contains(datatype))) continue;
                    result = new ValidationResultImpl((Object)eObject);
                    String msg = RelationalPlugin.Util.getString("TableMaterializedRule.MaterializedTableFromInvalidColumnTypes", new Object[0]);
                    ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
                    result.addProblem((ValidationProblem)problem);
                    context.addResult((ValidationResult)result);
                    return;
                }
            }
        }
        if (value == null) {
            return;
        }
    }

    protected Collection getColumnTypesThatCannotBeMaterialized(ValidationContext context) {
        if (COLUMN_TYPES_THAT_CANNOT_BE_MATERIALIZED == null) {
            HashSet<EObject> types = new HashSet<EObject>();
            DatatypeManager dtMgr = context.getDatatypeManager();
            if (dtMgr != null) {
                try {
                    EObject datatype = null;
                    datatype = dtMgr.findDatatype("object");
                    if (datatype != null) {
                        types.add(datatype);
                    }
                }
                catch (ModelerCoreException err) {
                    RelationalPlugin.Util.log((Throwable)err);
                }
            }
            COLUMN_TYPES_THAT_CANNOT_BE_MATERIALIZED = types;
        }
        return COLUMN_TYPES_THAT_CANNOT_BE_MATERIALIZED;
    }
}

