/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.aspects.validation.rules;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.RelationalPlugin;
import org.teiid.designer.metamodels.relational.Table;

public class TableChildrenUpdatabilityRule
implements ObjectValidationRule {
    public void validate(EObject eObject, ValidationContext context) {
        CoreArgCheck.isInstanceOf(Table.class, (Object)eObject);
        Table table = (Table)eObject;
        if (!table.isSupportsUpdate()) {
            return;
        }
        EList columns = table.getColumns();
        if (!columns.isEmpty()) {
            Iterator columnIter = columns.iterator();
            boolean hasUpdatableColumn = false;
            while (columnIter.hasNext()) {
                Column column = (Column)columnIter.next();
                if (!column.isUpdateable()) continue;
                hasUpdatableColumn = true;
            }
            if (!hasUpdatableColumn) {
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 2, this.getProblemMessage(table));
                ValidationResultImpl result = new ValidationResultImpl((Object)eObject);
                result.addProblem((ValidationProblem)problem);
                context.addResult((ValidationResult)result);
            }
        }
    }

    protected String getProblemMessage(Table tableObject) {
        return RelationalPlugin.Util.getString("TableChildrenUpdatabilityRule.The_table_{0},_is_updatable_but_does_not_have_any_updatable_columns._1", (Object)tableObject.getName());
    }
}

