/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.relational.aspects.validation.rules;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.validation.StructuralFeatureValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.RelationalPlugin;

public class ColumnDatatypeRule
implements StructuralFeatureValidationRule {
    private static final String EMPTY_STR = "";
    private static final String NAME_SF_NAME = "name";
    private int featureID;

    public ColumnDatatypeRule(int featureID) {
        this.featureID = featureID;
    }

    public void validate(EStructuralFeature eStructuralFeature, EObject eObject, Object value, ValidationContext context) {
        String msg;
        Object[] params;
        EObject resolvedDatatype;
        if (eStructuralFeature.getFeatureID() != this.featureID) {
            return;
        }
        if (eObject == null || !(eObject instanceof Column)) {
            return;
        }
        ValidationResultImpl result = new ValidationResultImpl((Object)eObject);
        if (value == null) {
            return;
        }
        if (!(value instanceof EObject)) {
            return;
        }
        EObject dt = (EObject)value;
        ResourceSet resourceSet = eObject.eResource().getResourceSet();
        if (dt.eIsProxy() && (resolvedDatatype = EcoreUtil.resolve((EObject)dt, (ResourceSet)resourceSet)) == null) {
            Object[] params2 = new Object[]{((Column)eObject).getName(), ((InternalEObject)dt).eProxyURI()};
            String msg2 = RelationalPlugin.Util.getString("ColumnDatatypeRule.Column_0_references_a_datatype_1_that_cannot_be_resolved_in_the_workspace_2", params2);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 2, msg2);
            result.addProblem((ValidationProblem)problem);
            context.addResult((ValidationResult)result);
            return;
        }
        DatatypeManager dtMgr = context.getDatatypeManager();
        if (!dtMgr.isSimpleDatatype(dt)) {
            Object[] params3 = new Object[]{((Column)eObject).getName()};
            String msg3 = RelationalPlugin.Util.getString("ColumnDatatypeRule.Column_{0}__s_type_attribute_is_not_an_instance_of_XSDSimpleTypeDefinition_1", params3);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg3);
            result.addProblem((ValidationProblem)problem);
            context.addResult((ValidationResult)result);
            return;
        }
        if (!dtMgr.isEnterpriseDatatype(dt)) {
            Object[] params4 = new Object[]{((Column)eObject).getName()};
            String msg4 = RelationalPlugin.Util.getString("ColumnDatatypeRule.type_must_be_enterprise_type", params4);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 2, msg4);
            result.addProblem((ValidationProblem)problem);
            context.addResult((ValidationResult)result);
        }
        if (dtMgr.isBuiltInDatatype(dt)) {
            try {
                String uuid = dtMgr.getUuidString(dt);
                if (uuid != null && dtMgr.findDatatype(uuid) == null) {
                    params = new Object[]{((Column)eObject).getName(), this.getDisplayValue(dt)};
                    msg = RelationalPlugin.Util.getString("ColumnDatatypeRule.Column_0_references_a_datatype_1_that_cannot_be_resolved_in_the_workspace_3", params);
                    ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
                    result.addProblem((ValidationProblem)problem);
                    context.addResult((ValidationResult)result);
                    return;
                }
            }
            catch (Exception e) {
                RelationalPlugin.Util.log(4, (Throwable)e, e.getMessage());
            }
        } else {
            URI typeUri;
            Resource resource;
            Resource actualResource = dt.eResource();
            if (actualResource == null) {
                params = new Object[]{((Column)eObject).getName(), this.getDisplayValue(dt)};
                msg = RelationalPlugin.Util.getString("ColumnDatatypeRule.Column_0_references_a_datatype_1_that_cannot_be_resolved_in_the_workspace_3", params);
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
                result.addProblem((ValidationProblem)problem);
                context.addResult((ValidationResult)result);
                return;
            }
            if (ModelerCore.DEBUG_VALIDATION && ((resource = resourceSet.getResource((typeUri = EcoreUtil.getURI((EObject)dt)).trimFragment(), false)) == null || resource != actualResource || resource.getEObject(typeUri.fragment()) == null)) {
                Object[] params5 = new Object[]{((Column)eObject).getName(), this.getDisplayValue(dt)};
                String msg5 = RelationalPlugin.Util.getString("ColumnDatatypeRule.Column_0_references_a_datatype_1_that_cannot_be_resolved_in_the_workspace_3", params5);
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg5);
                result.addProblem((ValidationProblem)problem);
                context.addResult((ValidationResult)result);
                return;
            }
        }
    }

    private String getDisplayValue(EObject eObject) {
        if (eObject == null) {
            return EMPTY_STR;
        }
        EStructuralFeature name = eObject.eClass().getEStructuralFeature(NAME_SF_NAME);
        if (name != null) {
            Object val = eObject.eGet(name);
            if (val == null) {
                return EMPTY_STR;
            }
            return val.toString();
        }
        return eObject.eClass().getName();
    }
}

