/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.relational.Index;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.relational.model.RelationalModel;
import org.teiid.designer.relational.model.RelationalModelFactory;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.relational.model.RelationalTable;
import org.teiid.designer.relational.ui.Messages;
import org.teiid.designer.relational.ui.UiConstants;
import org.teiid.designer.relational.ui.UiPlugin;
import org.teiid.designer.relational.ui.edit.RelationalDialogModel;
import org.teiid.designer.relational.ui.editor.EditRelationalObjectDialog;
import org.teiid.designer.type.IDataTypeManagerService;
import org.teiid.designer.ui.actions.INewChildAction;
import org.teiid.designer.ui.actions.INewSiblingAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class CreateRelationalTableAction
extends Action
implements INewChildAction,
INewSiblingAction {
    private IFile selectedModel;
    public static final String TITLE = Messages.baseTableActionText;
    private Collection<String> datatypes;

    public CreateRelationalTableAction() {
        super(TITLE);
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/obj16/new-relational-table.png"));
        IDataTypeManagerService service = ModelerCore.getTeiidDataTypeManagerService();
        Set unsortedDatatypes = service.getAllDataTypeNames();
        this.datatypes = new ArrayList<String>();
        Object[] sortedStrings = unsortedDatatypes.toArray(new String[unsortedDatatypes.size()]);
        Arrays.sort(sortedStrings);
        Object[] objectArray = sortedStrings;
        int n = sortedStrings.length;
        int n2 = 0;
        while (n2 < n) {
            Object dType = objectArray[n2];
            this.datatypes.add((String)dType);
            ++n2;
        }
    }

    public boolean canCreateChild(EObject parent) {
        return false;
    }

    public boolean canCreateChild(IFile modelFile) {
        return this.isApplicable((ISelection)new StructuredSelection((Object)modelFile));
    }

    public boolean canCreateSibling(EObject parent) {
        if (!(parent instanceof Table || parent instanceof Procedure || parent instanceof Index)) {
            return false;
        }
        ModelResource mr = ModelUtilities.getModelResourceForModelObject((EObject)parent);
        if (mr != null) {
            IFile modelFile = null;
            try {
                modelFile = (IFile)mr.getCorrespondingResource();
            }
            catch (ModelWorkspaceException ex) {
                UiConstants.Util.log((Throwable)ex);
            }
            if (modelFile != null) {
                return this.isApplicable((ISelection)new StructuredSelection((Object)modelFile));
            }
        }
        return false;
    }

    public boolean isApplicable(ISelection selection) {
        IResource iRes;
        Object obj;
        boolean result = false;
        if (!SelectionUtilities.isMultiSelection((ISelection)selection) && (obj = SelectionUtilities.getSelectedObject((ISelection)selection)) instanceof IResource && (ModelIdentifier.isRelationalSourceModel((IResource)(iRes = (IResource)obj)) || ModelIdentifier.isRelationshipModel((IResource)iRes))) {
            this.selectedModel = (IFile)obj;
            result = true;
        }
        return result;
    }

    public void run() {
        if (this.selectedModel != null) {
            ModelResource mr = ModelUtilities.getModelResource((Object)this.selectedModel);
            Shell shell = UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
            RelationalTable table = new RelationalTable();
            table.setSupportsUpdate(true);
            RelationalDialogModel dialogModel = new RelationalDialogModel((RelationalReference)table, this.selectedModel);
            EditRelationalObjectDialog dialog = new EditRelationalObjectDialog(shell, dialogModel);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                this.createTableInTxn(mr, table);
            }
        }
    }

    private void createTableInTxn(ModelResource modelResource, RelationalTable table) {
        boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)Messages.createRelationalTableTitle, (Object)((Object)this));
        boolean succeeded = false;
        try {
            try {
                ModelEditor editor = ModelEditorManager.getModelEditorForFile((IFile)((IFile)modelResource.getCorrespondingResource()), (boolean)true);
                if (editor != null) {
                    boolean isDirty = editor.isDirty();
                    RelationalModelFactory factory = new RelationalModelFactory();
                    RelationalModel relModel = new RelationalModel("dummy");
                    relModel.addChild((RelationalReference)table);
                    factory.build(modelResource, relModel, (IProgressMonitor)new NullProgressMonitor());
                    if (!isDirty && editor.isDirty()) {
                        editor.doSave((IProgressMonitor)new NullProgressMonitor());
                    }
                    succeeded = true;
                }
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.createRelationalTableExceptionMessage, (String)e.getMessage());
                Status status = new Status(4, "org.teiid.designer.relational.ui", Messages.createRelationalTableExceptionMessage, (Throwable)e);
                UiConstants.Util.log((IStatus)status);
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                return;
            }
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }
}

