/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.flow;

import java.util.Iterator;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.Association;
import org.eclipse.bpmn2.AssociationDirection;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.CompensateEventDefinition;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.Gateway;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2UpdateFeature;
import org.eclipse.bpmn2.modeler.core.features.BaseElementConnectionFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.DefaultDeleteBPMNShapeFeature;
import org.eclipse.bpmn2.modeler.core.features.flow.AbstractAddFlowFeature;
import org.eclipse.bpmn2.modeler.core.features.flow.AbstractCreateFlowFeature;
import org.eclipse.bpmn2.modeler.core.features.flow.AbstractReconnectFlowFeature;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.bpmn2.modeler.ui.features.flow.Messages;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddConnectionContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.DeleteContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;

public class AssociationFeatureContainer
extends BaseElementConnectionFeatureContainer {
    public static final String ASSOCIATION_DIRECTION = "association.direction";
    public static final String ARROWHEAD_DECORATOR = "arrowhead.decorator";

    public boolean canApplyTo(Object o) {
        return super.canApplyTo(o) && o instanceof Association;
    }

    public IAddFeature getAddFeature(IFeatureProvider fp) {
        return new AddAssociationFeature(fp);
    }

    public ICreateConnectionFeature getCreateConnectionFeature(IFeatureProvider fp) {
        return new CreateAssociationFeature(fp);
    }

    public IUpdateFeature getUpdateFeature(IFeatureProvider fp) {
        return new UpdateAssociationFeature(fp);
    }

    public IReconnectionFeature getReconnectionFeature(IFeatureProvider fp) {
        return new ReconnectAssociationFeature(fp);
    }

    public IDeleteFeature getDeleteFeature(IFeatureProvider fp) {
        return new DeleteAssociationFeature(fp);
    }

    private static void setAssociationDirection(Connection connection, Association businessObject) {
        String oldDirection;
        IPeService peService = Graphiti.getPeService();
        IGaService gaService = Graphiti.getGaService();
        String newDirection = businessObject.getAssociationDirection().toString();
        if (newDirection == null || newDirection.isEmpty()) {
            newDirection = AssociationDirection.NONE.toString();
        }
        if ((oldDirection = peService.getPropertyValue((PropertyContainer)connection, ASSOCIATION_DIRECTION)) == null || oldDirection.isEmpty()) {
            oldDirection = AssociationDirection.NONE.toString();
        }
        if (!oldDirection.equals(newDirection)) {
            Polyline arrowhead;
            ConnectionDecorator sourceDecorator = null;
            ConnectionDecorator targetDecorator = null;
            for (ConnectionDecorator d : connection.getConnectionDecorators()) {
                String s = peService.getPropertyValue((PropertyContainer)d, ARROWHEAD_DECORATOR);
                if (s == null) continue;
                if (s.equals("source")) {
                    sourceDecorator = d;
                    continue;
                }
                if (!s.equals("target")) continue;
                targetDecorator = d;
            }
            boolean needSource = false;
            boolean needTarget = false;
            if (newDirection.equals(AssociationDirection.ONE.toString())) {
                needTarget = true;
            } else if (newDirection.equals(AssociationDirection.BOTH.toString())) {
                needTarget = true;
                needSource = true;
            }
            if (needSource) {
                if (sourceDecorator == null) {
                    sourceDecorator = peService.createConnectionDecorator(connection, false, 0.0, true);
                    int[] nArray = new int[6];
                    nArray[0] = -13;
                    nArray[1] = 7;
                    nArray[4] = -13;
                    nArray[5] = -7;
                    arrowhead = gaService.createPolyline((GraphicsAlgorithmContainer)sourceDecorator, nArray);
                    StyleUtil.applyStyle((GraphicsAlgorithm)arrowhead, (BaseElement)businessObject);
                    peService.setPropertyValue((PropertyContainer)sourceDecorator, ARROWHEAD_DECORATOR, "source");
                }
            } else if (sourceDecorator != null) {
                connection.getConnectionDecorators().remove((Object)sourceDecorator);
            }
            if (needTarget) {
                if (targetDecorator == null) {
                    targetDecorator = peService.createConnectionDecorator(connection, false, 1.0, true);
                    int[] nArray = new int[6];
                    nArray[0] = -13;
                    nArray[1] = 7;
                    nArray[4] = -13;
                    nArray[5] = -7;
                    arrowhead = gaService.createPolyline((GraphicsAlgorithmContainer)targetDecorator, nArray);
                    StyleUtil.applyStyle((GraphicsAlgorithm)arrowhead, (BaseElement)businessObject);
                    peService.setPropertyValue((PropertyContainer)targetDecorator, ARROWHEAD_DECORATOR, "target");
                }
            } else if (targetDecorator != null) {
                connection.getConnectionDecorators().remove((Object)targetDecorator);
            }
            peService.setPropertyValue((PropertyContainer)connection, ASSOCIATION_DIRECTION, newDirection);
        }
    }

    private static void updateCompensationHandlers(IFeatureProvider fp, Association association, BaseElement oldSource, BaseElement oldTarget, BaseElement newSource, BaseElement newTarget) {
        Diagram diagram = fp.getDiagramTypeProvider().getDiagram();
        boolean oldTargetHasOtherCompensationEvents = false;
        for (Connection c : diagram.getConnections()) {
            Iterator a = (Association)BusinessObjectUtil.getFirstElementOfType((PictogramElement)c, Association.class);
            if (a == null || a.getAssociationDirection() != AssociationDirection.ONE || a == association || a.getTargetRef() != oldTarget) continue;
            oldTargetHasOtherCompensationEvents = true;
            break;
        }
        Association oldAssociation = null;
        for (Connection c : diagram.getConnections()) {
            Association a = (Association)BusinessObjectUtil.getFirstElementOfType((PictogramElement)c, Association.class);
            if (a == null || a.getAssociationDirection() != AssociationDirection.ONE || a == association || a.getSourceRef() != newSource) continue;
            oldAssociation = a;
            break;
        }
        if (association.getAssociationDirection() == AssociationDirection.ONE) {
            IUpdateFeature uf;
            UpdateContext uc;
            PictogramElement pe;
            CompensateEventDefinition ced;
            if (oldSource instanceof BoundaryEvent && oldTarget instanceof Activity && (ced = AssociationFeatureContainer.getCompensateEvent(oldSource)) != null) {
                ced.setActivityRef(null);
                if (!oldTargetHasOtherCompensationEvents) {
                    ((Activity)oldTarget).setIsForCompensation(false);
                    pe = fp.getPictogramElementForBusinessObject((Object)oldTarget);
                    uc = new UpdateContext(pe);
                    uf = fp.getUpdateFeature((IUpdateContext)uc);
                    uf.update((IUpdateContext)uc);
                }
            }
            if (newSource instanceof BoundaryEvent && newTarget instanceof Activity && (ced = AssociationFeatureContainer.getCompensateEvent(newSource)) != null) {
                oldTarget = ced.getActivityRef();
                ced.setActivityRef((Activity)newTarget);
                ((Activity)newTarget).setIsForCompensation(true);
                pe = fp.getPictogramElementForBusinessObject((Object)newTarget);
                uc = new UpdateContext(pe);
                uf = fp.getUpdateFeature((IUpdateContext)uc);
                uf.update((IUpdateContext)uc);
                if ((oldSource != newSource || oldTarget != newTarget) && oldAssociation != null) {
                    pe = fp.getPictogramElementForBusinessObject((Object)oldAssociation);
                    DeleteContext dc = new DeleteContext(pe);
                    IDeleteFeature df = fp.getDeleteFeature((IDeleteContext)dc);
                    df.delete((IDeleteContext)dc);
                }
            }
        }
    }

    private static CompensateEventDefinition getCompensateEvent(BaseElement source) {
        if (source instanceof BoundaryEvent) {
            for (EventDefinition ed : ((BoundaryEvent)source).getEventDefinitions()) {
                if (!(ed instanceof CompensateEventDefinition)) continue;
                return (CompensateEventDefinition)ed;
            }
        }
        return null;
    }

    public class AddAssociationFeature
    extends AbstractAddFlowFeature<Association> {
        public AddAssociationFeature(IFeatureProvider fp) {
            super(fp);
        }

        protected Polyline createConnectionLine(Connection connection) {
            Polyline connectionLine = super.createConnectionLine(connection);
            connectionLine.setLineWidth(Integer.valueOf(2));
            connectionLine.setLineStyle(LineStyle.DOT);
            return connectionLine;
        }

        protected void decorateConnection(IAddConnectionContext context, Connection connection, Association businessObject) {
            AssociationFeatureContainer.setAssociationDirection(connection, businessObject);
        }

        public Class getBusinessObjectType() {
            return Association.class;
        }
    }

    public class CreateAssociationFeature
    extends AbstractCreateFlowFeature<Association, BaseElement, BaseElement> {
        public CreateAssociationFeature(IFeatureProvider fp) {
            super(fp);
        }

        public boolean isAvailable(IContext context) {
            BaseElement source;
            if (!this.isModelObjectEnabled((EObject)Bpmn2Package.eINSTANCE.getAssociation())) {
                return false;
            }
            if (context instanceof ICreateConnectionContext && ((source = this.getSourceBo((ICreateConnectionContext)context)) instanceof Activity || source instanceof Gateway || source instanceof Event)) {
                return false;
            }
            return super.isAvailable(context);
        }

        public boolean canCreate(ICreateConnectionContext context) {
            if (!super.canCreate(context)) {
                return false;
            }
            BaseElement source = this.getSourceBo(context);
            BaseElement target = this.getTargetBo(context);
            if (source != null && target != null) {
                if (source instanceof BoundaryEvent && target instanceof Activity) {
                    return true;
                }
                if (source instanceof BaseElement || target instanceof BaseElement) {
                    return true;
                }
            }
            return false;
        }

        public Connection create(ICreateConnectionContext context) {
            Connection connection = super.create(context);
            Association association = (Association)this.getBusinessObject(context);
            if (association.getSourceRef() instanceof BoundaryEvent && association.getTargetRef() instanceof Activity) {
                association.setAssociationDirection(AssociationDirection.ONE);
            }
            return connection;
        }

        protected String getStencilImageId() {
            return ImageProvider.IMG_16_ASSOCIATION;
        }

        protected Class<BaseElement> getSourceClass() {
            return BaseElement.class;
        }

        protected Class<BaseElement> getTargetClass() {
            return BaseElement.class;
        }

        protected BaseElement getSourceBo(ICreateConnectionContext context) {
            Anchor anchor = this.getSourceAnchor(context);
            if (anchor != null && anchor.getParent() instanceof Shape) {
                Shape shape = (Shape)anchor.getParent();
                return (BaseElement)BusinessObjectUtil.getFirstElementOfType((PictogramElement)shape, this.getTargetClass());
            }
            if (context.getSourcePictogramElement() instanceof Connection) {
                Connection connection = (Connection)context.getSourcePictogramElement();
                return BusinessObjectUtil.getFirstBaseElement((PictogramElement)connection);
            }
            return null;
        }

        protected BaseElement getTargetBo(ICreateConnectionContext context) {
            Anchor anchor = this.getTargetAnchor(context);
            if (anchor != null && anchor.getParent() instanceof Shape) {
                Shape shape = (Shape)anchor.getParent();
                return (BaseElement)BusinessObjectUtil.getFirstElementOfType((PictogramElement)shape, this.getTargetClass());
            }
            if (context.getTargetPictogramElement() instanceof Connection) {
                Connection connection = (Connection)context.getTargetPictogramElement();
                return BusinessObjectUtil.getFirstBaseElement((PictogramElement)connection);
            }
            return null;
        }

        public EClass getBusinessObjectClass() {
            return Bpmn2Package.eINSTANCE.getAssociation();
        }
    }

    public static class DeleteAssociationFeature
    extends DefaultDeleteBPMNShapeFeature {
        public DeleteAssociationFeature(IFeatureProvider fp) {
            super(fp);
        }

        public boolean canDelete(IDeleteContext context) {
            if (!(context.getPictogramElement() instanceof Connection)) {
                return false;
            }
            return super.canDelete(context);
        }

        public void delete(IDeleteContext context) {
            Connection connection = (Connection)context.getPictogramElement();
            AnchorContainer ac = connection.getStart().getParent();
            BaseElement oldSource = BusinessObjectUtil.getFirstBaseElement((PictogramElement)ac);
            ac = connection.getEnd().getParent();
            BaseElement oldTarget = BusinessObjectUtil.getFirstBaseElement((PictogramElement)ac);
            Association association = (Association)BusinessObjectUtil.getFirstElementOfType((PictogramElement)connection, Association.class);
            AssociationFeatureContainer.updateCompensationHandlers(this.getFeatureProvider(), association, oldSource, oldTarget, null, null);
            super.delete(context);
        }
    }

    public static class ReconnectAssociationFeature
    extends AbstractReconnectFlowFeature {
        BaseElement oldSource;
        BaseElement oldTarget;

        public ReconnectAssociationFeature(IFeatureProvider fp) {
            super(fp);
        }

        public boolean canReconnect(IReconnectionContext context) {
            BaseElement targetElement = (BaseElement)BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getTargetPictogramElement(), BaseElement.class);
            if (targetElement instanceof Association) {
                return false;
            }
            PictogramElement targetPictogramElement = context.getTargetPictogramElement();
            if (targetPictogramElement instanceof FreeFormConnection) {
                AnchorContainer ac = context.getConnection().getEnd().getParent();
                return BusinessObjectUtil.getBusinessObjectForPictogramElement((PictogramElement)ac) != targetElement;
            }
            return super.canReconnect(context);
        }

        protected Class<? extends EObject> getTargetClass() {
            return BaseElement.class;
        }

        protected Class<? extends EObject> getSourceClass() {
            return BaseElement.class;
        }

        public void preReconnect(IReconnectionContext context) {
            AnchorContainer ac = context.getConnection().getStart().getParent();
            this.oldSource = BusinessObjectUtil.getFirstBaseElement((PictogramElement)ac);
            ac = context.getConnection().getEnd().getParent();
            this.oldTarget = BusinessObjectUtil.getFirstBaseElement((PictogramElement)ac);
            super.preReconnect(context);
        }

        public void postReconnect(IReconnectionContext context) {
            AnchorUtil.adjustAnchors((AnchorContainer)context.getOldAnchor().getParent());
            AnchorContainer ac = context.getConnection().getStart().getParent();
            BaseElement newSource = BusinessObjectUtil.getFirstBaseElement((PictogramElement)ac);
            ac = context.getConnection().getEnd().getParent();
            BaseElement newTarget = BusinessObjectUtil.getFirstBaseElement((PictogramElement)ac);
            Association association = (Association)BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getConnection(), Association.class);
            AssociationFeatureContainer.updateCompensationHandlers(this.getFeatureProvider(), association, this.oldSource, this.oldTarget, newSource, newTarget);
            super.postReconnect(context);
        }
    }

    public static class UpdateAssociationFeature
    extends AbstractBpmn2UpdateFeature {
        public UpdateAssociationFeature(IFeatureProvider fp) {
            super(fp);
        }

        public boolean canUpdate(IUpdateContext context) {
            if (context.getPictogramElement() instanceof Connection) {
                return BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getPictogramElement(), Association.class) != null;
            }
            return false;
        }

        public IReason updateNeeded(IUpdateContext context) {
            if (this.canUpdate(context)) {
                String oldDirection;
                Connection connection = (Connection)context.getPictogramElement();
                Association businessObject = (Association)BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getPictogramElement(), Association.class);
                String newDirection = businessObject.getAssociationDirection().toString();
                if (newDirection == null || newDirection.isEmpty()) {
                    newDirection = AssociationDirection.NONE.toString();
                }
                if ((oldDirection = Graphiti.getPeService().getPropertyValue((PropertyContainer)connection, AssociationFeatureContainer.ASSOCIATION_DIRECTION)) == null || oldDirection.isEmpty()) {
                    oldDirection = AssociationDirection.NONE.toString();
                }
                if (!oldDirection.equals(newDirection)) {
                    return Reason.createTrueReason((String)Messages.AssociationFeatureContainer_Direction_Changed);
                }
            }
            return Reason.createFalseReason();
        }

        public boolean update(IUpdateContext context) {
            Connection connection = (Connection)context.getPictogramElement();
            Association association = (Association)BusinessObjectUtil.getFirstElementOfType((PictogramElement)context.getPictogramElement(), Association.class);
            AssociationFeatureContainer.setAssociationDirection(connection, association);
            BaseElement source = association.getSourceRef();
            BaseElement target = association.getTargetRef();
            AssociationFeatureContainer.updateCompensationHandlers(this.getFeatureProvider(), association, source, target, source, target);
            return true;
        }
    }
}

