/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.view.logs;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.fusesource.ide.fabric8.core.dto.LogEventDTO;
import org.fusesource.ide.fabric8.ui.FabricPlugin;

public class LogLevelImageProvider
extends ColumnLabelProvider {
    public Image getImage(Object element) {
        LogEventDTO le = (LogEventDTO)element;
        if (le != null) {
            return this.getLevelImage(le);
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        LogEventDTO le = (LogEventDTO)element;
        if (le != null) {
            return le.getLogLevel();
        }
        return super.getText(element);
    }

    public String getToolTipText(Object element) {
        LogEventDTO le = (LogEventDTO)element;
        if (le != null) {
            return le.getLogMessage();
        }
        return super.getToolTipText(element);
    }

    public Color getBackground(Object element) {
        LogEventDTO le = (LogEventDTO)element;
        if (le != null) {
            return this.getBackgroundForLevel(le);
        }
        return super.getBackground(element);
    }

    private Image getLevelImage(LogEventDTO event) {
        String l = event.getLogLevel();
        if (l != null) {
            if ("INFO".equalsIgnoreCase(l)) {
                return FabricPlugin.getDefault().getImage("information.gif");
            }
            if ("ERROR".equalsIgnoreCase(l)) {
                return FabricPlugin.getDefault().getImage("error.gif");
            }
            if ("WARN".equalsIgnoreCase(l)) {
                return FabricPlugin.getDefault().getImage("warning.gif");
            }
        }
        return null;
    }

    private Color getBackgroundForLevel(LogEventDTO event) {
        String l = event.getLogLevel();
        if (l != null) {
            if ("INFO".equalsIgnoreCase(l)) {
                return Display.getDefault().getSystemColor(1);
            }
            if ("ERROR".equalsIgnoreCase(l)) {
                return Display.getDefault().getSystemColor(3);
            }
            if ("WARN".equalsIgnoreCase(l)) {
                return Display.getDefault().getSystemColor(7);
            }
        }
        return Display.getDefault().getSystemColor(1);
    }
}

