/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.view.logs;

import java.util.ArrayList;
import java.util.List;
import org.fusesource.ide.fabric8.core.connector.Fabric8Facade;
import org.fusesource.ide.fabric8.core.dto.LogEventDTO;
import org.fusesource.ide.fabric8.core.dto.LogResultsDTO;
import org.fusesource.ide.fabric8.ui.navigator.ContainerNode;
import org.fusesource.ide.fabric8.ui.navigator.ContainersNode;
import org.fusesource.ide.fabric8.ui.navigator.Fabric;
import org.fusesource.ide.fabric8.ui.navigator.FabricNodeSupport;
import org.fusesource.ide.fabric8.ui.view.logs.ILogBrowser;
import org.fusesource.ide.fabric8.ui.view.logs.LogContext;

public class FabricLogBrowser
implements ILogBrowser {
    private final FabricNodeSupport node;

    public FabricLogBrowser(FabricNodeSupport node) {
        this.node = node;
    }

    @Override
    public void queryLogs(LogContext context, boolean filterChanged) {
        Fabric8Facade fabricService = this.getFabricService();
        if (fabricService == null) {
            return;
        }
        LogResultsDTO res = fabricService.queryLog(context.getLogFilter());
        List logs = res.getLogEvents();
        if (this.node instanceof ContainerNode) {
            String containerId = ((ContainerNode)this.node).getId();
            ArrayList<LogEventDTO> unwantedEntries = new ArrayList<LogEventDTO>();
            for (LogEventDTO ev : logs) {
                if (ev.getContainer().equalsIgnoreCase(containerId)) continue;
                unwantedEntries.add(ev);
            }
            logs.removeAll(unwantedEntries);
        }
        context.addLogResults(logs);
        context.getLogFilter().setAfterTimestamp(res.getTo());
        context.getLogFilter().setBeforeTimestamp(Long.valueOf(System.currentTimeMillis()));
    }

    private Fabric8Facade getFabricService() {
        if (this.node instanceof Fabric) {
            return ((Fabric)this.node).getFabricService();
        }
        if (this.node instanceof ContainersNode) {
            return ((ContainersNode)this.node).getFabric().getFabricService();
        }
        if (this.node instanceof ContainerNode) {
            return ((ContainerNode)this.node).getFabricService();
        }
        return null;
    }
}

