/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.navigator.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.fusesource.ide.commons.Viewers;
import org.fusesource.ide.commons.tree.Refreshables;
import org.fusesource.ide.commons.ui.Selections;
import org.fusesource.ide.commons.ui.actions.SeparatorFactory;
import org.fusesource.ide.commons.ui.views.TableViewSupport;
import org.fusesource.ide.commons.util.Function1;
import org.fusesource.ide.fabric8.core.dto.VersionDTO;
import org.fusesource.ide.fabric8.ui.FabricPlugin;
import org.fusesource.ide.fabric8.ui.actions.CreateVersionAction;
import org.fusesource.ide.fabric8.ui.navigator.Fabric;
import org.fusesource.ide.fabric8.ui.navigator.FabricNavigator;
import org.fusesource.ide.fabric8.ui.navigator.VersionNode;
import org.fusesource.ide.fabric8.ui.navigator.VersionsNode;
import org.fusesource.ide.fabric8.ui.navigator.properties.FabricStatusTableSheetPage;
import org.fusesource.ide.fabric8.ui.navigator.properties.VersionTableSheetPage;
import org.jboss.tools.jmx.core.tree.Node;

public class VersionsTabSection
extends TableViewSupport {
    protected static SeparatorFactory separatorFactory = new SeparatorFactory(FabricStatusTableSheetPage.VIEW_ID);
    private Fabric current;
    private CreateVersionAction createVersionAction;
    private Separator separator1 = separatorFactory.createSeparator();
    private Separator separator2 = separatorFactory.createSeparator();
    private Runnable refreshRunnable = new Runnable(){

        @Override
        public void run() {
            VersionsTabSection.this.refresh();
        }
    };

    public static VersionDTO asVersionDTO(Object element) {
        if (element instanceof VersionDTO) {
            return (VersionDTO)element;
        }
        if (element instanceof VersionNode) {
            return ((VersionNode)((Object)element)).getVersion();
        }
        return null;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        VersionsNode vNode = (VersionsNode)((Object)Selections.getFirstSelection((ISelection)selection));
        if (vNode == null) {
            return;
        }
        final Fabric fabric = vNode.getFabric();
        if (fabric == this.current) {
            return;
        }
        if (this.current != null) {
            this.current.removeFabricUpdateRunnable(this.refreshRunnable);
        }
        this.current = fabric;
        if (this.current != null) {
            this.current.addFabricUpdateRunnable(this.refreshRunnable);
        }
        Job loadJob = new Job("Loading " + vNode.toString() + " data..."){

            protected IStatus run(IProgressMonitor monitor) {
                final List versions = VersionsTabSection.this.getVersions();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        VersionsTabSection.this.setInput(versions);
                        VersionsTabSection.this.getViewer().setInput((Object)versions);
                        VersionsTabSection.this.getViewer().refresh(true);
                        if (fabric != null) {
                            VersionsTabSection.this.getCreateVersionAction().setVersioNode(null);
                        }
                        VersionsTabSection.this.updateActionStatus();
                    }
                });
                return Status.OK_STATUS;
            }
        };
        loadJob.schedule();
    }

    public void dispose() {
        if (this.current != null) {
            this.current.removeFabricUpdateRunnable(this.refreshRunnable);
        }
        super.dispose();
    }

    protected void configureViewer() {
        this.addLocalMenuActions(new Object[]{this.separator1, this.getCreateVersionAction(), this.separator2});
        this.addToolBarActions(new Object[]{this.getCreateVersionAction()});
        this.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                VersionDTO s;
                String versionId;
                VersionNode versionNode;
                Object oSel;
                FabricNavigator nav = FabricPlugin.getFabricNavigator();
                if (nav != null && VersionsTabSection.this.current != null && (oSel = Selections.getFirstSelection((ISelection)event.getSelection())) != null && oSel instanceof VersionDTO && (versionNode = VersionsTabSection.this.searchVersion(nav, versionId = (s = VersionsTabSection.asVersionDTO(oSel)).getId())) != null) {
                    nav.selectReveal((ISelection)new StructuredSelection((Object)versionNode));
                }
            }
        });
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                VersionsTabSection.this.updateActionStatus();
            }
        });
        this.updateData();
    }

    private List<VersionDTO> getVersions() {
        if (this.current == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<VersionDTO> result = new ArrayList<VersionDTO>();
        for (Node node : this.current.getVersionsNode().getChildrenList()) {
            VersionDTO vNode = VersionNode.toVersion(node);
            if (vNode == null) continue;
            result.add(vNode);
        }
        return result;
    }

    private VersionNode searchVersion(FabricNavigator nav, String versionId) {
        VersionNode result = null;
        for (Node node : this.current.getVersionsNode().getChildrenList()) {
            VersionNode vNode = VersionNode.toVersionNode(node);
            if (vNode == null || !vNode.getVersionId().equals(versionId)) continue;
            result = vNode;
            break;
        }
        return result;
    }

    public void refresh() {
        Viewers.async((Runnable)new Runnable(){

            @Override
            public void run() {
                if (VersionsTabSection.this.current == null) {
                    return;
                }
                VersionsTabSection.this.updateData();
                Refreshables.refresh((Object)VersionsTabSection.this.getViewer());
                VersionsTabSection.this.updateActionStatus();
            }
        });
    }

    protected void updateData() {
        this.setInput(this.getVersions());
    }

    protected void createColumns() {
        this.clearColumns();
        int bounds = 100;
        int column = 0;
        Object function = new Function1(){

            public Object apply(Object element) {
                VersionDTO version = VersionsTabSection.asVersionDTO(element);
                if (version != null) {
                    return version.getId();
                }
                return null;
            }
        };
        column = this.addColumnFunction(250, column, (Function1)function, "Id");
        function = new Function1(){

            public Boolean apply(Object element) {
                VersionDTO version = VersionsTabSection.asVersionDTO(element);
                if (version != null) {
                    return version.isDefaultVersion();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Default");
    }

    protected IStructuredContentProvider createContentProvider() {
        return ArrayContentProvider.getInstance();
    }

    protected String getHelpID() {
        return VersionTableSheetPage.VIEW_ID;
    }

    public String getColumnConfigurationId() {
        return VersionTableSheetPage.VIEW_ID;
    }

    protected IStructuredSelection getSelection() {
        return Selections.getStructuredSelection((Viewer)this.getViewer());
    }

    protected CreateVersionAction getCreateVersionAction() {
        if (this.createVersionAction == null) {
            this.createVersionAction = this.createCreateVersionAction(null);
        }
        return this.createVersionAction;
    }

    protected VersionNode getSelectedVersionNode() {
        Object first = Selections.getFirstSelection((Viewer)this.getViewer());
        if (first instanceof VersionDTO) {
            VersionDTO version = (VersionDTO)first;
            String id = version.getId();
            for (Node n : this.current.getVersionsNode().getChildrenList()) {
                if (n == null || !(n instanceof VersionNode) || !((VersionNode)n).getVersionId().equals(id)) continue;
                return (VersionNode)n;
            }
        }
        return null;
    }

    protected CreateVersionAction createCreateVersionAction(VersionNode version) {
        if (version == null && this.current != null) {
            return new CreateVersionAction(this.current.getVersionsNode());
        }
        return new CreateVersionAction(version);
    }

    protected void updateActionStatus() {
        VersionNode versionNode = this.getSelectedVersionNode();
        this.getCreateVersionAction().setFabric(this.current);
        this.getCreateVersionAction().setVersioNode(versionNode);
    }
}

