/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.navigator.properties;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.fusesource.ide.commons.Viewers;
import org.fusesource.ide.commons.tree.RefreshableUI;
import org.fusesource.ide.commons.tree.Refreshables;
import org.fusesource.ide.commons.ui.Selections;
import org.fusesource.ide.commons.ui.actions.SeparatorFactory;
import org.fusesource.ide.commons.ui.views.TableViewSupport;
import org.fusesource.ide.commons.util.Function1;
import org.fusesource.ide.fabric8.core.dto.ProfileStatusDTO;
import org.fusesource.ide.fabric8.core.dto.VersionDTO;
import org.fusesource.ide.fabric8.ui.actions.CreateVersionAction;
import org.fusesource.ide.fabric8.ui.navigator.Fabric;
import org.fusesource.ide.fabric8.ui.navigator.ProfileNode;
import org.fusesource.ide.fabric8.ui.navigator.VersionNode;
import org.fusesource.ide.fabric8.ui.navigator.VersionsNode;
import org.jboss.tools.jmx.core.tree.Node;

public class VersionTableSheetPage
extends TableViewSupport
implements IPropertySheetPage {
    protected static final String VIEW_ID = VersionTableSheetPage.class.getName();
    protected static SeparatorFactory separatorFactory = new SeparatorFactory(VIEW_ID);
    private CreateVersionAction createVersionAction;
    private Separator separator1 = separatorFactory.createSeparator();
    private Separator separator2 = separatorFactory.createSeparator();
    private final Fabric fabric;
    private Runnable refreshRunnable = new Runnable(){

        @Override
        public void run() {
            VersionTableSheetPage.this.refresh();
        }
    };

    public static VersionDTO asVersionDTO(Object element) {
        if (element instanceof VersionDTO) {
            return (VersionDTO)element;
        }
        if (element instanceof VersionNode) {
            return ((VersionNode)((Object)element)).getVersion();
        }
        return null;
    }

    public VersionTableSheetPage(Fabric fabric) {
        this.fabric = fabric;
        this.updateActionStatus();
    }

    public void dispose() {
        super.dispose();
        this.fabric.removeFabricUpdateRunnable(this.refreshRunnable);
    }

    public void refresh() {
        Viewers.async((Runnable)new Runnable(){

            @Override
            public void run() {
                Refreshables.refresh((Object)((Object)VersionTableSheetPage.this.fabric.getVersionsNode()));
                VersionTableSheetPage.this.updateData();
                Refreshables.refresh((Object)VersionTableSheetPage.this.getViewer());
                VersionTableSheetPage.this.updateActionStatus();
            }
        });
    }

    public Fabric getFabric() {
        return this.fabric;
    }

    protected void configureViewer() {
        this.addLocalMenuActions(new Object[]{this.separator1, this.getCreateVersionAction(), this.separator2});
        this.addToolBarActions(new Object[]{this.getCreateVersionAction()});
        this.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                VersionDTO version;
                VersionNode versionNode;
                List<VersionDTO> selectedVersions;
                VersionsNode versionsNode = VersionTableSheetPage.this.fabric.getVersionsNode();
                if (versionsNode != null && !(selectedVersions = VersionTableSheetPage.this.getSelectedVersions()).isEmpty() && (versionNode = versionsNode.getVersionNode((version = selectedVersions.get(0)).getId())) != null) {
                    Selections.setSingleSelection((RefreshableUI)VersionTableSheetPage.this.fabric.getRefreshableUI(), (Object)((Object)versionNode));
                }
            }
        });
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                VersionTableSheetPage.this.updateActionStatus();
            }
        });
        this.fabric.addFabricUpdateRunnable(this.refreshRunnable);
        this.updateData();
    }

    protected ProfileNode getSelectedProfileNode() {
        Object first = Selections.getFirstSelection((Viewer)this.getViewer());
        if (first instanceof ProfileStatusDTO) {
            ProfileStatusDTO status = (ProfileStatusDTO)first;
            String id = status.getProfile();
            VersionNode version = this.getFabric().getDefaultVersionNode();
            if (version != null) {
                return version.getProfileNode(id);
            }
        }
        return null;
    }

    protected List<VersionDTO> getSelectedVersions() {
        ArrayList<VersionDTO> versions = new ArrayList<VersionDTO>();
        IStructuredSelection selection = Selections.getStructuredSelection((Viewer)this.getViewer());
        if (selection != null) {
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                VersionDTO version = VersionNode.toVersion(iterator.next());
                if (version == null) continue;
                versions.add(version);
            }
        }
        return versions;
    }

    protected Set<String> getSelectedIds() {
        HashSet<String> answer = new HashSet<String>();
        List<VersionDTO> versions = this.getSelectedVersions();
        for (VersionDTO version : versions) {
            String id = version.getId();
            if (id == null) continue;
            answer.add(id);
        }
        return answer;
    }

    protected CreateVersionAction getCreateVersionAction() {
        if (this.createVersionAction == null) {
            this.createVersionAction = this.createCreateVersionAction(null);
        }
        return this.createVersionAction;
    }

    protected CreateVersionAction createCreateVersionAction(VersionNode version) {
        if (version == null && this.fabric != null) {
            return new CreateVersionAction(this.fabric.getVersionsNode());
        }
        return new CreateVersionAction(version);
    }

    public void updateData() {
        VersionsNode versionsNode = this.fabric.getVersionsNode();
        if (versionsNode != null) {
            this.setInput(versionsNode.getChildrenList());
        }
    }

    protected VersionNode getSelectedVersionNode() {
        Object first = Selections.getFirstSelection((Viewer)this.getViewer());
        if (first instanceof VersionDTO) {
            VersionDTO version = (VersionDTO)first;
            String id = version.getId();
            for (Node n : this.fabric.getVersionsNode().getChildrenList()) {
                if (n == null || !(n instanceof VersionNode) || !((VersionNode)n).getVersionId().equals(id)) continue;
                return (VersionNode)n;
            }
        }
        return null;
    }

    protected void updateActionStatus() {
        VersionNode versionNode = this.getSelectedVersionNode();
        this.getCreateVersionAction().setFabric(this.fabric);
        this.getCreateVersionAction().setVersioNode(versionNode);
    }

    public String getColumnConfigurationId() {
        return VIEW_ID;
    }

    protected void createColumns() {
        this.clearColumns();
        int bounds = 100;
        int column = 0;
        Object function = new Function1(){

            public Object apply(Object element) {
                VersionDTO version = VersionTableSheetPage.asVersionDTO(element);
                if (version != null) {
                    return version.getId();
                }
                return null;
            }
        };
        column = this.addColumnFunction(250, column, (Function1)function, "Id");
        function = new Function1(){

            public Boolean apply(Object element) {
                VersionDTO version = VersionTableSheetPage.asVersionDTO(element);
                if (version != null) {
                    return version.isDefaultVersion();
                }
                return null;
            }
        };
        column = this.addColumnFunction(bounds, column, (Function1)function, "Default");
    }

    protected IStructuredContentProvider createContentProvider() {
        return ArrayContentProvider.getInstance();
    }

    protected String getHelpID() {
        return VIEW_ID;
    }
}

