/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.navigator;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.fusesource.ide.commons.ui.ContextMenuProvider;
import org.fusesource.ide.fabric8.core.dto.VersionDTO;
import org.fusesource.ide.fabric8.ui.FabricPlugin;
import org.fusesource.ide.fabric8.ui.actions.CreateVersionAction;
import org.fusesource.ide.fabric8.ui.navigator.Fabric;
import org.fusesource.ide.fabric8.ui.navigator.FabricNodeSupport;
import org.fusesource.ide.fabric8.ui.navigator.VersionNode;
import org.fusesource.ide.fabric8.ui.navigator.properties.VersionsTabViewPage;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class VersionsNode
extends FabricNodeSupport
implements ImageProvider,
ContextMenuProvider {
    private Map<String, VersionNode> map = new HashMap<String, VersionNode>();

    public VersionsNode(Fabric fabric) {
        super((Node)fabric, fabric);
    }

    public String toString() {
        return "Versions";
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("version_folder.png");
    }

    protected void loadChildren() {
        this.clearChildren();
        this.map.clear();
        List versions = this.getFabric().getFabricService().getVersions();
        if (versions != null) {
            for (VersionDTO version : versions) {
                VersionNode node = new VersionNode(this, version);
                this.map.put(node.getVersionId(), node);
                this.addChild((Node)node);
            }
        }
    }

    public VersionNode getVersionNode(String version) {
        if (this.map.isEmpty()) {
            this.loadChildren();
        }
        return this.map.get(version);
    }

    public VersionNode getDefaultVersionNode() {
        this.checkLoaded();
        List childrenList = this.getChildrenList();
        for (Node node : childrenList) {
            if (!(node instanceof VersionNode)) continue;
            VersionNode answer = (VersionNode)node;
            answer.getChildren();
            return answer;
        }
        return null;
    }

    @Override
    public void provideContextMenu(IMenuManager menu) {
        menu.add((IAction)new CreateVersionAction(this));
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            this.checkLoaded();
            if (this.getFabric() != null) {
                return new VersionsTabViewPage(this.getFabric());
            }
        }
        return super.getAdapter(adapter);
    }
}

