/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.fusesource.ide.commons.properties.PropertySources;
import org.fusesource.ide.commons.tree.GraphableNode;
import org.fusesource.ide.commons.tree.HasRefreshableUI;
import org.fusesource.ide.commons.tree.RefreshableUI;
import org.fusesource.ide.commons.ui.ContextMenuProvider;
import org.fusesource.ide.commons.util.Objects;
import org.fusesource.ide.fabric8.core.dto.ProfileDTO;
import org.fusesource.ide.fabric8.ui.FabricPlugin;
import org.fusesource.ide.fabric8.ui.actions.ProfileAddAction;
import org.fusesource.ide.fabric8.ui.actions.ProfileDeleteAction;
import org.fusesource.ide.fabric8.ui.navigator.ContainerNode;
import org.fusesource.ide.fabric8.ui.navigator.Fabric;
import org.fusesource.ide.fabric8.ui.navigator.IdBasedFabricNode;
import org.fusesource.ide.fabric8.ui.navigator.VersionNode;
import org.fusesource.ide.fabric8.ui.navigator.properties.ProfileBean;
import org.fusesource.ide.fabric8.ui.navigator.properties.ProfileTabViewPage;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class ProfileNode
extends IdBasedFabricNode
implements HasRefreshableUI,
ImageProvider,
GraphableNode,
ContextMenuProvider {
    private static final String AGENT_PID = "io.fabric8.agent";
    private static final boolean addContainersToTree = false;
    private Map<String, ProfileNode> map = new HashMap<String, ProfileNode>();
    private final Fabric fabric;
    private final ProfileDTO profile;
    private final VersionNode versionNode;

    public ProfileNode getProfileNode(String profileId) {
        this.checkLoaded();
        ProfileNode answer = this.map.get(profileId);
        if (answer == null) {
            answer = ProfileNode.getProfileNode(profileId, this.getProfileChildren());
        }
        return answer;
    }

    public ProfileNode(VersionNode versionNode, Node parent, ProfileDTO profile) {
        super(parent, versionNode.getFabric(), profile.getId());
        this.versionNode = versionNode;
        this.fabric = versionNode.getFabric();
        this.profile = profile;
        this.setPropertyBean((Object)new ProfileBean(profile));
    }

    public ProfileNode(VersionNode parent, ProfileDTO profile) {
        this(parent, (Node)parent, profile);
    }

    @Override
    public List<Node> getChildrenGraph() {
        HashSet<IdBasedFabricNode> answer = new HashSet<IdBasedFabricNode>();
        answer.add(this);
        answer.addAll(this.getChildrenList());
        for (ContainerNode c : this.getFabric().getContainersNode().getContainerNodes()) {
            if (!c.matches(this.profile)) continue;
            answer.add(c);
        }
        return new ArrayList<Node>(answer);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return new ProfileTabViewPage(this);
        }
        return super.getAdapter(adapter);
    }

    public boolean requiresContentsPropertyPage() {
        this.checkLoaded();
        this.getVersionNode().getChildren();
        return false;
    }

    public RefreshableUI getRefreshableUI() {
        return super.getRefreshableUI();
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("profile.png");
    }

    protected void loadChildren() {
        Set<ProfileDTO> childProfiles = this.versionNode.getChildProfiles(this.getProfileId());
        if (childProfiles != null) {
            for (ProfileDTO profile : childProfiles) {
                this.addChild((Node)this.versionNode.createProfile((Node)this, profile));
            }
        }
    }

    public List<ContainerNode> getContainerNodes() {
        return this.getFabric().getAgentsFor(this.getProfile());
    }

    public static ProfileNode getProfileNode(String profileId, ProfileNode[] children) {
        ProfileNode answer = null;
        ProfileNode[] profileNodeArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ProfileNode child = profileNodeArray[n2];
            answer = child.getProfileNode(profileId);
            if (answer != null) {
                return answer;
            }
            ++n2;
        }
        return answer;
    }

    public ProfileNode[] getProfileChildren() {
        return (ProfileNode[])Objects.getArrayOf((Collection)this.getChildrenList(), ProfileNode.class);
    }

    @Override
    public Fabric getFabric() {
        return this.fabric;
    }

    public String getFabricNameWithoutSpaces() {
        return this.getFabric().getName().replace(' ', '_');
    }

    public ProfileDTO getProfile() {
        return this.profile;
    }

    public String getProfileId() {
        return this.profile.getId();
    }

    public VersionNode getVersionNode() {
        return this.versionNode;
    }

    public void addAndDescendants(Set<Node> answer) {
        answer.add((Node)this);
        Node p = this.getParent();
        if (p instanceof ProfileNode) {
            ProfileNode parentNode = (ProfileNode)p;
            parentNode.addAndDescendants(answer);
        }
    }

    @Override
    public void provideContextMenu(IMenuManager menu) {
        menu.add((IAction)new ProfileAddAction(this));
        menu.add((IAction)new ProfileDeleteAction(this));
    }

    public List<IPropertySource> getContainerPropertySourceList() {
        return PropertySources.toPropertySourceList(this.getContainerNodes());
    }
}

