/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.navigator;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.fusesource.ide.commons.Viewers;
import org.fusesource.ide.commons.tree.HasRefreshableUI;
import org.fusesource.ide.commons.tree.HasViewer;
import org.fusesource.ide.commons.tree.RefreshableCollectionNode;
import org.fusesource.ide.commons.tree.RefreshableUI;
import org.fusesource.ide.commons.ui.ContextMenuProvider;
import org.fusesource.ide.commons.util.Strings;
import org.fusesource.ide.fabric8.core.connector.Fabric8Facade;
import org.fusesource.ide.fabric8.core.dto.VersionDTO;
import org.fusesource.ide.fabric8.ui.FabricPlugin;
import org.fusesource.ide.fabric8.ui.actions.FabricDetails;
import org.fusesource.ide.fabric8.ui.actions.FabricDetailsAddAction;
import org.fusesource.ide.fabric8.ui.actions.jclouds.CreateJCloudsFabricAction;
import org.fusesource.ide.fabric8.ui.navigator.Fabric;
import org.fusesource.ide.fabric8.ui.navigator.FabricEvent;
import org.fusesource.ide.fabric8.ui.navigator.FabricListener;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class Fabrics
extends RefreshableCollectionNode
implements ImageProvider,
HasRefreshableUI,
HasViewer,
ContextMenuProvider {
    public static final String DEFAULT_FABRIC_URL = "http://localhost:8181/jolokia/";
    public static final String DEFAULT_FABRIC_URL_FORMAT = "http://%s:8181/jolokia/";
    public static final String DEFAULT_USERNAME = "karaf";
    public static final String DEFAULT_PASSWORD = "karaf";
    public static final String DEFAULT_MAVEN_PROXY_URI = "https://repository.jboss.org/nexus/content/groups/ea";
    private final RefreshableUI refreshableUI;
    private List<Fabric> fabrics = new CopyOnWriteArrayList<Fabric>();
    private List<FabricListener> listeners = new ArrayList<FabricListener>();
    private boolean createLocalFabric;
    private FabricDetailsAddAction addAction;

    public Fabrics(RefreshableUI refreshableUI) {
        super(null);
        this.refreshableUI = refreshableUI;
        this.addAction = new FabricDetailsAddAction(this);
    }

    public FabricDetailsAddAction getAddAction() {
        return this.addAction;
    }

    public RefreshableUI getRefreshableUI() {
        return this.refreshableUI;
    }

    public Viewer getViewer() {
        return Viewers.getViewer((Object)this.getRefreshableUI());
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("fabric_folder.png");
    }

    protected void loadChildren() {
        WritableList list = this.getFabricDetailList();
        for (FabricDetails details : list) {
            this.addFabric(details);
        }
        if (this.createLocalFabric && list.isEmpty()) {
            this.addFabric("Local Fabric", DEFAULT_FABRIC_URL);
        }
        this.getFabricDetailList().addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                Fabrics.this.refresh();
            }
        });
    }

    public WritableList getFabricDetailList() {
        return FabricDetails.getDetailList();
    }

    public String toString() {
        return "Fabrics";
    }

    public List<Fabric> getFabrics() {
        return this.fabrics;
    }

    public Fabric getFabric(String name) {
        for (Fabric fabric : this.fabrics) {
            if (!fabric.getName().equals(name)) continue;
            return fabric;
        }
        return null;
    }

    protected void checkLoaded() {
        super.checkLoaded();
        this.checkConnected();
    }

    private void checkConnected() {
        for (Fabric fabric : this.fabrics) {
            fabric.isConnected();
        }
    }

    public void addFabricListener(FabricListener listener) {
        this.listeners.add(listener);
    }

    public void removeFabricListener(FabricListener listener) {
        this.listeners.remove(listener);
    }

    public Fabric addFabric(Fabric fabric) {
        this.fabrics.add(fabric);
        super.addChild((Node)fabric);
        if (!this.isLoading()) {
            this.fireFabricChanged(new FabricEvent(fabric));
        }
        return fabric;
    }

    public Fabric addFabric(FabricDetails details) {
        details.flush();
        Fabric fabric = new Fabric(this, details);
        return this.addFabric(fabric);
    }

    public Fabric addFabric(String fabricName, String uris) {
        FabricDetails details = FabricDetails.newInstance(fabricName, uris);
        FabricPlugin.getLogger().debug("Created fabric details: " + (Object)((Object)details));
        return this.addFabric(details);
    }

    public void provideContextMenu(IMenuManager menu) {
        menu.add((IAction)this.addAction);
        menu.add((IAction)new CreateJCloudsFabricAction(this));
    }

    protected void fireFabricChanged(FabricEvent fabricEvent) {
        for (FabricListener listener : this.listeners) {
            listener.onFabricEvent(fabricEvent);
        }
        this.refreshUI();
    }

    public static String getVersionName(VersionDTO version) {
        String text = null;
        if (version != null) {
            text = version.getId();
        }
        return Strings.getOrElse((Object)text, (String)"");
    }

    public static Fabric toFabric(Object object) {
        if (object instanceof Fabric) {
            return (Fabric)object;
        }
        if (object instanceof Node) {
            Node n = (Node)object;
            return Fabrics.toFabric(n.getParent());
        }
        return null;
    }

    public static VersionDTO getLatestVersion(Fabric8Facade fabricService) {
        List versions = fabricService.getVersions();
        if (versions != null && versions.size() > 0) {
            return (VersionDTO)versions.get(versions.size() - 1);
        }
        return null;
    }
}

