/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.navigator;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fusesource.ide.commons.Viewers;
import org.fusesource.ide.commons.tree.HasViewer;
import org.fusesource.ide.commons.tree.RefreshableUI;
import org.fusesource.ide.commons.ui.Selections;
import org.fusesource.ide.commons.ui.actions.HasDoubleClickAction;
import org.fusesource.ide.commons.ui.drop.DelegateDropListener;
import org.fusesource.ide.fabric8.ui.navigator.Fabrics;
import org.fusesource.ide.fabric8.ui.navigator.cloud.CloudsNode;

public class FabricNavigator
extends CommonNavigator
implements ITabbedPropertySheetPageContributor {
    public static String ID = "org.fusesource.ide.fabric.navigator";
    private RefreshableUI refreshableUI = new RefreshableUIImplementation();
    private Fabrics fabrics = new Fabrics(this.refreshableUI);
    private CloudsNode clouds = new CloudsNode(this.refreshableUI);

    protected IAdaptable getInitialInput() {
        return this;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        return super.getAdapter(adapter);
    }

    public String getContributorId() {
        return ID;
    }

    public void createPartControl(Composite aParent) {
        super.createPartControl(aParent);
        CommonViewer viewer = this.getCommonViewer();
        viewer.setExpandedElements(new Object[]{this.clouds, this.fabrics});
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object o;
                if (!event.getSelection().isEmpty() && (o = Selections.getFirstSelection((ISelection)event.getSelection())) instanceof HasDoubleClickAction) {
                    final Action a = ((HasDoubleClickAction)o).getDoubleClickAction();
                    Job job = new Job("Execute double click action..."){

                        protected IStatus run(IProgressMonitor monitor) {
                            if (a.isEnabled()) {
                                a.run();
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
            }
        });
    }

    protected CommonViewer createCommonViewer(Composite aParent) {
        return new CommonViewer(this.getViewSite().getId(), aParent, 772){

            public void addDragSupport(int operations, Transfer[] transferTypes, DragSourceListener listener) {
                super.addDragSupport(operations, transferTypes, listener);
            }

            public void addDropSupport(int operations, Transfer[] transferTypes, DropTargetListener listener) {
                Transfer[] newTransferTypes = new Transfer[]{LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance(), ResourceTransfer.getInstance(), TextTransfer.getInstance()};
                super.addDropSupport(operations, newTransferTypes, (DropTargetListener)new DelegateDropListener((Viewer)this, listener));
            }
        };
    }

    public CloudsNode getCloudsNode() {
        return this.clouds;
    }

    public Fabrics getFabrics() {
        return this.fabrics;
    }

    public final class RefreshableUIImplementation
    implements RefreshableUI,
    HasViewer {
        public void fireRefresh(final Object node, final boolean full) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    FabricNavigator.this.getCommonViewer().refresh(node, full);
                }
            });
        }

        public void fireRefresh() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    Viewers.refresh((Viewer)FabricNavigator.this.getCommonViewer());
                }
            });
        }

        public Viewer getViewer() {
            return FabricNavigator.this.getCommonViewer();
        }
    }
}

