/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.actions.jclouds;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.fusesource.ide.commons.ui.Selections;
import org.fusesource.ide.commons.util.Strings;
import org.fusesource.ide.fabric8.ui.actions.jclouds.CloudDetails;
import org.fusesource.ide.fabric8.ui.actions.jclouds.JClouds;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.logging.log4j.config.Log4JLoggingModule;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.sshj.config.SshjSshClientModule;

public class SelectCloudImageDialog
extends TitleAreaDialog {
    private CloudDetails selectedCloud;
    private String location;
    private String selectedImageId;
    private Text txt_search;
    private Label lbl_search;
    private Button btn_search;
    private ListViewer imageViewer;
    private ProgressBar progressBar;
    private Job job;
    private ImageListContentProvider imageContentProvider = new ImageListContentProvider();

    public SelectCloudImageDialog(Shell parentShell, CloudDetails cloudDetails, String location) {
        super(parentShell);
        this.selectedCloud = cloudDetails;
        this.location = location;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Cloud Image Selection...");
    }

    public void create() {
        super.create();
        this.setTitle("Select a cloud image...");
        this.setMessage("Please select the cloud image you want to use...", 1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        GridLayout layout = new GridLayout(3, false);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)layout);
        this.lbl_search = new Label(container, 0);
        this.lbl_search.setText("Search for: ");
        this.lbl_search.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.txt_search = new Text(container, 2052);
        this.txt_search.setToolTipText("Please enter a search term...");
        this.txt_search.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txt_search.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13) {
                    SelectCloudImageDialog.this.btn_search.setEnabled(false);
                    SelectCloudImageDialog.this.txt_search.setEnabled(false);
                    SelectCloudImageDialog.this.getButton(0).setEnabled(false);
                    SelectCloudImageDialog.this.lookupImages(SelectCloudImageDialog.this.txt_search.getText());
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.txt_search.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectCloudImageDialog.this.validate();
                SelectCloudImageDialog.this.btn_search.setEnabled(SelectCloudImageDialog.this.txt_search.getText().trim().length() > 0);
            }
        });
        this.btn_search = new Button(container, 2056);
        this.btn_search.setText("Search");
        this.btn_search.setToolTipText("Press this button to search for an image named similar to what you entered in the text field...");
        this.btn_search.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btn_search.setEnabled(false);
        this.btn_search.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectCloudImageDialog.this.btn_search.setEnabled(false);
                SelectCloudImageDialog.this.txt_search.setEnabled(false);
                SelectCloudImageDialog.this.getButton(0).setEnabled(false);
                SelectCloudImageDialog.this.lookupImages(SelectCloudImageDialog.this.txt_search.getText());
            }
        });
        this.imageViewer = new ListViewer(container, 2828);
        this.imageViewer.getControl().setLayoutData((Object)new GridData(4, 128, true, true, 3, 10));
        ((GridData)this.imageViewer.getControl().getLayoutData()).minimumHeight = 300;
        this.imageViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectCloudImageDialog.this.validate();
            }
        });
        this.imageViewer.setContentProvider((IContentProvider)this.imageContentProvider);
        this.imageViewer.setLabelProvider((IBaseLabelProvider)this.imageContentProvider);
        this.progressBar = new ProgressBar(container, 67842);
        this.progressBar.setLayoutData((Object)new GridData(4, 1024, true, true, 3, 1));
        container.pack();
        this.progressBar.setVisible(false);
        return area;
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        this.validate();
        return c;
    }

    protected boolean isResizable() {
        return true;
    }

    public boolean isHelpAvailable() {
        return true;
    }

    private void validate() {
        if (Strings.isBlank((String)this.txt_search.getText().trim())) {
            this.setErrorMessage("Please enter a search term...");
            return;
        }
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(!this.imageViewer.getSelection().isEmpty());
        }
        this.setErrorMessage(null);
    }

    private void lookupImages(final String searchTerm) {
        this.progressBar.setVisible(true);
        this.imageViewer.setSelection(null);
        this.imageViewer.setInput((Object)new org.jclouds.compute.domain.Image[0]);
        this.imageViewer.refresh();
        this.getDialogArea().redraw();
        this.job = new Job("Looking up images containing term '" + this.txt_search.getText() + "'..."){

            public IStatus run(IProgressMonitor monitor) {
                final org.jclouds.compute.domain.Image[] data = SelectCloudImageDialog.this.prepareImageListViewer(searchTerm);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        SelectCloudImageDialog.this.imageViewer.setInput((Object)data);
                        SelectCloudImageDialog.this.progressBar.setVisible(false);
                        SelectCloudImageDialog.this.btn_search.setEnabled(true);
                        SelectCloudImageDialog.this.txt_search.setEnabled(true);
                        SelectCloudImageDialog.this.getDialogArea().redraw();
                    }
                });
                return Status.OK_STATUS;
            }
        };
        this.job.schedule();
    }

    protected void okPressed() {
        this.selectedImageId = ((org.jclouds.compute.domain.Image)Selections.getFirstSelection((ISelection)this.imageViewer.getSelection())).getId();
        super.okPressed();
    }

    public String getSelectedCloudImageId() {
        return this.selectedImageId;
    }

    private org.jclouds.compute.domain.Image[] prepareImageListViewer(String searchTerm) {
        if (Strings.isBlank((String)this.location)) {
            return new org.jclouds.compute.domain.Image[0];
        }
        ComputeServiceContext context = null;
        Properties overrides = new Properties();
        overrides.put("provider", this.selectedCloud.getProviderId());
        overrides.put("identity", this.selectedCloud.getIdentity());
        overrides.put("credential", this.selectedCloud.getCredential());
        if (!Strings.isBlank((String)this.selectedCloud.getOwnerId())) {
            overrides.put("jclouds.ec2.ami-query", "owner-id=" + this.selectedCloud.getOwnerId() + ";state=available;image-type=machine;root-device-type=ebs;name=*" + searchTerm.trim() + "*");
        } else {
            overrides.put("jclouds.ec2.ami-query", "state=available;image-type=machine;root-device-type=ebs;name=*" + searchTerm.trim() + "*");
        }
        overrides.put("jclouds.ec2.cc-regions", this.location);
        ProviderMetadata selectedProvider = this.selectedCloud.getProvider();
        ApiMetadata selectedApi = this.selectedCloud.getApi();
        if (selectedProvider != null && selectedProvider != JClouds.EMPTY_PROVIDER) {
            context = (ComputeServiceContext)ContextBuilder.newBuilder((ProviderMetadata)selectedProvider).credentials(this.selectedCloud.getIdentity(), this.selectedCloud.getCredential()).overrides(overrides).modules((Iterable)ImmutableSet.of((Object)new Log4JLoggingModule(), (Object)new SshjSshClientModule())).buildView(ComputeServiceContext.class);
        } else if (selectedApi != null && selectedApi != JClouds.EMPTY_API) {
            context = (ComputeServiceContext)ContextBuilder.newBuilder((ApiMetadata)selectedApi).credentials(this.selectedCloud.getIdentity(), this.selectedCloud.getCredential()).overrides(overrides).modules((Iterable)ImmutableSet.of((Object)new Log4JLoggingModule(), (Object)new SshjSshClientModule())).buildView(ComputeServiceContext.class);
        } else {
            return new org.jclouds.compute.domain.Image[0];
        }
        Set images = context.getComputeService().listImages();
        if (images == null || images.isEmpty() || images.iterator() == null) {
            return new org.jclouds.compute.domain.Image[0];
        }
        ArrayList<org.jclouds.compute.domain.Image> imgs = new ArrayList<org.jclouds.compute.domain.Image>();
        for (Object o : JClouds.sortedList(images)) {
            imgs.add((org.jclouds.compute.domain.Image)o);
        }
        return imgs.toArray(new org.jclouds.compute.domain.Image[imgs.size()]);
    }

    private class ImageListContentProvider
    implements ILabelProvider,
    IStructuredContentProvider {
        private ImageListContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof org.jclouds.compute.domain.Image[]) {
                return (org.jclouds.compute.domain.Image[])inputElement;
            }
            return new Object[0];
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof org.jclouds.compute.domain.Image) {
                return String.valueOf(((org.jclouds.compute.domain.Image)element).getName()) + (((org.jclouds.compute.domain.Image)element).getDescription().trim().length() > 0 ? " (" + ((org.jclouds.compute.domain.Image)element).getDescription() + ")" : "");
            }
            return element.toString();
        }
    }
}

