/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui.actions;

import java.util.Arrays;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.fusesource.ide.commons.ui.Shells;
import org.fusesource.ide.fabric8.core.connector.Fabric8Facade;
import org.fusesource.ide.fabric8.core.dto.ProfileDTO;
import org.fusesource.ide.fabric8.ui.FabricPlugin;
import org.fusesource.ide.fabric8.ui.actions.Messages;
import org.fusesource.ide.fabric8.ui.navigator.ProfileNode;
import org.fusesource.ide.fabric8.ui.navigator.VersionNode;

public class ProfileAddAction
extends Action {
    private final VersionNode versionNode;
    private ProfileNode profileNode;

    public ProfileAddAction(VersionNode versionNode) {
        super(Messages.profileAddLabel);
        this.versionNode = versionNode;
        this.setToolTipText(Messages.profileAddTooltip);
        this.setImageDescriptor(FabricPlugin.getPlugin().getImageDescriptor("new_profile.png"));
    }

    public ProfileAddAction(ProfileNode profileNode) {
        this(profileNode.getVersionNode());
        this.profileNode = profileNode;
    }

    public void run() {
        InputDialog dialog = new InputDialog(Shells.getShell(), Messages.profileAddDialogTitle, Messages.profileAddDialogMessage, "", null);
        int result = dialog.open();
        if (result == 0) {
            String name = dialog.getValue();
            this.createProfile(name);
        }
    }

    protected void createProfile(String name) {
        String versionId = this.versionNode.getVersionId();
        Fabric8Facade service = this.versionNode.getFabric().getFabricService();
        ProfileDTO profile = service.createProfile(versionId, name);
        if (this.profileNode != null) {
            ProfileDTO parentProfile = this.profileNode.getProfile();
            profile.setParentIds(Arrays.asList(parentProfile.getId()));
        }
        this.versionNode.refresh();
    }
}

