/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.ui;

import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.fusesource.ide.commons.logging.RiderLogFacade;
import org.fusesource.ide.commons.ui.ImagesActivatorSupport;
import org.fusesource.ide.fabric8.ui.navigator.FabricNavigator;
import org.fusesource.ide.fabric8.ui.navigator.FabricPreferenceInitializer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class FabricPlugin
extends ImagesActivatorSupport {
    public static final String PLUGIN_ID = "org.fusesource.ide.fabric8.ui";
    public static final String TERMINAL_VIEW_ID = "org.fusesource.ide.server.view.TerminalView";
    private static IViewPart part;
    private static FabricPlugin plugin;
    public static final IPath ICONS_PATH;

    static {
        ICONS_PATH = new Path("$nl$/icons/full");
    }

    public static FabricPlugin getPlugin() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        FabricPlugin.initPreferences();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static ImagesActivatorSupport getDefault() {
        return plugin;
    }

    public static RiderLogFacade getLogger() {
        return RiderLogFacade.getLog((ILog)FabricPlugin.getDefault().getLog());
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        FabricPlugin.setImageDescriptors(action, "lcl16", iconName);
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        ImageDescriptor id = FabricPlugin.create("d" + type, relPath, false);
        if (id != null) {
            action.setDisabledImageDescriptor(id);
        }
        ImageDescriptor descriptor = FabricPlugin.create("e" + type, relPath, true);
        action.setHoverImageDescriptor(descriptor);
        action.setImageDescriptor(descriptor);
    }

    private static ImageDescriptor create(String prefix, String name, boolean useMissingImageDescriptor) {
        IPath path = ICONS_PATH.append(prefix).append(name);
        return FabricPlugin.createImageDescriptor(FabricPlugin.getDefault().getBundle(), path, useMissingImageDescriptor);
    }

    private static ImageDescriptor createImageDescriptor(Bundle bundle, IPath path, boolean useMissingImageDescriptor) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        if (useMissingImageDescriptor) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return null;
    }

    public static void showUserError(String title, String message, Exception e) {
        FabricPlugin.showUserError((String)PLUGIN_ID, (RiderLogFacade)FabricPlugin.getLogger(), (String)title, (String)message, (Exception)e);
    }

    public static void initPreferences() {
        new FabricPreferenceInitializer().initializeDefaultPreferences();
    }

    public static IViewPart openTerminalView() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage activePage;
                IWorkbenchWindow activeWindow;
                IWorkbench wb = PlatformUI.getWorkbench();
                if (wb != null && (activeWindow = wb.getActiveWorkbenchWindow()) != null && (activePage = activeWindow.getActivePage()) != null) {
                    try {
                        part = activePage.showView(FabricPlugin.TERMINAL_VIEW_ID);
                    }
                    catch (CoreException ex) {
                        FabricPlugin.getLogger().error("Unable to create the terminal view!", (Throwable)ex);
                    }
                }
            }
        });
        return part;
    }

    public static FabricNavigator getFabricNavigator() {
        IViewPart part;
        IWorkbenchPage page;
        IWorkbenchWindow wbw;
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb != null && (wbw = wb.getActiveWorkbenchWindow()) != null && (page = wbw.getActivePage()) != null && (part = page.findView("org.fusesource.ide.fabric.navigator")) != null) {
            FabricNavigator nav = (FabricNavigator)part;
            return nav;
        }
        return null;
    }
}

