/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.validation;

import java.util.Collections;
import java.util.List;
import org.teiid.designer.transformation.validation.SqlTransformationResult;

public class TransformationValidationResult {
    private List statusList = null;
    private boolean insertAllowed;
    private boolean updateAllowed;
    private boolean deleteAllowed;
    private SqlTransformationResult selectStatus;
    private SqlTransformationResult insertStatus;
    private SqlTransformationResult updateStatus;
    private SqlTransformationResult deleteStatus;

    public TransformationValidationResult() {
    }

    public TransformationValidationResult(List statusList) {
        this.statusList = statusList;
    }

    public List getStatusList() {
        if (this.statusList != null) {
            return this.statusList;
        }
        return Collections.EMPTY_LIST;
    }

    public boolean isValid() {
        boolean valid = false;
        if (this.getStatusList().isEmpty()) {
            valid = this.hasSelectResult();
            if (valid) {
                valid = this.getSelectResult().isValidatable();
            }
            if (valid && this.hasInsertResult()) {
                valid = this.getInsertResult().isValidatable();
            }
            if (valid && this.hasUpdateResult()) {
                valid = this.getUpdateResult().isValidatable();
            }
            if (valid && this.hasDeleteResult()) {
                valid = this.getDeleteResult().isValidatable();
            }
        }
        return valid;
    }

    public SqlTransformationResult getSelectResult() {
        return this.selectStatus;
    }

    public SqlTransformationResult getDeleteResult() {
        return this.deleteStatus;
    }

    public SqlTransformationResult getInsertResult() {
        return this.insertStatus;
    }

    public SqlTransformationResult getUpdateResult() {
        return this.updateStatus;
    }

    public boolean hasSelectResult() {
        return this.selectStatus != null;
    }

    public boolean hasDeleteResult() {
        return this.deleteStatus != null;
    }

    public boolean hasInsertResult() {
        return this.insertStatus != null;
    }

    public boolean hasUpdateResult() {
        return this.updateStatus != null;
    }

    public void setSelectResult(SqlTransformationResult selectStatus) {
        this.selectStatus = selectStatus;
    }

    public void setInsertResult(SqlTransformationResult insertStatus) {
        this.insertStatus = insertStatus;
    }

    public void setUpdateResult(SqlTransformationResult updateStatus) {
        this.updateStatus = updateStatus;
    }

    public void setDeleteResult(SqlTransformationResult deleteStatus) {
        this.deleteStatus = deleteStatus;
    }

    public void setStatuses(List statusList) {
        this.statusList = statusList;
    }

    public boolean isDeleteAllowed() {
        return this.deleteAllowed;
    }

    public boolean isInsertAllowed() {
        return this.insertAllowed;
    }

    public boolean isUpdateAllowed() {
        return this.updateAllowed;
    }

    public void setDeleteAllowed(boolean b) {
        this.deleteAllowed = b;
    }

    public void setInsertAllowed(boolean b) {
        this.insertAllowed = b;
    }

    public void setUpdateAllowed(boolean b) {
        this.updateAllowed = b;
    }
}

