/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.id.ObjectID;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.query.AbstractLanguageVisitor;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.sql.symbol.IElementSymbol;
import org.teiid.designer.query.sql.symbol.IGroupSymbol;

public class UpdateLanguageObjectNameVisitor
extends AbstractLanguageVisitor {
    private final Map oldToNewObjects;
    private Map oldToNewNames = new HashMap();

    public UpdateLanguageObjectNameVisitor(Map oldToNewObjects) {
        this.oldToNewObjects = oldToNewObjects;
    }

    public void visit(IElementSymbol obj) {
        String newName;
        String fullName = obj.getShortName();
        if (obj.getGroupSymbol() != null) {
            fullName = String.valueOf(obj.getGroupSymbol().getDefinition()) + "." + fullName;
            this.visit(obj.getGroupSymbol());
        }
        if ((newName = this.getNewName(fullName)) != null) {
            IQueryService queryService = ModelerCore.getTeiidQueryService();
            obj.setShortName(queryService.getSymbolShortName(newName));
        }
    }

    public void visit(IGroupSymbol obj) {
        String fullName = obj.getDefinition();
        String newName = this.getNewName(fullName);
        if (newName != null) {
            if (obj.getDefinition() == null) {
                obj.setName(newName);
            } else {
                obj.setDefinition(newName);
            }
        }
    }

    private String getNewName(String fullName) {
        if (this.oldToNewNames.isEmpty()) {
            for (Map.Entry mapEntry : this.oldToNewObjects.entrySet()) {
                Object oldObj = mapEntry.getKey();
                Object newObj = mapEntry.getValue();
                if (oldObj == null || newObj == null || !(oldObj instanceof EObject) || !(newObj instanceof EObject)) continue;
                EObject oldEobject = (EObject)oldObj;
                EObject newEobject = (EObject)newObj;
                SqlAspect sqlAspect = AspectManager.getSqlAspect((EObject)oldEobject);
                if (sqlAspect == null) continue;
                ObjectID oldObjID = (ObjectID)sqlAspect.getObjectID(oldEobject);
                ObjectID newObjID = (ObjectID)sqlAspect.getObjectID(newEobject);
                if (oldObjID != null && newObjID != null) {
                    this.oldToNewNames.put(oldObjID.toString().toUpperCase(), newObjID.toString());
                }
                String oldObjName = sqlAspect.getFullName(oldEobject);
                String newObjName = sqlAspect.getFullName(newEobject);
                if (oldObjName == null || newObjName == null) continue;
                this.oldToNewNames.put(oldObjName.toUpperCase(), newObjName);
            }
        }
        String newName = (String)this.oldToNewNames.get(fullName.toUpperCase());
        return newName;
    }
}

