/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.procedure;

import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.AspectManager;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.metamodels.webservice.Input;
import org.teiid.designer.webservice.procedure.ProcedureCriteriaMapping;
import org.teiid.designer.webservice.procedure.ProcedureCriteriaMappingImpl;

public class ProcedureCriteriaMappingFactory {
    private static String OPERATION_INPUT_PARAM_NAME = "input";
    private static String XPATH_XSD_ELEMENT_NAME = "xpathValueElement";
    private static String XPATH_FUNCTION_PARAM = "'//*[local-name()=\"" + XPATH_XSD_ELEMENT_NAME + "\"]'";
    private static String XPATH_FUNCTION = "xpathValue(" + OPERATION_INPUT_PARAM_NAME + ", " + XPATH_FUNCTION_PARAM + ")";

    public ProcedureCriteriaMapping createMapping(Input operationInput, EObject xsdElement) {
        CoreArgCheck.isNotNull((Object)operationInput);
        CoreArgCheck.isNotNull((Object)xsdElement);
        IPath xsdElementPath = ModelerCore.getModelEditor().getModelRelativePath(xsdElement);
        SqlAspect sqlAspect = AspectManager.getSqlAspect((EObject)operationInput);
        String inputFullName = sqlAspect.getFullName((EObject)operationInput);
        String xPathExpression = this.generateXPathExpression(inputFullName, xsdElementPath.toString());
        String variablename = this.generateVariableName(xsdElementPath);
        ProcedureCriteriaMappingImpl mapping = new ProcedureCriteriaMappingImpl();
        mapping.setXPathExpression(xPathExpression);
        mapping.setVariableName(variablename);
        return mapping;
    }

    public String generateXPathExpression(String operationInputName, String xsdElementPath) {
        CoreArgCheck.isNotEmpty((String)operationInputName);
        CoreArgCheck.isNotEmpty((String)xsdElementPath);
        String xPathExpression = XPATH_FUNCTION.replaceAll(OPERATION_INPUT_PARAM_NAME, operationInputName);
        xPathExpression = xPathExpression.replaceAll(XPATH_XSD_ELEMENT_NAME, xsdElementPath);
        return xPathExpression;
    }

    public String generateVariableName(IPath xsdElementPath) {
        String xsdElementName = xsdElementPath.lastSegment();
        return "VARIABLES" + CoreStringUtil.Constants.DOT + xsdElementName;
    }
}

