/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.xmlfile;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlParser {
    private ErrorHandler errorHandler;
    private ContentHandler contentHandler;
    public static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public void doParse(File xmlFilePath) throws RuntimeException, IOException, SAXException {
        InputSource inputSource = null;
        try {
            inputSource = new InputSource(new FileReader(xmlFilePath));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.doParse(inputSource);
    }

    public void doParse(String xmlText) throws RuntimeException, IOException, SAXException {
        InputSource inputSource = new InputSource(new StringReader(xmlText));
        this.doParse(inputSource);
    }

    public void doParse(InputSource inputSource) throws RuntimeException, IOException, SAXException {
        SAXParser reader = new SAXParser();
        reader.setErrorHandler(this.errorHandler);
        reader.setContentHandler(this.contentHandler);
        reader.setFeature(VALIDATION_FEATURE, true);
        reader.parse(inputSource);
    }
}

