/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.xmlfile;

import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataImportViewModelPage;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataImportWizard;
import org.teiid.designer.transformation.ui.wizards.xmlfile.TeiidXmlFileImportProcessor;
import org.teiid.designer.transformation.ui.wizards.xmlfile.TeiidXmlFileInfo;
import org.teiid.designer.transformation.ui.wizards.xmlfile.TeiidXmlImportOptionsPage;
import org.teiid.designer.transformation.ui.wizards.xmlfile.TeiidXmlImportSourcePage;
import org.teiid.designer.transformation.ui.wizards.xmlfile.TeiidXmlImportXmlConfigurationPage;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.viewsupport.DesignerPropertiesUtil;

public class TeiidXmlImportWizard
extends TeiidMetadataImportWizard {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(TeiidXmlImportWizard.class);
    private static final String TITLE = TeiidXmlImportWizard.getString("title");
    private static final ImageDescriptor IMAGE = UiPlugin.getDefault().getImageDescriptor("icons/full/wizban/importTeiidMetadataWiz.gif");
    TeiidXmlImportOptionsPage optionsPage;
    TeiidXmlImportSourcePage sourcePage;

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public TeiidXmlImportWizard() {
        super((AbstractUIPlugin)UiPlugin.getDefault(), TITLE, IMAGE);
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection inputSelection) {
        super.init(workbench, inputSelection);
        if (this.isOpenProjectExists()) {
            this.getFileInfo().setFileMode(2);
        }
    }

    @Override
    public void addPages() {
        if (!this.isOpenProjectExists()) {
            return;
        }
        this.optionsPage = new TeiidXmlImportOptionsPage(this.getFileInfo());
        this.addPage((IWizardPage)this.optionsPage);
        this.sourcePage = new TeiidXmlImportSourcePage(this.getFileInfo());
        this.addPage((IWizardPage)this.sourcePage);
        TeiidXmlImportXmlConfigurationPage sqlPage = new TeiidXmlImportXmlConfigurationPage(this.getFileInfo());
        this.addPage((IWizardPage)sqlPage);
        TeiidMetadataImportViewModelPage viewModelPage = new TeiidMetadataImportViewModelPage(this.getFileInfo());
        this.addPage((IWizardPage)viewModelPage);
    }

    @Override
    public boolean finish() {
        final TeiidXmlFileImportProcessor processor = new TeiidXmlFileImportProcessor(this.getFileInfo(), this.getShell());
        UiUtil.runInSwtThread((Runnable)new Runnable(){

            @Override
            public void run() {
                processor.execute();
            }
        }, (boolean)false);
        if (this.getDesignerProperties() != null) {
            DesignerPropertiesUtil.setSourceModelName((Properties)this.getDesignerProperties(), (String)this.getFileInfo().getSourceModelName());
            DesignerPropertiesUtil.setViewModelName((Properties)this.getDesignerProperties(), (String)this.getFileInfo().getViewModelName());
            if (!this.getFileInfo().getXmlFileInfos().isEmpty() && this.getFileInfo().getXmlFileInfos().size() == 1) {
                TeiidXmlFileInfo info = this.getFileInfo().getXmlFileInfos().iterator().next();
                DesignerPropertiesUtil.setPreviewTargetModelName((Properties)this.getDesignerProperties(), (String)this.getFileInfo().getViewModelName());
                DesignerPropertiesUtil.setPreviewTargetObjectName((Properties)this.getDesignerProperties(), (String)info.getViewTableName());
            }
        }
        return true;
    }

    public void setFileOption(int option) {
        this.getFileInfo().setFileMode(option);
    }

    @Override
    protected void updateForProperties() {
        Properties desProps = this.getDesignerProperties();
        if (desProps == null || desProps.isEmpty()) {
            return;
        }
        IProject project = DesignerPropertiesUtil.getProject((Properties)this.getDesignerProperties());
        IContainer srcFolderResrc = DesignerPropertiesUtil.getSourcesFolder((Properties)desProps);
        IContainer viewFolderResrc = DesignerPropertiesUtil.getViewsFolder((Properties)desProps);
        if (srcFolderResrc != null) {
            this.getFileInfo().setSourceModelLocation(srcFolderResrc.getFullPath());
        } else if (project != null) {
            this.getFileInfo().setSourceModelLocation(project.getFullPath());
        }
        if (viewFolderResrc != null) {
            this.getFileInfo().setViewModelLocation(viewFolderResrc.getFullPath());
        } else if (project != null) {
            this.getFileInfo().setViewModelLocation(project.getFullPath());
        }
        String profileName = DesignerPropertiesUtil.getConnectionProfileName((Properties)desProps);
        if (profileName != null && !profileName.isEmpty()) {
            this.sourcePage.setDesignerProperties(desProps);
        }
        if (!this.openProjectExists()) {
            DesignerPropertiesUtil.setProjectStatus((Properties)desProps, (String)"noOpenProject");
        }
    }
}

