/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.rest;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.XML;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.datatools.connectivity.model.Parameter;
import org.teiid.designer.core.util.URLHelper;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.datatools.connection.IConnectionInfoHelper;
import org.teiid.designer.datatools.ui.actions.EditConnectionProfileAction;
import org.teiid.designer.datatools.ui.dialogs.NewTeiidFilteredCPWizard;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataImportInfo;
import org.teiid.designer.transformation.ui.wizards.file.TeiidMetadataImportSourcePage;
import org.teiid.designer.transformation.ui.wizards.xmlfile.TeiidXmlFileInfo;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.dialog.FileUiUtils;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.util.WizardUtil;
import org.teiid.designer.ui.common.viewsupport.FileSystemLabelProvider;
import org.teiid.designer.ui.common.widget.DefaultScrolledComposite;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;
import org.teiid.designer.ui.viewsupport.DesignerPropertiesUtil;

public class TeiidRestImportSourcePage
extends AbstractWizardPage
implements UiConstants,
InternalUiConstants.Widgets,
CoreStringUtil.Constants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(TeiidMetadataImportSourcePage.class);
    private static final String TITLE = TeiidRestImportSourcePage.getString("title");
    private static final String REST_TITLE = TeiidRestImportSourcePage.getString("restTitle");
    private static final String INITIAL_MESSAGE = TeiidRestImportSourcePage.getString("initialMessage");
    private static final String REST_SOURCE_LABEL = TeiidRestImportSourcePage.getString("restSourceLabel");
    private static final String NEW_BUTTON = "New...";
    private static final String EDIT_BUTTON = "Edit...";
    private static final String EMPTY_STRING = "";
    private static final String DOT_XML = ".XML";
    private static final String DOT_XML_LOWER = ".xml";
    private static final String XML_URL_FILE_ID = "org.teiid.designer.datatools.profiles.xml.fileurl";
    private static final String XML_FILE_ID = "org.teiid.designer.datatools.profiles.xml.localfile";
    private static final String TEIID_WS_ID = "org.teiid.designer.datatools.profiles.ws.WSConnectionProfile";
    private static final String LOCAL_FILE_NAME_KEY = "LocalFilePath";
    private static final String FILE_URL_NAME_KEY = "URL";
    private static final int DEFAULT_READING_SIZE = 8192;
    private ILabelProvider srcLabelProvider;
    private Combo srcCombo;
    private Button editCPButton;
    private TableViewer fileViewer;
    private DataFolderContentProvider fileContentProvider;
    private TableViewerColumn fileNameColumn;
    Text responseTypeText;
    private Map<String, Object> parameterMap;
    private ProfileManager profileManager = ProfileManager.getInstance();
    private Collection<IConnectionProfile> connectionProfiles;
    private TeiidMetadataImportInfo info;
    boolean creatingControl = false;
    boolean synchronizing = false;
    boolean processingChecks = false;
    IStatus fileParsingStatus;
    IConnectionInfoHelper connectionInfoHelper;
    Properties designerProperties;
    boolean controlComplete = false;
    boolean visibleCompleted = false;

    private static String getString(String id) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    private static String getString(String id, String arg) {
        return Util.getString(String.valueOf(I18N_PREFIX) + id, (Object)arg);
    }

    public TeiidRestImportSourcePage(TeiidMetadataImportInfo info) {
        this(null, info);
    }

    public TeiidRestImportSourcePage(Object selection, TeiidMetadataImportInfo info) {
        super(TeiidMetadataImportSourcePage.class.getSimpleName(), TITLE);
        this.info = info;
        this.setPageComplete(false);
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/wizban/importTeiidMetadataWiz.gif"));
        this.connectionInfoHelper = new ConnectionInfoHelper();
        this.parameterMap = new HashMap<String, Object>();
    }

    public void createControl(Composite parent) {
        this.controlComplete = false;
        Composite hostPanel = new Composite(parent, 0);
        hostPanel.setLayout((Layout)new GridLayout(1, false));
        hostPanel.setLayoutData((Object)new GridData(1808));
        DefaultScrolledComposite scrolledComposite = new DefaultScrolledComposite(hostPanel);
        hostPanel.setLayout((Layout)new GridLayout(1, false));
        hostPanel.setLayoutData((Object)new GridData(1808));
        Composite mainPanel = scrolledComposite.getPanel();
        mainPanel.setLayoutData((Object)new GridData(1808));
        mainPanel.setLayout((Layout)new GridLayout(1, false));
        this.createProfileGroup(mainPanel);
        this.createFolderContentsListGroup(mainPanel);
        scrolledComposite.sizeScrolledPanel();
        this.setControl((Control)hostPanel);
        this.setMessage(INITIAL_MESSAGE);
        this.controlComplete = true;
    }

    private void createProfileGroup(Composite parent) {
        Group profileGroup = WidgetFactory.createGroup((Composite)parent, (String)REST_SOURCE_LABEL, (int)0, (int)2, (int)3);
        profileGroup.setLayoutData((Object)new GridData(768));
        ((GridData)profileGroup.getLayoutData()).widthHint = 400;
        this.srcLabelProvider = new LabelProvider(){

            public String getText(Object source) {
                return ((IConnectionProfile)source).getName();
            }
        };
        this.srcCombo = WidgetFactory.createCombo((Composite)profileGroup, (int)8, (int)768, (List)((ArrayList)this.connectionProfiles), null, (ILabelProvider)this.srcLabelProvider, (boolean)true);
        this.srcCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TeiidRestImportSourcePage.this.profileComboSelectionChanged();
                TeiidRestImportSourcePage.this.fileViewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.srcCombo.setVisibleItemCount(10);
        WidgetFactory.createButton((Composite)profileGroup, (String)NEW_BUTTON).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TeiidRestImportSourcePage.this.createNewConnectionProfile();
            }
        });
        this.editCPButton = WidgetFactory.createButton((Composite)profileGroup, (String)EDIT_BUTTON);
        this.editCPButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TeiidRestImportSourcePage.this.editConnectionProfile();
            }
        });
        this.editCPButton.setEnabled(false);
        Composite responseTypePanel = WidgetFactory.createPanel((Composite)profileGroup, (int)0, (int)768, (int)1, (int)2);
        Label typeLabel = new Label(responseTypePanel, 0);
        typeLabel.setText("Response Type");
        this.responseTypeText = new Text(responseTypePanel, 2052);
        this.responseTypeText.setBackground(WidgetUtil.getReadOnlyBackgroundColor());
        this.responseTypeText.setForeground(WidgetUtil.getDarkBlueColor());
        this.responseTypeText.setLayoutData((Object)new GridData(768));
        this.responseTypeText.setEditable(false);
    }

    private void createFolderContentsListGroup(Composite parent) {
        String groupLabel = TeiidRestImportSourcePage.getString("folderRestContentsGroup");
        Group folderContentsGroup = WidgetFactory.createGroup((Composite)parent, (String)groupLabel, (int)4, (int)3, (int)3);
        GridData gd_1 = new GridData(1808);
        gd_1.heightHint = 180;
        folderContentsGroup.setLayoutData((Object)gd_1);
        Label locationLabel = new Label((Composite)folderContentsGroup, 0);
        locationLabel.setText(TeiidRestImportSourcePage.getString("folderLocation"));
        this.createFileTableViewer((Composite)folderContentsGroup);
        Button showFileContentsButton = new Button((Composite)folderContentsGroup, 8);
        showFileContentsButton.setText("Show Contents");
        showFileContentsButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (TeiidRestImportSourcePage.this.info.getSourceXmlFileInfo() != null) {
                    FileUiUtils.INSTANCE.showFileContents(TeiidRestImportSourcePage.this.getShell(), TeiidRestImportSourcePage.this.info.getSourceXmlFileInfo().getDataFile(), "Response Document", TeiidRestImportSourcePage.this.info.getSourceXmlFileInfo().getDataFile().getName());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createFileTableViewer(Composite parent) {
        Table table = new Table(parent, 2852);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayout((Layout)new TableLayout());
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fileViewer = new TableViewer(table);
        GridData gd = new GridData(1808);
        gd.heightHint = 160;
        gd.horizontalSpan = 3;
        this.fileViewer.getControl().setLayoutData((Object)gd);
        this.fileContentProvider = new DataFolderContentProvider();
        this.fileViewer.setContentProvider((IContentProvider)this.fileContentProvider);
        this.fileViewer.setLabelProvider((IBaseLabelProvider)new FileSystemLabelProvider());
        this.fileViewer.getTable().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (TeiidRestImportSourcePage.this.processingChecks) {
                    return;
                }
                TeiidRestImportSourcePage.this.processingChecks = true;
                if (e.detail == 32) {
                    TableItem tableItem = (TableItem)e.item;
                    boolean wasChecked = tableItem.getChecked();
                    if (tableItem.getData() instanceof File) {
                        TeiidRestImportSourcePage.this.fileViewer.getTable().setSelection(new TableItem[]{tableItem});
                        if (wasChecked) {
                            TableItem[] tableItemArray = TeiidRestImportSourcePage.this.fileViewer.getTable().getItems();
                            int n = tableItemArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TableItem item = tableItemArray[n2];
                                if (item != tableItem) {
                                    item.setChecked(false);
                                }
                                ++n2;
                            }
                        }
                        TeiidRestImportSourcePage.this.info.setDoProcessXml((File)tableItem.getData(), wasChecked);
                    }
                }
                TeiidRestImportSourcePage.this.processingChecks = false;
                TeiidRestImportSourcePage.this.synchronizeUI();
                TeiidRestImportSourcePage.this.validatePage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fileNameColumn = new TableViewerColumn(this.fileViewer, 16384);
        if (this.info.getFileMode() == 3) {
            this.fileNameColumn.getColumn().setText("XML Data File URL");
        } else {
            this.fileNameColumn.getColumn().setText(TeiidRestImportSourcePage.getString("xmlDataFileNameColumn"));
        }
        this.fileNameColumn.setLabelProvider((CellLabelProvider)new DataFileContentColumnLabelProvider());
        this.fileNameColumn.getColumn().pack();
    }

    void profileComboSelectionChanged() {
        boolean changed = false;
        if (this.srcCombo.getSelectionIndex() > -1) {
            String cpName = this.srcCombo.getItem(this.srcCombo.getSelectionIndex());
            for (IConnectionProfile profile : this.connectionProfiles) {
                if (!profile.getName().equalsIgnoreCase(cpName)) continue;
                changed = this.setConnectionProfile(profile, false);
                if (changed) {
                    this.clearFileListViewer();
                    this.loadFileListViewer();
                }
                break;
            }
        } else {
            changed = true;
            this.setConnectionProfile(null, false);
        }
        if (changed) {
            this.synchronizeUI();
            this.validatePage();
            this.editCPButton.setEnabled(this.getConnectionProfile() != null);
        }
    }

    public void setDesignerProperties(Properties properties) {
        this.designerProperties = properties;
    }

    private boolean setConnectionProfile(IConnectionProfile profile, boolean wasEdited) {
        IConnectionProfile existingProfile = this.info.getConnectionProfile();
        if (existingProfile != null && !wasEdited && existingProfile != null && profile != null && existingProfile.getName().equals(profile.getName())) {
            return false;
        }
        if (profile == null || this.isInvalidXmlFileProfile(profile)) {
            this.fileViewer.setInput(null);
            this.clearFileListViewer();
        }
        this.parameterMap.clear();
        this.info.setConnectionProfile(profile);
        return true;
    }

    private IConnectionProfile getConnectionProfile() {
        return this.info.getConnectionProfile();
    }

    private boolean isRestConnectionProfile() {
        IConnectionProfile profile = this.info.getConnectionProfile();
        if (profile != null) {
            return profile.getProviderId().equals(TEIID_WS_ID);
        }
        return false;
    }

    private boolean isValidProfileForPage(IConnectionProfile profile) {
        boolean isValid = false;
        if (this.info.isXmlLocalFileMode() && profile.getProviderId().equalsIgnoreCase(XML_FILE_ID)) {
            isValid = true;
        } else if (this.info.isRestUrlFileMode() && profile.getProviderId().equalsIgnoreCase(TEIID_WS_ID)) {
            isValid = true;
        }
        return isValid;
    }

    private boolean isInvalidXmlFileProfile(IConnectionProfile profile) {
        File theXmlFile = this.getFileForConnectionProfile(profile);
        return theXmlFile != null && theXmlFile.exists() && !theXmlFile.isFile();
    }

    private void clearFileListViewer() {
        this.info.clearXmlFileInfos();
        this.info.clearFileInfos();
        this.fileViewer.getTable().clearAll();
        this.info.setSourceXmlFileInfo();
    }

    private void loadFileListViewer() {
        if (this.getConnectionProfile() != null) {
            File theXmlFile = this.getFileForConnectionProfile(this.getConnectionProfile());
            String urlString = this.getUrlStringForConnectionProfile();
            if (theXmlFile != null) {
                if (theXmlFile.exists() && theXmlFile.isFile()) {
                    this.setXmlFile(theXmlFile, false, null);
                }
            } else if (urlString != null && urlString.trim().length() > 0) {
                File xmlFile = null;
                this.fileViewer.setInput((Object)"no input");
                xmlFile = this.isRestConnectionProfile() ? this.getXmlFileFromRestUrl(this.getConnectionProfile()) : this.getXmlFileFromUrl(urlString);
                if (xmlFile != null && xmlFile.exists()) {
                    this.setXmlFile(xmlFile, true, urlString);
                }
            } else {
                this.fileViewer.setInput(null);
                MessageDialog.openError((Shell)this.getShell(), (String)TeiidRestImportSourcePage.getString("invalidRESTConnectionProfileTitle"), (String)TeiidRestImportSourcePage.getString("invalidRESTConnectionProfileMessage"));
            }
        }
    }

    private int write(OutputStream out, InputStream is) throws IOException {
        byte[] l_buffer = new byte[8192];
        int writen = 0;
        try {
            int l_nbytes = 0;
            int readLength = l_buffer.length;
            while ((l_nbytes = is.read(l_buffer, 0, readLength)) != -1) {
                out.write(l_buffer, 0, l_nbytes);
                writen += l_nbytes;
            }
            int n = writen;
            return n;
        }
        finally {
            try {
                is.close();
            }
            finally {
                out.close();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private File getXmlFileFromRestUrl(IConnectionProfile profile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private File convertJsonToXml(File jsonFile) throws IOException, Exception {
        String xml;
        String jsonText = null;
        boolean isArray = false;
        try {
            jsonText = this.readFile(jsonFile);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (jsonText.trim().startsWith("[")) {
            isArray = true;
        }
        if (isArray) {
            JSONArray jsonArray = new JSONArray(jsonText);
            xml = "<response>" + XML.toString((Object)jsonArray, (String)"response") + "</response>";
        } else {
            JSONObject jsonObject = new JSONObject(jsonText);
            xml = XML.toString((Object)jsonObject, (String)"response");
        }
        FileUtils.write((byte[])xml.getBytes(), (File)jsonFile);
        return jsonFile;
    }

    private String readFile(File f) throws IOException {
        String line;
        BufferedReader r = new BufferedReader(new FileReader(f));
        StringBuilder buf = new StringBuilder();
        while ((line = r.readLine()) != null) {
            buf.append(line);
            buf.append("\n");
        }
        r.close();
        return buf.toString();
    }

    private File getXmlFileFromUrl(String urlString) {
        File xmlFile = null;
        URL newUrl = null;
        try {
            newUrl = URLHelper.buildURL((String)urlString);
        }
        catch (MalformedURLException e) {
            Util.log((Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)TeiidRestImportSourcePage.getString("malformedUrlErrorTitle"), (String)UiConstants.Util.getString("malformedUrlErrorMessage", new Object[]{urlString, e.getMessage()}));
        }
        if (newUrl != null) {
            boolean resolved = true;
            try {
                resolved = URLHelper.resolveUrl((URL)newUrl);
            }
            catch (Exception exception) {
                resolved = false;
            }
            if (resolved) {
                try {
                    String filePath = TeiidRestImportSourcePage.formatPath(newUrl);
                    xmlFile = URLHelper.createFileFromUrl((URL)newUrl, (String)CoreStringUtil.createFileName((String)filePath), (String)DOT_XML_LOWER);
                }
                catch (MalformedURLException theException) {
                    Util.log((Throwable)theException);
                }
                catch (IOException theException) {
                    Util.log((Throwable)theException);
                }
            }
        }
        return xmlFile;
    }

    String getUrl(String url, Map parameterMap) {
        StringBuilder previewUrl = new StringBuilder();
        String urlText = url;
        String parameters = null;
        try {
            parameters = this.buildParameterString(url, parameterMap);
        }
        catch (UnsupportedEncodingException ex) {
            UiConstants.Util.log((Throwable)ex);
        }
        previewUrl.append(urlText).append(parameters);
        return previewUrl.toString();
    }

    private String buildParameterString(String url, Map<String, Parameter> parameterMap) throws UnsupportedEncodingException {
        StringBuilder parameterString = new StringBuilder();
        if (parameterMap == null) {
            return parameterString.toString();
        }
        for (String key : parameterMap.keySet()) {
            Parameter value = parameterMap.get(key);
            if (value.getType() == Parameter.Type.URI) {
                parameterString.append(url.endsWith("/") ? EMPTY_STRING : "/").append(value.getDefaultValue());
            }
            if (value.getType() != Parameter.Type.Query) continue;
            if (parameterString.length() == 0 || !parameterString.toString().contains("?")) {
                parameterString.append("?");
            } else {
                parameterString.append("&");
            }
            parameterString.append(this.encodeString(key)).append("=").append(this.encodeString(value.getDefaultValue()));
        }
        return parameterString.toString();
    }

    private String encodeString(String str) throws UnsupportedEncodingException {
        return URLEncoder.encode(str, Charset.defaultCharset().displayName());
    }

    private void setXmlFile(File xmlFile, boolean isUrl, String urlString) {
        this.fileViewer.setInput((Object)xmlFile);
        TeiidXmlFileInfo oldFileInfo = this.info.getXmlFileInfo(xmlFile);
        String oldVPName = null;
        if (oldFileInfo != null) {
            oldVPName = oldFileInfo.getViewProcedureName();
            this.info.clearXmlFileInfos();
        } else if (!this.info.getXmlFileInfos().isEmpty()) {
            this.info.clearXmlFileInfos();
        }
        TeiidXmlFileInfo fileInfo = new TeiidXmlFileInfo(xmlFile);
        if (oldVPName != null) {
            fileInfo.setViewProcedureName(oldVPName);
        }
        fileInfo.setIsUrl(isUrl);
        if (isUrl) {
            fileInfo.setParameterMap(this.parameterMap);
            fileInfo.setXmlFileUrl(urlString);
            Properties props = this.getConnectionProfile().getBaseProperties();
            fileInfo.setResponseType((String)props.get("responseType"));
        }
        this.info.addXmlFileInfo(fileInfo);
        this.fileViewer.getTable().select(0);
        this.fileViewer.getTable().getItem(0).setChecked(true);
        this.info.setDoProcessXml(fileInfo.getDataFile(), true);
        this.fileParsingStatus = fileInfo.getParsingStatus();
        if (this.fileParsingStatus.getSeverity() == 4) {
            MessageDialog.openError((Shell)this.getShell(), (String)TeiidRestImportSourcePage.getString("parsingErrorTitle"), (String)this.fileParsingStatus.getMessage());
        }
        this.info.setSourceXmlFileInfo();
    }

    private void resetXmlFile(File xmlFile) {
        this.fileViewer.setInput((Object)xmlFile);
        TeiidXmlFileInfo fileInfo = this.info.getXmlFileInfo(xmlFile);
        this.fileViewer.getTable().select(0);
        this.fileViewer.getTable().getItem(0).setChecked(true);
        if (fileInfo != null) {
            this.info.setDoProcessXml(fileInfo.getDataFile(), true);
            this.fileParsingStatus = fileInfo.getParsingStatus();
            if (this.fileParsingStatus.getSeverity() == 4) {
                MessageDialog.openError((Shell)this.getShell(), (String)TeiidRestImportSourcePage.getString("parsingErrorTitle"), (String)this.fileParsingStatus.getMessage());
            }
        }
    }

    public static String formatPath(URL newUrl) {
        String filePath = newUrl.getFile();
        while (filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }
        int dotLocation = filePath.indexOf(".");
        if (dotLocation > -1) {
            filePath = filePath.substring(0, dotLocation);
        }
        if (filePath.equals(EMPTY_STRING)) {
            filePath = "response";
        }
        return filePath;
    }

    private File getFileForConnectionProfile(IConnectionProfile profile) {
        Properties props;
        String fileListValue;
        if (profile != null && (fileListValue = (String)(props = profile.getBaseProperties()).get(LOCAL_FILE_NAME_KEY)) != null) {
            return new File(fileListValue);
        }
        return null;
    }

    private String getUrlStringForConnectionProfile() {
        if (this.getConnectionProfile() != null) {
            Properties props = this.getConnectionProfile().getBaseProperties();
            if (this.isRestConnectionProfile()) {
                String fileListValue = ConnectionInfoHelper.readEndPointProperty((Properties)props);
                if (fileListValue != null) {
                    return fileListValue;
                }
            } else {
                String fileListValue = (String)props.get(FILE_URL_NAME_KEY);
                if (fileListValue != null) {
                    return fileListValue;
                }
            }
        }
        return null;
    }

    void createNewConnectionProfile() {
        NewTeiidFilteredCPWizard wiz = null;
        wiz = this.info.getFileMode() == 3 ? new NewTeiidFilteredCPWizard(XML_URL_FILE_ID) : (this.info.getFileMode() == 2 ? new NewTeiidFilteredCPWizard(XML_FILE_ID) : new NewTeiidFilteredCPWizard(TEIID_WS_ID));
        WizardDialog wizardDialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wiz);
        wizardDialog.setBlockOnOpen(true);
        CPListener listener = new CPListener();
        ProfileManager.getInstance().addProfileListener((IProfileListener)listener);
        if (wizardDialog.open() == 0) {
            this.refreshConnectionProfiles();
            this.resetCPComboItems();
            this.setConnectionProfile(listener.getChangedProfile(), true);
            this.selectProfile(listener.getChangedProfile());
            this.profileComboSelectionChanged();
            this.loadFileListViewer();
            this.synchronizeUI();
            this.validatePage();
            this.editCPButton.setEnabled(this.getConnectionProfile() != null);
        }
        ProfileManager.getInstance().removeProfileListener((IProfileListener)listener);
    }

    void selectProfile(IConnectionProfile profile) {
        int index = 0;
        String[] stringArray = this.srcCombo.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item != null && item.equalsIgnoreCase(profile.getName())) {
                this.srcCombo.select(index);
                this.profileComboSelectionChanged();
                break;
            }
            ++index;
            ++n2;
        }
    }

    void resetCPComboItems() {
        if (this.srcCombo != null) {
            WidgetUtil.setComboItems((Combo)this.srcCombo, this.connectionProfiles, (ILabelProvider)this.srcLabelProvider, (boolean)true);
        }
    }

    void editConnectionProfile() {
        if (this.getConnectionProfile() != null) {
            IConnectionProfile currentProfile = this.getConnectionProfile();
            EditConnectionProfileAction action = new EditConnectionProfileAction(this.getShell(), currentProfile);
            CPListener listener = new CPListener();
            ProfileManager.getInstance().addProfileListener((IProfileListener)listener);
            action.run();
            if (action.wasFinished()) {
                this.setConnectionProfile(listener.getChangedProfile(), true);
                this.refreshConnectionProfiles();
                WidgetUtil.setComboItems((Combo)this.srcCombo, this.connectionProfiles, (ILabelProvider)this.srcLabelProvider, (boolean)true);
                WidgetUtil.setComboText((Combo)this.srcCombo, (Object)this.getConnectionProfile(), (ILabelProvider)this.srcLabelProvider);
                this.info.clearXmlFileInfos();
                this.info.setSourceXmlFileInfo();
                this.setConnectionProfile(null, false);
                this.selectConnectionProfile(currentProfile.getName());
                ProfileManager.getInstance().removeProfileListener((IProfileListener)listener);
            }
            ProfileManager.getInstance().removeProfileListener((IProfileListener)listener);
        }
    }

    void synchronizeUI() {
        this.synchronizing = true;
        for (TeiidXmlFileInfo fileInfo : this.info.getXmlFileInfos()) {
            if (!fileInfo.doProcess()) continue;
            fileInfo.getDataFile().getName();
            break;
        }
        this.synchronizing = false;
    }

    public void selectConnectionProfile(String name) {
        if (name == null) {
            return;
        }
        int cpIndex = -1;
        int i = 0;
        String[] stringArray = this.srcCombo.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item != null && item.length() > 0 && item.toUpperCase().equalsIgnoreCase(name.toUpperCase())) {
                cpIndex = i;
                break;
            }
            ++i;
            ++n2;
        }
        if (cpIndex > -1) {
            this.srcCombo.select(cpIndex);
            this.profileComboSelectionChanged();
        }
    }

    private void setProfileFromProperties() {
        String profileName;
        if (this.designerProperties != null && (profileName = DesignerPropertiesUtil.getConnectionProfileName((Properties)this.designerProperties)) != null && !profileName.isEmpty()) {
            this.selectConnectionProfile(profileName);
        }
    }

    private void refreshConnectionProfiles() {
        IConnectionProfile[] tempProfiles;
        this.connectionProfiles = new ArrayList<IConnectionProfile>();
        IConnectionProfile[] iConnectionProfileArray = tempProfiles = this.profileManager.getProfilesByCategory("org.teiid.designer.import.category");
        int n = tempProfiles.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionProfile profile = iConnectionProfileArray[n2];
            if (this.info.isXmlLocalFileMode() && profile.getProviderId().equalsIgnoreCase(XML_FILE_ID)) {
                this.connectionProfiles.add(profile);
            } else if (this.info.isXmlUrlFileMode() && profile.getProviderId().equalsIgnoreCase(XML_URL_FILE_ID)) {
                this.connectionProfiles.add(profile);
            } else if (this.info.isRestUrlFileMode() && profile.getProviderId().equalsIgnoreCase(TEIID_WS_ID)) {
                this.connectionProfiles.add(profile);
            }
            ++n2;
        }
    }

    private boolean validatePage() {
        IConnectionProfile connProfile = this.getConnectionProfile();
        if (connProfile == null) {
            this.setThisPageComplete(TeiidRestImportSourcePage.getString("noRestConnectionProfileSelected"), 3);
            return false;
        }
        boolean fileSelected = false;
        TableItem[] tableItemArray = this.fileViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                fileSelected = true;
                break;
            }
            ++n2;
        }
        if (!fileSelected) {
            this.setThisPageComplete(TeiidRestImportSourcePage.getString("noRestResponseFilesSelected"), 3);
            return false;
        }
        if (this.fileParsingStatus.getSeverity() == 4) {
            this.setThisPageComplete(this.fileParsingStatus.getMessage(), 3);
            return false;
        }
        this.setThisPageComplete(EMPTY_STRING, 0);
        return true;
    }

    protected void setThisPageComplete(String message, int severity) {
        WizardUtil.setPageComplete((WizardPage)this, (String)message, (int)severity);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setTitle(REST_TITLE);
            this.fileNameColumn.getColumn().setText(TeiidRestImportSourcePage.getString("restDataFileNameColumn"));
            IConnectionProfile currentProfile = this.getConnectionProfile();
            if (currentProfile == null) {
                this.fileViewer.setInput(null);
                this.info.setViewModelName(null);
                this.info.setSourceModelName(null);
            } else if (!this.isValidProfileForPage(currentProfile)) {
                this.setConnectionProfile(null, false);
                this.fileViewer.setInput(null);
                this.info.setViewModelName(null);
                this.info.setSourceModelName(null);
            } else if (this.isInvalidXmlFileProfile(currentProfile)) {
                this.fileViewer.setInput(null);
                this.info.setViewModelName(null);
                this.info.setSourceModelName(null);
            }
            this.refreshConnectionProfiles();
            this.resetCPComboItems();
            this.loadFileListViewer();
            this.fileNameColumn.getColumn().pack();
            this.synchronizeUI();
            this.setProfileFromProperties();
            this.validatePage();
            this.visibleCompleted = true;
        }
    }

    public class CPListener
    implements IProfileListener {
        IConnectionProfile latestProfile;

        public void profileAdded(IConnectionProfile profile) {
            this.latestProfile = profile;
        }

        public void profileChanged(IConnectionProfile profile) {
            this.latestProfile = profile;
        }

        public void profileDeleted(IConnectionProfile profile) {
        }

        public IConnectionProfile getChangedProfile() {
            return this.latestProfile;
        }
    }

    class DataFileContentColumnLabelProvider
    extends ColumnLabelProvider {
        public String getText(Object element) {
            if (element instanceof File) {
                return ((File)element).getName();
            }
            return TeiidRestImportSourcePage.EMPTY_STRING;
        }

        public String getToolTipText(Object element) {
            return TeiidRestImportSourcePage.getString("fileNameColumnTooltip");
        }

        public Image getImage(Object element) {
            return null;
        }
    }

    class DataFolderContentProvider
    implements ITreeContentProvider {
        private Object[] NO_CHILDREN = new Object[0];

        DataFolderContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object theParent) {
            File[] result = null;
            if (theParent instanceof File) {
                result = ((File)theParent).listFiles();
            }
            return result == null ? this.NO_CHILDREN : result;
        }

        public Object[] getElements(Object theInput) {
            if (theInput instanceof File && ((File)theInput).isDirectory()) {
                File[] allFiles = ((File)theInput).listFiles();
                ArrayList<File> goodFilesList = new ArrayList<File>();
                File[] fileArray = allFiles;
                int n = allFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File theFile = fileArray[n2];
                    if (!theFile.isDirectory() && theFile.getName().toUpperCase().endsWith(TeiidRestImportSourcePage.DOT_XML)) {
                        goodFilesList.add(theFile);
                    }
                    ++n2;
                }
                return goodFilesList.toArray(new File[0]);
            }
            if (theInput instanceof File) {
                ArrayList<File> goodFilesList = new ArrayList<File>();
                File theFile = (File)theInput;
                if (theFile.getName().toUpperCase().endsWith(TeiidRestImportSourcePage.DOT_XML)) {
                    goodFilesList.add(theFile);
                }
                return goodFilesList.toArray(new File[0]);
            }
            ArrayList goodFilesList = new ArrayList();
            return goodFilesList.toArray(new File[0]);
        }

        public Object getParent(Object theElement) {
            return theElement instanceof File ? ((File)theElement).getParentFile() : null;
        }

        public boolean hasChildren(Object theElement) {
            Object[] kids = this.getChildren(theElement);
            return kids != null && kids.length > 0;
        }

        public void inputChanged(Viewer theViewer, Object theOldInput, Object theNewInput) {
        }
    }
}

