/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards.file;

import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.DirectionKind;
import org.teiid.designer.metamodels.relational.NullableType;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.relational.ProcedureResult;
import org.teiid.designer.metamodels.relational.RelationalFactory;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class FlatFileRelationalModelFactory
implements UiConstants {
    public static final String RELATIONAL_PACKAGE_URI = "http://www.metamatrix.com/metamodels/Relational";
    public static final RelationalFactory factory = RelationalFactory.eINSTANCE;
    public static final DatatypeManager datatypeManager = ModelerCore.getWorkspaceDatatypeManager();
    public static final String GET_FILES = "getFiles";
    public static final String GET_TEXT_FILES = "getTextFiles";
    public static final String SAVE_FILE = "saveFile";
    public static final String ALL_PROCEDURES = "allProcedures";
    public static final String INVOKE = "invoke";
    public static final String INVOKE_HTTP = "invokeHttp";
    public static final String ALL_INVOKE_PROCEDURES = "allInvokeProcedures";
    public static final int DEFAULT_STRING_LENGTH = 4000;
    public static final int DEFAULT_PRECISION = 10;
    public static final String INT_STR = "int";
    public static final String INTEGER_STR = "integer";
    private static boolean isTransactionable = ModelerCore.getPlugin() != null;

    public ModelResource createModel(IPath location, String modelName) throws ModelerCoreException {
        ModelResource mr = this.createRelationalModel(location, modelName);
        this.addGetFilesProcedure(mr);
        this.addGetTextFilesProcedure(mr);
        this.addSaveFileProcedure(mr);
        return mr;
    }

    public ModelResource createRelationalModel(IPath location, String modelName) throws ModelWorkspaceException {
        ModelResource resrc = ModelerCore.createModelResource((IPath)location, (String)modelName);
        resrc.getModelAnnotation().setPrimaryMetamodelUri(RELATIONAL_PACKAGE_URI);
        resrc.getModelAnnotation().setModelType(ModelType.PHYSICAL_LITERAL);
        ModelUtilities.initializeModelContainers((ModelResource)resrc, (String)"Create Model Containers", (Object)this);
        return resrc;
    }

    public boolean addMissingProcedure(ModelResource modelResource, String specificProcedure) throws ModelerCoreException {
        if (modelResource != null) {
            if (specificProcedure.equalsIgnoreCase(ALL_PROCEDURES)) {
                if (!FlatFileRelationalModelFactory.procedureExists(modelResource, GET_FILES)) {
                    this.addGetFilesProcedure(modelResource);
                }
                if (!FlatFileRelationalModelFactory.procedureExists(modelResource, GET_TEXT_FILES)) {
                    this.addGetTextFilesProcedure(modelResource);
                }
                if (!FlatFileRelationalModelFactory.procedureExists(modelResource, SAVE_FILE)) {
                    this.addSaveFileProcedure(modelResource);
                }
            } else if (specificProcedure.equalsIgnoreCase(GET_FILES) && !FlatFileRelationalModelFactory.procedureExists(modelResource, GET_FILES)) {
                this.addGetFilesProcedure(modelResource);
            } else if (specificProcedure.equalsIgnoreCase(GET_TEXT_FILES) && !FlatFileRelationalModelFactory.procedureExists(modelResource, GET_TEXT_FILES)) {
                this.addGetTextFilesProcedure(modelResource);
            } else if (specificProcedure.equalsIgnoreCase(SAVE_FILE) && !FlatFileRelationalModelFactory.procedureExists(modelResource, SAVE_FILE)) {
                this.addSaveFileProcedure(modelResource);
            } else if (specificProcedure.equalsIgnoreCase(ALL_INVOKE_PROCEDURES)) {
                if (!FlatFileRelationalModelFactory.procedureExists(modelResource, INVOKE)) {
                    this.addInvokeProcedure(modelResource);
                }
                if (!FlatFileRelationalModelFactory.procedureExists(modelResource, INVOKE_HTTP)) {
                    this.addInvokeHttpProcedure(modelResource);
                }
            } else if (specificProcedure.equalsIgnoreCase(INVOKE) && !FlatFileRelationalModelFactory.procedureExists(modelResource, INVOKE)) {
                this.addInvokeProcedure(modelResource);
            } else if (specificProcedure.equalsIgnoreCase(INVOKE_HTTP) && !FlatFileRelationalModelFactory.procedureExists(modelResource, INVOKE_HTTP)) {
                this.addInvokeHttpProcedure(modelResource);
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean procedureExists(ModelResource modelResource, String procedureName) {
        if (modelResource == null) return false;
        try {
            Object obj;
            EObject eObj;
            Iterator iterator = modelResource.getAllRootEObjects().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!((eObj = (EObject)(obj = iterator.next())) instanceof Procedure) || !procedureName.equalsIgnoreCase(ModelObjectUtilities.getName((EObject)eObj)));
            return true;
        }
        catch (ModelWorkspaceException err) {
            Util.log((Throwable)err);
        }
        return false;
    }

    private void addGetFilesProcedure(ModelResource mr) throws ModelerCoreException {
        EObject stringType = datatypeManager.findDatatype("string");
        EObject blobType = datatypeManager.findDatatype("blob");
        Procedure proc = factory.createProcedure();
        proc.setName(GET_FILES);
        ProcedureParameter param = factory.createProcedureParameter();
        param.setName("pathAndExt");
        param.setProcedure(proc);
        if (stringType != null) {
            param.setType(stringType);
        }
        ProcedureResult result = factory.createProcedureResult();
        result.setName("Result");
        result.setProcedure(proc);
        Column column_1 = factory.createColumn();
        column_1.setName("file");
        if (blobType != null) {
            column_1.setType(blobType);
        }
        this.addValue(result, column_1, result.getColumns());
        Column column_2 = factory.createColumn();
        column_2.setName("filePath");
        if (stringType != null) {
            column_2.setType(stringType);
            column_2.setLength(4000);
        }
        this.addValue(result, column_2, result.getColumns());
        this.addValue(mr, proc, this.getModelResourceContents(mr));
    }

    private void addGetTextFilesProcedure(ModelResource mr) throws ModelerCoreException {
        EObject stringType = datatypeManager.findDatatype("string");
        EObject clobType = datatypeManager.findDatatype("clob");
        Procedure proc = factory.createProcedure();
        proc.setName(GET_TEXT_FILES);
        ProcedureParameter param = factory.createProcedureParameter();
        param.setProcedure(proc);
        param.setName("pathAndExt");
        param.setProcedure(proc);
        if (stringType != null) {
            param.setType(stringType);
            param.setLength(4000);
        }
        ProcedureResult result = factory.createProcedureResult();
        result.setName("Result");
        result.setProcedure(proc);
        Column column_1 = factory.createColumn();
        column_1.setName("file");
        if (clobType != null) {
            column_1.setType(clobType);
        }
        this.addValue(result, column_1, result.getColumns());
        Column column_2 = factory.createColumn();
        column_2.setName("filePath");
        if (stringType != null) {
            column_2.setType(stringType);
            column_2.setLength(4000);
        }
        this.addValue(result, column_2, result.getColumns());
        this.addValue(mr, proc, this.getModelResourceContents(mr));
    }

    private void addSaveFileProcedure(ModelResource mr) throws ModelerCoreException {
        EObject stringType = datatypeManager.findDatatype("string");
        EObject objectType = datatypeManager.findDatatype("object");
        Procedure proc = factory.createProcedure();
        proc.setName(SAVE_FILE);
        ProcedureParameter param = factory.createProcedureParameter();
        param.setProcedure(proc);
        param.setName("filePath");
        param.setProcedure(proc);
        if (stringType != null) {
            param.setType(stringType);
            param.setLength(4000);
        }
        param = factory.createProcedureParameter();
        param.setProcedure(proc);
        param.setName("value");
        param.setProcedure(proc);
        if (objectType != null) {
            param.setType(objectType);
        }
        this.addValue(mr, proc, this.getModelResourceContents(mr));
    }

    protected void addValue(Object owner, Object value, EList feature) throws ModelerCoreException {
        if (isTransactionable) {
            ModelerCore.getModelEditor().addValue(owner, value, feature);
        } else {
            feature.add(value);
        }
    }

    protected EList getModelResourceContents(ModelResource resource) throws ModelWorkspaceException {
        return resource.getEmfResource().getContents();
    }

    private void addInvokeHttpProcedure(ModelResource mr) throws ModelerCoreException {
        EObject stringType = datatypeManager.findDatatype("string");
        EObject blobType = datatypeManager.findDatatype("blob");
        EObject booleanType = datatypeManager.findDatatype("boolean");
        EObject objectType = datatypeManager.findDatatype("object");
        EObject clobType = datatypeManager.findDatatype("clob");
        Procedure proc = factory.createProcedure();
        proc.setName(INVOKE_HTTP);
        ProcedureParameter param = factory.createProcedureParameter();
        param.setProcedure(proc);
        param.setName("action");
        param.setNullable(NullableType.NULLABLE_LITERAL);
        if (stringType != null) {
            param.setType(stringType);
            param.setLength(4000);
        }
        param = factory.createProcedureParameter();
        param.setProcedure(proc);
        param.setName("request");
        param.setNullable(NullableType.NULLABLE_LITERAL);
        if (objectType != null) {
            param.setType(objectType);
        }
        param = factory.createProcedureParameter();
        param.setProcedure(proc);
        param.setName("endpoint");
        param.setNullable(NullableType.NULLABLE_LITERAL);
        if (objectType != null) {
            param.setType(stringType);
            param.setLength(4000);
        }
        param = factory.createProcedureParameter();
        param.setProcedure(proc);
        param.setName("stream");
        param.setProcedure(proc);
        param.setDirection(DirectionKind.IN_LITERAL);
        if (booleanType != null) {
            param.setType(booleanType);
        }
        param = factory.createProcedureParameter();
        param.setProcedure(proc);
        param.setName("result");
        param.setProcedure(proc);
        param.setDirection(DirectionKind.RETURN_LITERAL);
        param.setType(blobType);
        param = factory.createProcedureParameter();
        param.setProcedure(proc);
        param.setName("contentType");
        param.setDirection(DirectionKind.OUT_LITERAL);
        param.setNullable(NullableType.NULLABLE_LITERAL);
        if (stringType != null) {
            param.setType(stringType);
            param.setLength(4000);
        }
        param = factory.createProcedureParameter();
        param.setProcedure(proc);
        param.setName("headers");
        param.setProcedure(proc);
        param.setDirection(DirectionKind.IN_LITERAL);
        param.setNullable(NullableType.NULLABLE_LITERAL);
        if (clobType != null) {
            param.setType(clobType);
        }
        this.addValue(mr, proc, this.getModelResourceContents(mr));
    }

    private void addInvokeProcedure(ModelResource mr) throws ModelerCoreException {
        EObject stringType = datatypeManager.findDatatype("string");
        EObject xmlLiteralType = datatypeManager.findDatatype("XMLLiteral");
        EObject booleanType = datatypeManager.findDatatype("boolean");
        Procedure proc = factory.createProcedure();
        proc.setName(INVOKE);
        ProcedureParameter param = factory.createProcedureParameter();
        param.setProcedure(proc);
        param.setName("binding");
        param.setNullable(NullableType.NULLABLE_LITERAL);
        if (stringType != null) {
            param.setType(stringType);
        }
        param = factory.createProcedureParameter();
        param.setProcedure(proc);
        param.setName("action");
        param.setNullable(NullableType.NULLABLE_LITERAL);
        if (stringType != null) {
            param.setType(stringType);
            param.setLength(4000);
        }
        param = factory.createProcedureParameter();
        param.setProcedure(proc);
        param.setName("request");
        param.setNullable(NullableType.NULLABLE_LITERAL);
        if (xmlLiteralType != null) {
            param.setType(xmlLiteralType);
        }
        param = factory.createProcedureParameter();
        param.setProcedure(proc);
        param.setName("endpoint");
        param.setNullable(NullableType.NULLABLE_LITERAL);
        if (stringType != null) {
            param.setType(stringType);
            param.setLength(4000);
        }
        param = factory.createProcedureParameter();
        param.setProcedure(proc);
        param.setName("stream");
        param.setDirection(DirectionKind.IN_LITERAL);
        param.setNullable(NullableType.NULLABLE_LITERAL);
        if (booleanType != null) {
            param.setType(booleanType);
        }
        param = factory.createProcedureParameter();
        param.setProcedure(proc);
        param.setName("result");
        param.setProcedure(proc);
        param.setDirection(DirectionKind.RETURN_LITERAL);
        param.setNullable(NullableType.NULLABLE_LITERAL);
        if (xmlLiteralType != null) {
            param.setType(xmlLiteralType);
        }
        this.addValue(mr, proc, this.getModelResourceContents(mr));
    }
}

