/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.IProgressConstants;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.relational.ui.textimport.RelationalTableLocationSelectionValidator;
import org.teiid.designer.tools.textimport.ui.wizards.AbstractObjectProcessor;
import org.teiid.designer.transformation.materialization.MaterializationModelGenerator;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.wizards.RelationalModelSelectorDialog;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.viewsupport.ListContentProvider;
import org.teiid.designer.ui.common.wizard.AbstractWizard;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelIdentifier;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class CreateMaterializedViewWizard
extends AbstractWizard
implements INewWizard,
InternalUiConstants.Widgets,
CoreStringUtil.Constants,
UiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(CreateMaterializedViewWizard.class);
    private static final String TITLE = UiPlugin.getDefault().getString(I18N_PREFIX, "title");
    private static final String PAGE_TITLE = UiPlugin.getDefault().getString(I18N_PREFIX, "pageTitle");
    private static final String UNDEFINED = UiPlugin.getDefault().getString(I18N_PREFIX, "undefined");
    private static final int COLUMN_COUNT = 3;
    private WizardPage wizardPage;
    private Text mvModelText;
    private Text mvLocationText;
    private Button btnBrowse;
    IStructuredSelection initialSelection;
    Object mvTableLocation;
    private MaterializationModelGenerator generator;

    public CreateMaterializedViewWizard() {
        super((AbstractUIPlugin)UiPlugin.getDefault(), TITLE, null);
    }

    public boolean finish() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        CreateMaterializedViewWizard.this.runAsJob();
                    }
                    catch (Exception err) {
                        throw new InvocationTargetException(err);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(false, true, op);
            return true;
        }
        catch (Throwable err) {
            if (err instanceof InvocationTargetException) {
                err = ((InvocationTargetException)err).getTargetException();
            }
            Util.log(err);
            WidgetUtil.showError((String)UiPlugin.getDefault().getString(I18N_PREFIX, "errorCreatingMaterializedViews"));
            return false;
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (this.isAllVirtualTablesSelected((ISelection)selection)) {
            this.initialSelection = new StructuredSelection(selection.toArray());
        }
        this.wizardPage = new WizardPage(CreateMaterializedViewWizard.class.getSimpleName(), PAGE_TITLE, null){

            public void createControl(Composite parent) {
                this.setControl((Control)CreateMaterializedViewWizard.this.createPageControl(parent));
            }
        };
        this.wizardPage.setPageComplete(false);
        this.wizardPage.setMessage(UiPlugin.getDefault().getString(I18N_PREFIX, "initialMessage"));
        this.addPage((IWizardPage)this.wizardPage);
        this.generator = new MaterializationModelGenerator();
        this.generator.setVirtualTables((Collection)this.initialSelection.toList());
        this.validatePage();
    }

    public boolean canFinish() {
        return super.canFinish();
    }

    Composite createEmptyPageControl(Composite parent) {
        return new Composite(parent, 0);
    }

    Composite createPageControl(Composite parent) {
        Composite pg = new Composite(parent, 0);
        pg.setLayout((Layout)new GridLayout(3, false));
        WidgetFactory.createLabel((Composite)pg, (String)UiPlugin.getDefault().getString(I18N_PREFIX, "modelLabel"));
        this.mvModelText = WidgetFactory.createTextField((Composite)pg, (int)768, (int)1, (String)UNDEFINED, (int)8);
        this.btnBrowse = WidgetFactory.createButton((Composite)pg, (String)BROWSE_BUTTON);
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CreateMaterializedViewWizard.this.browseForModelSelected();
            }
        });
        WidgetFactory.createLabel((Composite)pg, (String)UiPlugin.getDefault().getString(I18N_PREFIX, "targetLocationLabel"));
        this.mvLocationText = WidgetFactory.createTextField((Composite)pg, (int)256, (int)2);
        this.mvLocationText.setText(UNDEFINED);
        this.btnBrowse.setFocus();
        if (this.isAllVirtualTablesSelected()) {
            Group group = WidgetFactory.createGroup((Composite)pg, (String)UiPlugin.getDefault().getString(I18N_PREFIX, "virtualTablesGroup"), (int)1808, (int)3, (int)3);
            TableViewer viewer = new TableViewer((Composite)group);
            GridData gdv = new GridData(1808);
            viewer.getControl().setLayoutData((Object)gdv);
            viewer.setContentProvider((IContentProvider)new ListContentProvider());
            viewer.setLabelProvider((IBaseLabelProvider)new ModelExplorerLabelProvider());
            List selectedModels = SelectionUtilities.getSelectedEObjects((ISelection)this.initialSelection);
            viewer.setInput((Object)selectedModels);
        }
        return pg;
    }

    private boolean isAllVirtualTablesSelected(ISelection selection) {
        boolean isValid = true;
        if (SelectionUtilities.isEmptySelection((ISelection)selection) || !SelectionUtilities.isAllEObjects((ISelection)selection)) {
            isValid = false;
        }
        if (isValid) {
            List objs = SelectionUtilities.getSelectedEObjects((ISelection)selection);
            Iterator selections = objs.iterator();
            while (selections.hasNext() && isValid) {
                EObject next = (EObject)selections.next();
                isValid = this.isRelationalVirtualTable(next) && TransformationHelper.isVirtualSqlTable((Object)next);
                if (isValid) {
                    continue;
                }
                break;
            }
        } else {
            isValid = false;
        }
        return isValid;
    }

    private boolean isAllVirtualTablesSelected() {
        return this.isAllVirtualTablesSelected((ISelection)this.initialSelection);
    }

    private boolean isRelationalVirtualTable(EObject eObject) {
        Resource resource;
        if (TransformationHelper.isVirtualSqlTable((Object)eObject) && (resource = eObject.eResource()) != null) {
            ModelResource mr = ModelUtilities.getModelResource((Resource)resource, (boolean)true);
            return ModelIdentifier.isRelationalViewModel((ModelResource)mr);
        }
        return false;
    }

    void browseForModelSelected() {
        Object[] oSelectedObjects;
        Object result = null;
        RelationalModelSelectorDialog mwdDialog = new RelationalModelSelectorDialog(UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell());
        mwdDialog.setValidator((ISelectionStatusValidator)new RelationalTableLocationSelectionValidator());
        mwdDialog.setAllowMultiple(false);
        mwdDialog.open();
        if (mwdDialog.getReturnCode() == 0 && (oSelectedObjects = mwdDialog.getResult()).length > 0) {
            result = oSelectedObjects[0];
        }
        this.generator.setTargetLocation(result);
        this.validatePage();
        this.updateWidgetValues();
    }

    private void updateWidgetValues() {
        this.mvModelText.setText(this.generator.getModelName());
        this.mvLocationText.setText(this.generator.getLocationName());
    }

    private void validatePage() {
        IStatus currentStatus = this.generator.getExecuteStatus();
        if (currentStatus.isOK()) {
            this.wizardPage.setErrorMessage(null);
            this.wizardPage.setMessage(currentStatus.getMessage());
            this.wizardPage.setPageComplete(true);
        } else if (currentStatus.getSeverity() == 2) {
            this.wizardPage.setMessage("WARNING: " + currentStatus.getMessage());
            this.wizardPage.setPageComplete(true);
        } else {
            this.wizardPage.setErrorMessage(currentStatus.getMessage());
            this.wizardPage.setPageComplete(false);
        }
    }

    private boolean runAsJob() {
        final String message = UiPlugin.getDefault().getString(I18N_PREFIX, "progressMonitorTitle");
        Job job = new Job(message){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(message, CreateMaterializedViewWizard.this.generator.getVirtualTables().size());
                    if (!monitor.isCanceled()) {
                        CreateMaterializedViewWizard.this.execute(monitor);
                    }
                    monitor.done();
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    return new Status(0, "org.teiid.designer.ui", 0, AbstractObjectProcessor.FINISHED, null);
                }
                catch (Exception e) {
                    UiConstants.Util.log((Throwable)e);
                    return new Status(4, "org.teiid.designer.ui", 4, UiPlugin.getDefault().getString(I18N_PREFIX, "errorCreatingMaterializedViews"), (Throwable)e);
                }
            }
        };
        job.setSystem(false);
        job.setUser(true);
        job.setProperty(IProgressConstants.KEEP_PROPERTY, (Object)Boolean.TRUE);
        job.schedule();
        return true;
    }

    private boolean execute(IProgressMonitor monitor) {
        boolean succeeded;
        block15: {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Create Materialized View Model", (Object)((Object)this));
            succeeded = false;
            try {
                try {
                    this.generator.execute();
                    succeeded = true;
                }
                catch (Exception ex) {
                    UiConstants.Util.log(4, (Throwable)ex, UiPlugin.getDefault().getString(I18N_PREFIX, "errorCreatingMaterializedViews"));
                    if (requiredStart) {
                        if (succeeded && !monitor.isCanceled()) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (requiredStart) {
                    if (succeeded && !monitor.isCanceled()) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                throw throwable;
            }
            if (requiredStart) {
                if (succeeded && !monitor.isCanceled()) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
        if (succeeded) {
            ModelEditorManager.activate((ModelResource)this.generator.getMaterializedViewModel(), (boolean)true);
        }
        return succeeded;
    }
}

