/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.reconciler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper;
import org.teiid.designer.core.metamodel.aspect.sql.SqlColumnAspect;
import org.teiid.designer.transformation.ui.reconciler.Binding;
import org.teiid.designer.transformation.ui.reconciler.IBindingListViewer;

public class BindingList {
    private final int COUNT = 10;
    private List<Binding> bindings = new ArrayList<Binding>(10);
    private List removedBindings = new ArrayList();
    private Set<IBindingListViewer> changeListeners = new HashSet<IBindingListViewer>();

    public Binding get(int index) {
        if (index >= 0 && index < this.bindings.size()) {
            return this.bindings.get(index);
        }
        return null;
    }

    public List getAll() {
        return this.bindings;
    }

    public List getRemovedList() {
        return this.removedBindings;
    }

    public int size() {
        return this.bindings.size();
    }

    public boolean hasTypeConflict() {
        boolean hasConflict = false;
        for (Binding binding : this.bindings) {
            if (!binding.hasTypeConflict()) continue;
            hasConflict = true;
            break;
        }
        return hasConflict;
    }

    public void add(Binding binding) {
        this.bindings.add(this.bindings.size(), binding);
        Iterator<IBindingListViewer> iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().addBinding(binding);
        }
    }

    public void addAll(List bindings) {
        Iterator iter = bindings.iterator();
        while (iter.hasNext()) {
            this.add((Binding)iter.next());
        }
    }

    public void insert(Binding binding, int index) {
        this.bindings.add(index, binding);
        Iterator<IBindingListViewer> iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().insertBinding(binding, index);
        }
    }

    public void remove(Binding binding) {
        this.bindings.remove(binding);
        if (!this.removedBindings.contains(binding)) {
            this.removedBindings.add(binding);
        }
        Iterator<IBindingListViewer> iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().removeBinding(binding);
        }
    }

    public void removeAll(List bindings) {
        Iterator iter = bindings.iterator();
        while (iter.hasNext()) {
            this.remove((Binding)iter.next());
        }
    }

    public boolean hasRemovedBindingMatch(String attrName) {
        boolean hasMatch = false;
        for (Binding binding : this.removedBindings) {
            SqlColumnAspect columnAspect;
            String currentName;
            Object attr = binding.getAttribute();
            if (attr == null || !(attr instanceof EObject) || !SqlAspectHelper.isColumn((EObject)((EObject)attr)) || (currentName = (columnAspect = (SqlColumnAspect)SqlAspectHelper.getSqlAspect((EObject)((EObject)attr))).getName((EObject)attr)) == null || !currentName.equalsIgnoreCase(attrName)) continue;
            hasMatch = true;
            break;
        }
        return hasMatch;
    }

    public Binding getRemovedBindingMatch(String attrName) {
        int bindingIndex = -1;
        Binding bindingMatch = null;
        int i = 0;
        while (i < this.removedBindings.size()) {
            SqlColumnAspect columnAspect;
            String currentName;
            Binding binding = (Binding)this.removedBindings.get(i);
            Object attr = binding.getAttribute();
            if (attr != null && attr instanceof EObject && SqlAspectHelper.isColumn((EObject)((EObject)attr)) && (currentName = (columnAspect = (SqlColumnAspect)SqlAspectHelper.getSqlAspect((EObject)((EObject)attr))).getName((EObject)attr)) != null && currentName.equalsIgnoreCase(attrName)) {
                bindingIndex = i;
                break;
            }
            ++i;
        }
        if (bindingIndex >= 0) {
            bindingMatch = (Binding)this.removedBindings.remove(bindingIndex);
        }
        return bindingMatch;
    }

    public void bindingChanged(Binding binding) {
        Iterator<IBindingListViewer> iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().updateBinding(binding);
        }
    }

    public void refresh(boolean updateLabels) {
        Iterator<IBindingListViewer> iterator = this.changeListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().refresh(updateLabels);
        }
    }

    public int indexOf(Binding binding) {
        return this.bindings.indexOf(binding);
    }

    public Binding getFirstUnbound() {
        Binding result = null;
        for (Binding binding : this.bindings) {
            if (binding.isBound()) continue;
            result = binding;
            break;
        }
        return result;
    }

    public Binding getFirstBound() {
        Binding result = null;
        for (Binding binding : this.bindings) {
            if (!binding.isBound()) continue;
            result = binding;
            break;
        }
        return result;
    }

    public Binding getFirstTypeConflict() {
        Binding result = null;
        for (Binding binding : this.bindings) {
            if (!binding.hasTypeConflict()) continue;
            result = binding;
            break;
        }
        return result;
    }

    public Binding getNextUnbound(Binding binding) {
        Binding result = null;
        int index = this.indexOf(binding);
        int i = index + 1;
        while (i < this.size()) {
            Binding nextBinding = this.bindings.get(i);
            if (!nextBinding.isBound()) {
                result = nextBinding;
                break;
            }
            ++i;
        }
        if (result == null) {
            return this.getFirstUnbound();
        }
        return result;
    }

    public Binding getNextBound(Binding binding) {
        Binding result = null;
        int index = this.indexOf(binding);
        int i = index + 1;
        while (i < this.size()) {
            Binding nextBinding = this.bindings.get(i);
            if (nextBinding.isBound()) {
                result = nextBinding;
                break;
            }
            ++i;
        }
        if (result == null) {
            return this.getFirstBound();
        }
        return result;
    }

    public Binding getNextTypeConflict(Binding binding) {
        Binding result = null;
        int index = this.indexOf(binding);
        int i = index + 1;
        while (i < this.size()) {
            Binding nextBinding = this.bindings.get(i);
            if (nextBinding.hasTypeConflict()) {
                result = nextBinding;
                break;
            }
            ++i;
        }
        if (result == null) {
            return this.getFirstTypeConflict();
        }
        return result;
    }

    public void moveUp(Binding binding) {
        int currentIndex = this.indexOf(binding);
        if (currentIndex > 0) {
            Binding removedBinding = this.bindings.remove(currentIndex);
            this.bindings.add(--currentIndex, removedBinding);
            this.refresh(true);
        }
    }

    public void moveTop(Binding binding) {
        int currentIndex = this.indexOf(binding);
        if (currentIndex > 0) {
            Binding removedBinding = this.bindings.remove(currentIndex);
            this.bindings.add(0, removedBinding);
            this.refresh(true);
        }
    }

    public void moveBottom(Binding binding) {
        int currentIndex = this.indexOf(binding);
        if (currentIndex > -1 && currentIndex < this.bindings.size() - 1) {
            Binding removedBinding = this.bindings.remove(currentIndex);
            this.bindings.add(removedBinding);
            this.refresh(true);
        }
    }

    public void moveDown(Binding binding) {
        int index = this.indexOf(binding);
        if (index > -1 && index < this.bindings.size() - 1) {
            Binding removedBinding = this.bindings.remove(index);
            this.bindings.add(++index, removedBinding);
            this.refresh(true);
        }
    }

    public void swap(Binding binding1, Binding binding2) {
        int index1 = this.indexOf(binding1);
        int index2 = this.indexOf(binding2);
        if (index1 > -1 && index2 > -1) {
            Binding obj1 = this.bindings.get(index1);
            Binding obj2 = this.bindings.get(index2);
            this.bindings.set(index2, obj1);
            this.bindings.set(index1, obj2);
            this.refresh(true);
        }
    }

    public void removeChangeListener(IBindingListViewer viewer) {
        this.changeListeners.remove(viewer);
    }

    public void addChangeListener(IBindingListViewer viewer) {
        this.changeListeners.add(viewer);
    }
}

