/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.part;

import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.notation.uml.part.UmlClassifierEditPart;
import org.teiid.designer.diagram.ui.part.DiagramEditPart;
import org.teiid.designer.diagram.ui.part.DropEditPartHelper;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.transformation.ui.actions.TransformationSourceManager;
import org.teiid.designer.transformation.ui.part.TransformationDiagramEditPart;
import org.teiid.designer.transformation.ui.part.TransformationEditPart;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;

public class TransformationDropEditPartHelper
extends DropEditPartHelper {
    private Object transformation;

    public TransformationDropEditPartHelper(Object transformation) {
        this.transformation = transformation;
    }

    public void drop(Point dropPoint, List dropList) {
        boolean canAdd = false;
        if (this.transformation != null) {
            canAdd = TransformationSourceManager.canAdd((EObject)this.transformation, dropList, (Object)this);
        }
        if (canAdd) {
            boolean canUndo = false;
            boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)canUndo, (String)"Add Sources", null);
            boolean succeeded = false;
            try {
                TransformationSourceManager.addSources(this.transformation, dropList);
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        } else {
            TransformationSourceManager.warnUserAboutInvalidSources(dropList);
        }
    }

    public boolean allowsDrop(Object target, List dropList) {
        EObject transform;
        return TransformationSourceManager.canAdd((EObject)this.transformation, dropList, (Object)this) && target instanceof DiagramEditPart && (transform = this.getTransformation((DiagramEditPart)target)) != null && this.transformation != null && transform.equals(this.transformation);
    }

    protected EObject getTransformation(DiagramEditPart editPart) {
        if (editPart instanceof TransformationDiagramEditPart) {
            return TransformationSourceManager.getTransformationFromDiagram((Diagram)editPart.getModelObject());
        }
        if (editPart instanceof TransformationEditPart) {
            return editPart.getModelObject();
        }
        if (editPart instanceof UmlClassifierEditPart) {
            if (!ModelObjectUtilities.isVirtual((EObject)editPart.getModelObject())) {
                return null;
            }
            DiagramModelNode parentClassifierNode = DiagramUiUtilities.getClassifierParentNode((DiagramModelNode)((DiagramModelNode)editPart.getModel()));
            if (parentClassifierNode != null && TransformationHelper.isValidSqlTransformationTarget((Object)parentClassifierNode.getModelObject())) {
                return TransformationHelper.getTransformationMappingRoot((EObject)parentClassifierNode.getModelObject());
            }
        }
        return null;
    }
}

