/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.editors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.Table;
import org.teiid.designer.relational.RelationalConstants;
import org.teiid.designer.relational.model.RelationalColumn;
import org.teiid.designer.relational.model.RelationalForeignKey;
import org.teiid.designer.relational.model.RelationalIndex;
import org.teiid.designer.relational.model.RelationalModelFactory;
import org.teiid.designer.relational.model.RelationalPrimaryKey;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.relational.model.RelationalTable;
import org.teiid.designer.relational.model.RelationalUniqueConstraint;
import org.teiid.designer.relational.model.RelationalViewTable;
import org.teiid.designer.relational.ui.UiConstants;
import org.teiid.designer.relational.ui.UiPlugin;
import org.teiid.designer.relational.ui.edit.EditForeignKeyDialog;
import org.teiid.designer.relational.ui.edit.EditIndexDialog;
import org.teiid.designer.relational.ui.edit.RelationalEditorPanel;
import org.teiid.designer.relational.ui.editor.EditRelationalObjectDialogModel;
import org.teiid.designer.relational.ui.util.RelationalUiUtil;
import org.teiid.designer.transformation.ui.Messages;
import org.teiid.designer.transformation.ui.editors.TransformationDialogModel;
import org.teiid.designer.transformation.ui.editors.sqleditor.SqlTextViewer;
import org.teiid.designer.transformation.ui.wizards.sqlbuilder.SQLTemplateDialog;
import org.teiid.designer.transformation.util.SqlStringUtil;
import org.teiid.designer.ui.common.UILabelUtil;
import org.teiid.designer.ui.common.eventsupport.IDialogStatusListener;
import org.teiid.designer.ui.common.graphics.ColorManager;
import org.teiid.designer.ui.common.table.ComboBoxEditingSupport;
import org.teiid.designer.ui.common.table.TableViewerBuilder;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.viewsupport.StatusInfo;
import org.teiid.designer.ui.viewsupport.DatatypeUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.SelectFromEObjectListDialog;

public class ViewTableEditorPanel
extends RelationalEditorPanel
implements RelationalConstants {
    private List<String> MULTIPLICITY_LIST = new ArrayList<String>();
    private TabItem generalPropertiesTab;
    private TabItem sqlTab;
    private TabItem columnsTab;
    private TabItem primaryKeyTab;
    private TabItem uniqueConstraintTab;
    private TabItem foreignKeysTab;
    private TabItem indexesTab;
    private Button materializedCB;
    private Button supportsUpdateCB;
    private Button isSystemTableCB;
    private Button includePrimaryKeyCB;
    private Button includeUniqueConstraintCB;
    private Button globalTempTableCB;
    private Button findTableReferenceButton;
    private Label materializedTableLabel;
    private Text cardinalityText;
    private Text materializedTableText;
    private Text primaryKeyNameText;
    private Text uniqueConstraintNameText;
    private Text primaryKeyNISText;
    private Text uniqueConstraintNISText;
    private SqlTextViewer sqlTextViewer;
    private Document sqlDocument;
    private Button addColumnButton;
    private Button deleteColumnButton;
    private Button upColumnButton;
    private Button downColumnButton;
    private Button changePkColumnsButton;
    private Button changeUcColumnsButton;
    private Button addFKButton;
    private Button editFKButton;
    private Button deleteFKButton;
    private Button addIndexButton;
    private Button deleteIndexButton;
    private Button editIndexButton;
    private TableViewerBuilder columnsViewer;
    private TableViewerBuilder pkColumnsViewer;
    private TableViewerBuilder ucColumnsViewer;
    private TableViewerBuilder fkViewer;
    private TableViewerBuilder indexesViewer;

    public ViewTableEditorPanel(Composite parent, TransformationDialogModel dialogModel, IDialogStatusListener statusListener) {
        super(parent, (EditRelationalObjectDialogModel)dialogModel, statusListener);
        String[] stringArray = RelationalConstants.MULTIPLICITY.AS_ARRAY;
        int n = RelationalConstants.MULTIPLICITY.AS_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            this.MULTIPLICITY_LIST.add(str);
            ++n2;
        }
        this.synchronizeUI();
    }

    protected RelationalViewTable getRelationalReference() {
        return (RelationalViewTable)super.getRelationalReference();
    }

    protected void createPanel(Composite parent) {
        this.createNameGroup(parent);
        TabFolder tabFolder = this.createTabFolder(parent);
        this.createGeneralPropertiesTab(tabFolder);
        this.createSQLTab(tabFolder);
        this.createColumnsTab(tabFolder);
        this.createPrimaryKeyTab(tabFolder);
        this.createUniqueConstraintTab(tabFolder);
        this.createForeignKeysTab(tabFolder);
        this.createIndexesTab(tabFolder);
    }

    private void createGeneralPropertiesTab(TabFolder folderParent) {
        Composite thePanel = this.createPropertiesPanel((Composite)folderParent);
        this.generalPropertiesTab = new TabItem(folderParent, 0);
        this.generalPropertiesTab.setControl((Control)thePanel);
        this.generalPropertiesTab.setText(UILabelUtil.getLabel((int)6));
        this.generalPropertiesTab.setImage(RelationalUiUtil.getRelationalImage((int)3, (int)ModelType.PHYSICAL, (IStatus)Status.OK_STATUS));
    }

    private void createSQLTab(TabFolder folderParent) {
        Composite thePanel = this.createSQLPanel((Composite)folderParent);
        this.sqlTab = new TabItem(folderParent, 0);
        this.sqlTab.setControl((Control)thePanel);
        this.sqlTab.setText(Messages.transformationSqlLabel);
        this.sqlTab.setImage(RelationalUiUtil.getNativeSQLImage((IStatus)Status.OK_STATUS));
    }

    private void createColumnsTab(TabFolder folderParent) {
        Composite thePanel = this.createColumnTableGroup((Composite)folderParent);
        this.columnsTab = new TabItem(folderParent, 0);
        this.columnsTab.setControl((Control)thePanel);
        this.columnsTab.setText(Messages.columnsLabel);
        this.columnsTab.setImage(RelationalUiUtil.getRelationalImage((int)7, (int)ModelType.PHYSICAL, (IStatus)Status.OK_STATUS));
    }

    private void createPrimaryKeyTab(TabFolder folderParent) {
        Composite thePanel = this.createPrimaryKeyPanel((Composite)folderParent);
        this.primaryKeyTab = new TabItem(folderParent, 0);
        this.primaryKeyTab.setControl((Control)thePanel);
        this.primaryKeyTab.setText(Messages.primaryKeyLabel);
        this.primaryKeyTab.setImage(RelationalUiUtil.getRelationalImage((int)8, (int)ModelType.PHYSICAL, (IStatus)Status.OK_STATUS));
    }

    private void createUniqueConstraintTab(TabFolder folderParent) {
        Composite thePanel = this.createUniqueConstraintPanel((Composite)folderParent);
        this.uniqueConstraintTab = new TabItem(folderParent, 0);
        this.uniqueConstraintTab.setControl((Control)thePanel);
        this.uniqueConstraintTab.setText(Messages.uniqueConstraintLabel);
        this.uniqueConstraintTab.setImage(RelationalUiUtil.getRelationalImage((int)10, (int)ModelType.PHYSICAL, (IStatus)Status.OK_STATUS));
    }

    private void createForeignKeysTab(TabFolder folderParent) {
        Composite thePanel = this.createForeignKeysPanel((Composite)folderParent);
        this.foreignKeysTab = new TabItem(folderParent, 0);
        this.foreignKeysTab.setControl((Control)thePanel);
        this.foreignKeysTab.setText(Messages.foreignKeysLabel);
        this.foreignKeysTab.setImage(RelationalUiUtil.getRelationalImage((int)9, (int)ModelType.PHYSICAL, (IStatus)Status.OK_STATUS));
    }

    private void createIndexesTab(TabFolder folderParent) {
        Composite thePanel = this.createIndexesPanel((Composite)folderParent);
        this.indexesTab = new TabItem(folderParent, 0);
        this.indexesTab.setControl((Control)thePanel);
        this.indexesTab.setText(Messages.indexesLabel);
        this.indexesTab.setImage(RelationalUiUtil.getRelationalImage((int)13, (int)ModelType.PHYSICAL, (IStatus)Status.OK_STATUS));
    }

    protected void synchronizeExtendedUI() {
        boolean isMaterialized;
        boolean isGlobalTempTable;
        if (WidgetUtil.widgetValueChanged((Text)this.cardinalityText, (int)this.getRelationalReference().getCardinality())) {
            this.cardinalityText.setText(Integer.toString(this.getRelationalReference().getCardinality()));
        }
        if (WidgetUtil.widgetValueChanged((Button)this.globalTempTableCB, (boolean)(isGlobalTempTable = this.getRelationalReference().isGlobalTempTable()))) {
            this.materializedCB.setSelection(isGlobalTempTable);
        }
        if (WidgetUtil.widgetValueChanged((Button)this.materializedCB, (boolean)(isMaterialized = this.getRelationalReference().isMaterialized()))) {
            this.materializedCB.setSelection(isMaterialized);
        }
        this.materializedTableText.setEnabled(isMaterialized);
        this.findTableReferenceButton.setEnabled(isMaterialized);
        if (WidgetUtil.widgetValueChanged((Button)this.materializedCB, (boolean)this.getRelationalReference().getSupportsUpdate())) {
            this.supportsUpdateCB.setSelection(this.getRelationalReference().getSupportsUpdate());
        }
        if (WidgetUtil.widgetValueChanged((Button)this.isSystemTableCB, (boolean)this.getRelationalReference().isSystem())) {
            this.isSystemTableCB.setSelection(this.getRelationalReference().isSystem());
        }
        this.generalPropertiesTab.setImage(RelationalUiUtil.getRelationalImage((int)3, (int)this.getRelationalReference().getModelType(), (IStatus)Status.OK_STATUS));
        this.columnsViewer.getTable().removeAll();
        IStatus maxStatus = Status.OK_STATUS;
        for (RelationalColumn row : this.getRelationalReference().getColumns()) {
            if (row.getStatus().getSeverity() > maxStatus.getSeverity()) {
                maxStatus = row.getStatus();
            }
            this.columnsViewer.add((Object)row);
        }
        this.columnsTab.setImage(RelationalUiUtil.getRelationalImage((int)7, (int)this.getRelationalReference().getModelType(), (IStatus)maxStatus));
        maxStatus = Status.OK_STATUS;
        this.fkViewer.getTable().removeAll();
        for (RelationalColumn row : this.getRelationalReference().getForeignKeys()) {
            if (row.getStatus().getSeverity() > maxStatus.getSeverity()) {
                maxStatus = row.getStatus();
            }
            this.fkViewer.add((Object)row);
        }
        this.foreignKeysTab.setImage(RelationalUiUtil.getRelationalImage((int)9, (int)this.getRelationalReference().getModelType(), (IStatus)maxStatus));
        if (this.getRelationalReference().getPrimaryKey() == null) {
            if (WidgetUtil.widgetValueChanged((Button)this.includePrimaryKeyCB, (boolean)false)) {
                this.includePrimaryKeyCB.setSelection(false);
            }
            this.primaryKeyNameText.setEnabled(false);
            if (WidgetUtil.widgetValueChanged((Text)this.primaryKeyNameText, (String)"")) {
                this.primaryKeyNameText.setText("");
            }
            this.primaryKeyNISText.setEnabled(false);
            if (WidgetUtil.widgetValueChanged((Text)this.primaryKeyNISText, (String)"")) {
                this.primaryKeyNISText.setText("");
            }
            this.changePkColumnsButton.setEnabled(false);
            this.pkColumnsViewer.getTable().removeAll();
            this.pkColumnsViewer.getTable().setEnabled(false);
            this.primaryKeyTab.setImage(UiPlugin.getDefault().getImage("icons/full/obj16/primary-key.png"));
        } else {
            this.pkColumnsViewer.getTable().setEnabled(true);
            if (WidgetUtil.widgetValueChanged((Button)this.includePrimaryKeyCB, (boolean)true)) {
                this.includePrimaryKeyCB.setSelection(true);
            }
            this.primaryKeyNameText.setEnabled(true);
            if (this.getRelationalReference().getPrimaryKey().getName() != null && WidgetUtil.widgetValueChanged((Text)this.primaryKeyNameText, (String)this.getRelationalReference().getPrimaryKey().getName())) {
                this.primaryKeyNameText.setText(this.getRelationalReference().getPrimaryKey().getName());
            }
            this.primaryKeyNISText.setEnabled(true);
            if (this.getRelationalReference().getPrimaryKey().getNameInSource() != null && WidgetUtil.widgetValueChanged((Text)this.primaryKeyNISText, (String)this.getRelationalReference().getPrimaryKey().getNameInSource())) {
                this.primaryKeyNISText.setText(this.getRelationalReference().getPrimaryKey().getNameInSource());
            }
            this.pkColumnsViewer.getTable().removeAll();
            if (!this.getRelationalReference().getPrimaryKey().getColumns().isEmpty()) {
                for (RelationalColumn column : this.getRelationalReference().getPrimaryKey().getColumns()) {
                    this.pkColumnsViewer.add((Object)column);
                }
            }
            this.changePkColumnsButton.setEnabled(true);
            this.primaryKeyTab.setImage(RelationalUiUtil.getRelationalImage((int)8, (int)this.getRelationalReference().getModelType(), (IStatus)this.getRelationalReference().getPrimaryKey().getStatus()));
        }
        if (this.getRelationalReference().getUniqueContraint() == null) {
            if (WidgetUtil.widgetValueChanged((Button)this.includeUniqueConstraintCB, (boolean)false)) {
                this.includeUniqueConstraintCB.setSelection(false);
            }
            this.uniqueConstraintNameText.setEnabled(false);
            if (WidgetUtil.widgetValueChanged((Text)this.uniqueConstraintNameText, (String)"")) {
                this.uniqueConstraintNameText.setText("");
            }
            this.uniqueConstraintNISText.setEnabled(false);
            if (WidgetUtil.widgetValueChanged((Text)this.uniqueConstraintNISText, (String)"")) {
                this.uniqueConstraintNISText.setText("");
            }
            this.changeUcColumnsButton.setEnabled(false);
            this.ucColumnsViewer.getTable().removeAll();
            this.ucColumnsViewer.getTable().setEnabled(false);
        } else {
            this.ucColumnsViewer.getTable().setEnabled(true);
            if (WidgetUtil.widgetValueChanged((Button)this.includeUniqueConstraintCB, (boolean)true)) {
                this.includeUniqueConstraintCB.setSelection(true);
            }
            this.uniqueConstraintNameText.setEnabled(true);
            if (this.getRelationalReference().getUniqueContraint().getName() != null && WidgetUtil.widgetValueChanged((Text)this.uniqueConstraintNameText, (String)this.getRelationalReference().getUniqueContraint().getName())) {
                this.uniqueConstraintNameText.setText(this.getRelationalReference().getUniqueContraint().getName());
            }
            this.uniqueConstraintNISText.setEnabled(true);
            if (this.getRelationalReference().getUniqueContraint().getNameInSource() != null && WidgetUtil.widgetValueChanged((Text)this.uniqueConstraintNISText, (String)this.getRelationalReference().getUniqueContraint().getNameInSource())) {
                this.uniqueConstraintNISText.setText(this.getRelationalReference().getUniqueContraint().getName());
            }
            this.ucColumnsViewer.getTable().removeAll();
            if (!this.getRelationalReference().getUniqueContraint().getColumns().isEmpty()) {
                for (RelationalColumn column : this.getRelationalReference().getUniqueContraint().getColumns()) {
                    this.ucColumnsViewer.add((Object)column);
                }
            }
            this.changeUcColumnsButton.setEnabled(true);
            this.uniqueConstraintTab.setImage(RelationalUiUtil.getRelationalImage((int)10, (int)this.getRelationalReference().getModelType(), (IStatus)this.getRelationalReference().getUniqueContraint().getStatus()));
        }
        maxStatus = Status.OK_STATUS;
        this.indexesViewer.getTable().removeAll();
        for (RelationalColumn row : this.getRelationalReference().getIndexes()) {
            if (row.getStatus().getSeverity() > maxStatus.getSeverity()) {
                maxStatus = row.getStatus();
            }
            this.indexesViewer.add((Object)row);
        }
        this.indexesTab.setImage(RelationalUiUtil.getRelationalImage((int)13, (int)this.getRelationalReference().getModelType(), (IStatus)maxStatus));
        if (this.getRelationalReference().getModelType() == ModelType.PHYSICAL) {
            this.materializedCB.setVisible(false);
            this.materializedTableLabel.setVisible(false);
            this.materializedTableText.setVisible(false);
            this.findTableReferenceButton.setVisible(false);
            this.globalTempTableCB.setVisible(false);
        }
    }

    private Composite createPropertiesPanel(Composite parent) {
        Composite thePanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)1);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(thePanel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)thePanel);
        Composite cardinalityPanel = new Composite(thePanel, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)cardinalityPanel);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(cardinalityPanel);
        Label label = new Label(cardinalityPanel, 0);
        label.setText(Messages.cardinalityLabel);
        this.cardinalityText = new Text(cardinalityPanel, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.cardinalityText);
        this.cardinalityText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                if (ViewTableEditorPanel.this.isSynchronizing()) {
                    return;
                }
                if (!ViewTableEditorPanel.this.cardinalityText.getText().isEmpty()) {
                    try {
                        int value = Integer.parseInt(ViewTableEditorPanel.this.cardinalityText.getText());
                        ViewTableEditorPanel.this.getRelationalReference().setCardinality(value);
                        ViewTableEditorPanel.this.handleInfoChanged();
                    }
                    catch (NumberFormatException numberFormatException) {
                        MessageDialog.openError((Shell)ViewTableEditorPanel.this.getShell(), (String)Messages.cardinalityErrorTitle, (String)Messages.cardinalityMustBeAnInteger);
                        return;
                    }
                }
            }
        });
        Composite checkButtonPanel = new Composite(thePanel, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)checkButtonPanel);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(checkButtonPanel);
        this.supportsUpdateCB = new Button(checkButtonPanel, 131104);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.supportsUpdateCB);
        this.supportsUpdateCB.setText(Messages.supportsUpdateLabel);
        this.supportsUpdateCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewTableEditorPanel.this.getRelationalReference().setSupportsUpdate(ViewTableEditorPanel.this.supportsUpdateCB.getSelection());
                ViewTableEditorPanel.this.handleInfoChanged();
            }
        });
        this.isSystemTableCB = new Button(checkButtonPanel, 131104);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.isSystemTableCB);
        this.isSystemTableCB.setText(Messages.systemTableLabel);
        this.isSystemTableCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewTableEditorPanel.this.getRelationalReference().setSystem(ViewTableEditorPanel.this.isSystemTableCB.getSelection());
                ViewTableEditorPanel.this.handleInfoChanged();
            }
        });
        this.materializedCB = new Button(checkButtonPanel, 131104);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.materializedCB);
        this.materializedCB.setText(Messages.materializedLabel);
        this.materializedCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewTableEditorPanel.this.getRelationalReference().setMaterialized(ViewTableEditorPanel.this.materializedCB.getSelection());
                if (!ViewTableEditorPanel.this.materializedCB.getSelection()) {
                    ViewTableEditorPanel.this.getRelationalReference().setMaterializedTable(null);
                }
                ViewTableEditorPanel.this.handleInfoChanged();
            }
        });
        this.globalTempTableCB = new Button(checkButtonPanel, 131104);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.globalTempTableCB);
        this.globalTempTableCB.setText(Messages.globalTempTableLabel);
        this.globalTempTableCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewTableEditorPanel.this.getRelationalReference().setGlobalTempTable(ViewTableEditorPanel.this.globalTempTableCB.getSelection());
                ViewTableEditorPanel.this.handleInfoChanged();
            }
        });
        Composite materializedPanel = new Composite(thePanel, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)materializedPanel);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(materializedPanel);
        this.materializedTableLabel = new Label(materializedPanel, 131072);
        this.materializedTableLabel.setText(Messages.tableReferenceLabel);
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)this.materializedTableLabel);
        this.materializedTableText = new Text(materializedPanel, 2052);
        this.materializedTableText.setForeground(Display.getCurrent().getSystemColor(10));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.materializedTableText);
        this.findTableReferenceButton = new Button(materializedPanel, 8);
        this.findTableReferenceButton.setText(UILabelUtil.getLabel((int)0));
        GridDataFactory.fillDefaults().hint(30, -1).applyTo((Control)this.findTableReferenceButton);
        this.findTableReferenceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewTableEditorPanel.this.handleBrowseWorkspaceForTablePressed();
            }
        });
        this.createDescriptionPanel(thePanel);
        return thePanel;
    }

    private Composite createPrimaryKeyPanel(Composite parent) {
        Composite thePanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)2);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).applyTo(thePanel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)thePanel);
        this.includePrimaryKeyCB = new Button(thePanel, 131104);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).span(2, 1).applyTo((Control)this.includePrimaryKeyCB);
        this.includePrimaryKeyCB.setText(UILabelUtil.getLabel((int)9));
        this.includePrimaryKeyCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ViewTableEditorPanel.this.includePrimaryKeyCB.getSelection()) {
                    if (ViewTableEditorPanel.this.getRelationalReference().getPrimaryKey() == null) {
                        RelationalPrimaryKey key = new RelationalPrimaryKey();
                        if (ViewTableEditorPanel.this.primaryKeyNameText.getText() != null) {
                            key.setName(ViewTableEditorPanel.this.primaryKeyNameText.getText());
                        }
                        ViewTableEditorPanel.this.getRelationalReference().setPrimaryKey(key);
                    }
                } else {
                    ViewTableEditorPanel.this.getRelationalReference().setPrimaryKey(null);
                }
                ViewTableEditorPanel.this.handleInfoChanged();
            }
        });
        Label label = new Label(thePanel, 131072);
        label.setText(UILabelUtil.getLabel((int)14));
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.primaryKeyNameText = new Text(thePanel, 2052);
        this.primaryKeyNameText.setForeground(Display.getCurrent().getSystemColor(10));
        GridDataFactory.fillDefaults().applyTo((Control)this.primaryKeyNameText);
        this.primaryKeyNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String value = ViewTableEditorPanel.this.primaryKeyNameText.getText();
                if (value == null) {
                    value = "";
                }
                if (ViewTableEditorPanel.this.getRelationalReference().getPrimaryKey() != null) {
                    RelationalPrimaryKey key = ViewTableEditorPanel.this.getRelationalReference().getPrimaryKey();
                    key.setName(value);
                }
                ViewTableEditorPanel.this.handleInfoChanged();
            }
        });
        label = new Label(thePanel, 131072);
        label.setText(Messages.nameInSourceLabel);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.primaryKeyNISText = new Text(thePanel, 2052);
        this.primaryKeyNISText.setForeground(Display.getCurrent().getSystemColor(10));
        GridDataFactory.fillDefaults().applyTo((Control)this.primaryKeyNISText);
        this.primaryKeyNISText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String value = ViewTableEditorPanel.this.primaryKeyNISText.getText();
                if (value == null) {
                    value = "";
                }
                if (ViewTableEditorPanel.this.getRelationalReference().getPrimaryKey() != null) {
                    RelationalPrimaryKey key = ViewTableEditorPanel.this.getRelationalReference().getPrimaryKey();
                    key.setNameInSource(value);
                }
                ViewTableEditorPanel.this.handleInfoChanged();
            }
        });
        Composite buttonPanel = new Composite(thePanel, 0);
        GridLayoutFactory.fillDefaults().applyTo(buttonPanel);
        GridDataFactory.fillDefaults().align(16384, 1).applyTo((Control)buttonPanel);
        this.changePkColumnsButton = new Button(buttonPanel, 8);
        this.changePkColumnsButton.setText(UILabelUtil.getLabel((int)11));
        GridDataFactory.fillDefaults().applyTo((Control)this.changePkColumnsButton);
        this.changePkColumnsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectColumnsDialog dialog = new SelectColumnsDialog(ViewTableEditorPanel.this.getShell(), (RelationalTable)ViewTableEditorPanel.this.getRelationalReference(), true);
                int result = dialog.open();
                if (result == 0) {
                    Collection<RelationalColumn> selectedColumns = dialog.getSelectedColumns();
                    if (!selectedColumns.isEmpty()) {
                        ViewTableEditorPanel.this.getRelationalReference().getPrimaryKey().setColumns(selectedColumns);
                    } else {
                        ViewTableEditorPanel.this.getRelationalReference().getPrimaryKey().setColumns(Collections.emptyList());
                    }
                }
                ViewTableEditorPanel.this.handleInfoChanged();
            }
        });
        this.pkColumnsViewer = new TableViewerBuilder(thePanel, 2820);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 100).applyTo((Control)this.pkColumnsViewer.getTableComposite());
        TableViewerColumn column = this.pkColumnsViewer.createColumn(16384, 100, 40, false);
        column.getColumn().setText(Messages.columnNameLabel);
        column.setLabelProvider((CellLabelProvider)new ColumnDataLabelProvider(0));
        if (this.getRelationalReference() != null && this.getRelationalReference().getPrimaryKey() != null) {
            for (RelationalColumn row : this.getRelationalReference().getPrimaryKey().getColumns()) {
                this.columnsViewer.add((Object)row);
            }
        }
        return thePanel;
    }

    private Composite createUniqueConstraintPanel(Composite parent) {
        Composite thePanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)2);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).applyTo(thePanel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)thePanel);
        this.includeUniqueConstraintCB = new Button(thePanel, 131104);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).span(2, 1).applyTo((Control)this.includeUniqueConstraintCB);
        this.includeUniqueConstraintCB.setText(UILabelUtil.getLabel((int)9));
        this.includeUniqueConstraintCB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ViewTableEditorPanel.this.includeUniqueConstraintCB.getSelection()) {
                    if (ViewTableEditorPanel.this.getRelationalReference().getUniqueContraint() == null) {
                        RelationalUniqueConstraint key = new RelationalUniqueConstraint();
                        if (ViewTableEditorPanel.this.uniqueConstraintNameText.getText() != null) {
                            key.setName(ViewTableEditorPanel.this.uniqueConstraintNameText.getText());
                        }
                        ViewTableEditorPanel.this.getRelationalReference().setUniqueConstraint(key);
                    }
                } else {
                    ViewTableEditorPanel.this.getRelationalReference().setUniqueConstraint(null);
                }
                ViewTableEditorPanel.this.handleInfoChanged();
            }
        });
        Label label = new Label(thePanel, 131072);
        label.setText(UILabelUtil.getLabel((int)14));
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.uniqueConstraintNameText = new Text(thePanel, 2052);
        this.uniqueConstraintNameText.setForeground(Display.getCurrent().getSystemColor(10));
        GridDataFactory.fillDefaults().applyTo((Control)this.uniqueConstraintNameText);
        this.uniqueConstraintNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String value = ViewTableEditorPanel.this.uniqueConstraintNameText.getText();
                if (value == null) {
                    value = "";
                }
                if (ViewTableEditorPanel.this.getRelationalReference().getUniqueContraint() != null) {
                    RelationalUniqueConstraint key = ViewTableEditorPanel.this.getRelationalReference().getUniqueContraint();
                    key.setName(value);
                }
                ViewTableEditorPanel.this.handleInfoChanged();
            }
        });
        label = new Label(thePanel, 131072);
        label.setText(Messages.nameInSourceLabel);
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.uniqueConstraintNISText = new Text(thePanel, 2052);
        this.uniqueConstraintNISText.setForeground(Display.getCurrent().getSystemColor(10));
        GridDataFactory.fillDefaults().applyTo((Control)this.uniqueConstraintNISText);
        this.uniqueConstraintNISText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String value = ViewTableEditorPanel.this.uniqueConstraintNISText.getText();
                if (value == null) {
                    value = "";
                }
                if (ViewTableEditorPanel.this.getRelationalReference().getUniqueContraint() != null) {
                    RelationalUniqueConstraint key = ViewTableEditorPanel.this.getRelationalReference().getUniqueContraint();
                    key.setNameInSource(value);
                }
                ViewTableEditorPanel.this.handleInfoChanged();
            }
        });
        Composite buttonPanel = new Composite(thePanel, 0);
        GridLayoutFactory.fillDefaults().applyTo(buttonPanel);
        GridDataFactory.fillDefaults().align(16384, 1).applyTo((Control)buttonPanel);
        this.changeUcColumnsButton = new Button(buttonPanel, 8);
        this.changeUcColumnsButton.setText(UILabelUtil.getLabel((int)11));
        GridDataFactory.fillDefaults().applyTo((Control)this.changeUcColumnsButton);
        this.changeUcColumnsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectColumnsDialog dialog = new SelectColumnsDialog(ViewTableEditorPanel.this.getShell(), (RelationalTable)ViewTableEditorPanel.this.getRelationalReference(), false);
                int result = dialog.open();
                if (result == 0) {
                    Collection<RelationalColumn> selectedColumns = dialog.getSelectedColumns();
                    if (!selectedColumns.isEmpty()) {
                        ViewTableEditorPanel.this.getRelationalReference().getUniqueContraint().setColumns(selectedColumns);
                    } else {
                        ViewTableEditorPanel.this.getRelationalReference().getUniqueContraint().setColumns(Collections.emptyList());
                    }
                }
                ViewTableEditorPanel.this.handleInfoChanged();
            }
        });
        this.ucColumnsViewer = new TableViewerBuilder(thePanel, 2820);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 100).applyTo((Control)this.ucColumnsViewer.getTableComposite());
        TableViewerColumn column = this.ucColumnsViewer.createColumn(16384, 100, 40, false);
        column.getColumn().setText(Messages.columnNameLabel);
        column.setLabelProvider((CellLabelProvider)new ColumnDataLabelProvider(0));
        if (this.getRelationalReference() != null && this.getRelationalReference().getUniqueContraint() != null) {
            for (RelationalColumn row : this.getRelationalReference().getUniqueContraint().getColumns()) {
                this.ucColumnsViewer.add((Object)row);
            }
        }
        return thePanel;
    }

    private Composite createForeignKeysPanel(Composite parent) {
        Composite thePanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)2);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(thePanel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)thePanel);
        Composite buttonPanel = new Composite(thePanel, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(buttonPanel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonPanel);
        this.addFKButton = new Button(buttonPanel, 8);
        this.addFKButton.setText(UILabelUtil.getLabel((int)1));
        GridDataFactory.fillDefaults().applyTo((Control)this.addFKButton);
        this.addFKButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalForeignKey newFK = new RelationalForeignKey();
                EditForeignKeyDialog dialog = new EditForeignKeyDialog(ViewTableEditorPanel.this.getShell(), ViewTableEditorPanel.this.getModelFile(), (RelationalTable)ViewTableEditorPanel.this.getRelationalReference(), newFK, false);
                int result = dialog.open();
                if (result == 0) {
                    ViewTableEditorPanel.this.getRelationalReference().addForeignKey(newFK);
                }
                ViewTableEditorPanel.this.handleInfoChanged();
            }
        });
        this.editFKButton = new Button(buttonPanel, 8);
        this.editFKButton.setText(UILabelUtil.getLabel((int)13));
        GridDataFactory.fillDefaults().applyTo((Control)this.editFKButton);
        this.editFKButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalForeignKey fk = null;
                IStructuredSelection selection = (IStructuredSelection)ViewTableEditorPanel.this.fkViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof RelationalForeignKey) {
                        fk = (RelationalForeignKey)obj;
                        break;
                    }
                    ++n2;
                }
                if (fk != null) {
                    EditForeignKeyDialog dialog = new EditForeignKeyDialog(ViewTableEditorPanel.this.getShell(), ViewTableEditorPanel.this.getModelFile(), (RelationalTable)ViewTableEditorPanel.this.getRelationalReference(), fk, true);
                    int result = dialog.open();
                    ViewTableEditorPanel.this.handleInfoChanged();
                }
            }
        });
        this.deleteFKButton = new Button(buttonPanel, 8);
        this.deleteFKButton.setText(UILabelUtil.getLabel((int)2));
        GridDataFactory.fillDefaults().applyTo((Control)this.deleteFKButton);
        this.deleteFKButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalForeignKey fk = null;
                IStructuredSelection selection = (IStructuredSelection)ViewTableEditorPanel.this.fkViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof RelationalForeignKey) {
                        fk = (RelationalForeignKey)obj;
                        break;
                    }
                    ++n2;
                }
                if (fk != null) {
                    ViewTableEditorPanel.this.getRelationalReference().removeForeignKey(fk);
                    ViewTableEditorPanel.this.deleteFKButton.setEnabled(false);
                    ViewTableEditorPanel.this.handleInfoChanged();
                }
            }
        });
        this.fkViewer = new TableViewerBuilder(thePanel, 2820);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 200).applyTo((Control)this.fkViewer.getTableComposite());
        TableViewerColumn column = this.fkViewer.createColumn(16384, 100, 40, false);
        column.getColumn().setText(Messages.fkNameLabel);
        column.setLabelProvider((CellLabelProvider)new FKDataLabelProvider(0));
        if (this.getRelationalReference() != null) {
            for (RelationalForeignKey row : this.getRelationalReference().getForeignKeys()) {
                this.fkViewer.add((Object)row);
            }
        }
        return thePanel;
    }

    private Composite createIndexesPanel(Composite parent) {
        Composite thePanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)2);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(thePanel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)thePanel);
        Composite buttonPanel = new Composite(thePanel, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(buttonPanel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonPanel);
        this.addIndexButton = new Button(buttonPanel, 8);
        this.addIndexButton.setText(UILabelUtil.getLabel((int)1));
        GridDataFactory.fillDefaults().applyTo((Control)this.addIndexButton);
        this.addIndexButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalIndex newIndex = new RelationalIndex();
                EditIndexDialog dialog = new EditIndexDialog(ViewTableEditorPanel.this.getShell(), (RelationalTable)ViewTableEditorPanel.this.getRelationalReference(), newIndex, false);
                int result = dialog.open();
                if (result == 0) {
                    ViewTableEditorPanel.this.getRelationalReference().addIndex(newIndex);
                }
                ViewTableEditorPanel.this.handleInfoChanged();
            }
        });
        this.editIndexButton = new Button(buttonPanel, 8);
        this.editIndexButton.setText(UILabelUtil.getLabel((int)13));
        GridDataFactory.fillDefaults().applyTo((Control)this.editIndexButton);
        this.editIndexButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalIndex index = null;
                IStructuredSelection selection = (IStructuredSelection)ViewTableEditorPanel.this.indexesViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof RelationalIndex) {
                        index = (RelationalIndex)obj;
                        break;
                    }
                    ++n2;
                }
                if (index != null) {
                    EditIndexDialog dialog = new EditIndexDialog(ViewTableEditorPanel.this.getShell(), (RelationalTable)ViewTableEditorPanel.this.getRelationalReference(), index, true);
                    int result = dialog.open();
                    ViewTableEditorPanel.this.handleInfoChanged();
                }
            }
        });
        this.deleteIndexButton = new Button(buttonPanel, 8);
        this.deleteIndexButton.setText(UILabelUtil.getLabel((int)2));
        GridDataFactory.fillDefaults().applyTo((Control)this.deleteIndexButton);
        this.deleteIndexButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalIndex index = null;
                IStructuredSelection selection = (IStructuredSelection)ViewTableEditorPanel.this.fkViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof RelationalIndex) {
                        index = (RelationalIndex)obj;
                        break;
                    }
                    ++n2;
                }
                if (index != null) {
                    ViewTableEditorPanel.this.getRelationalReference().removeIndex(index);
                    ViewTableEditorPanel.this.deleteIndexButton.setEnabled(false);
                    ViewTableEditorPanel.this.handleInfoChanged();
                }
            }
        });
        this.indexesViewer = new TableViewerBuilder(thePanel, 2820);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 200).applyTo((Control)this.indexesViewer.getTableComposite());
        TableViewerColumn column = this.indexesViewer.createColumn(16384, 100, 40, false);
        column.getColumn().setText(Messages.indexLabel);
        column.setLabelProvider((CellLabelProvider)new IndexDataLabelProvider(0));
        if (this.getRelationalReference() != null && this.getRelationalReference().getIndexes() != null) {
            for (RelationalIndex row : this.getRelationalReference().getIndexes()) {
                this.indexesViewer.add((Object)row);
            }
        }
        return thePanel;
    }

    private Composite createColumnTableGroup(Composite parent) {
        Composite thePanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)1);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(thePanel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)thePanel);
        Composite buttonPanel = WidgetFactory.createPanel((Composite)thePanel, (int)0, (int)1, (int)4);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(buttonPanel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonPanel);
        this.addColumnButton = new Button(buttonPanel, 8);
        this.addColumnButton.setText(UILabelUtil.getLabel((int)1));
        GridDataFactory.fillDefaults().applyTo((Control)this.addColumnButton);
        this.addColumnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewTableEditorPanel.this.getRelationalReference().createColumn();
                ViewTableEditorPanel.this.handleInfoChanged();
            }
        });
        this.deleteColumnButton = new Button(buttonPanel, 8);
        this.deleteColumnButton.setText(UILabelUtil.getLabel((int)2));
        GridDataFactory.fillDefaults().applyTo((Control)this.deleteColumnButton);
        this.deleteColumnButton.setEnabled(false);
        this.deleteColumnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalColumn column = null;
                IStructuredSelection selection = (IStructuredSelection)ViewTableEditorPanel.this.columnsViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof RelationalColumn) {
                        column = (RelationalColumn)obj;
                        break;
                    }
                    ++n2;
                }
                if (column != null) {
                    ViewTableEditorPanel.this.getRelationalReference().removeColumn(column);
                    ViewTableEditorPanel.this.deleteColumnButton.setEnabled(false);
                    ViewTableEditorPanel.this.handleInfoChanged();
                }
            }
        });
        this.upColumnButton = new Button(buttonPanel, 8);
        this.upColumnButton.setText(UILabelUtil.getLabel((int)4));
        GridDataFactory.fillDefaults().applyTo((Control)this.upColumnButton);
        this.upColumnButton.setEnabled(false);
        this.upColumnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalColumn info = null;
                IStructuredSelection selection = (IStructuredSelection)ViewTableEditorPanel.this.columnsViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof RelationalColumn) {
                        info = (RelationalColumn)obj;
                        break;
                    }
                    ++n2;
                }
                if (info != null) {
                    int selectedIndex = ViewTableEditorPanel.this.columnsViewer.getTable().getSelectionIndex();
                    ViewTableEditorPanel.this.getRelationalReference().moveColumnUp(info);
                    ViewTableEditorPanel.this.handleInfoChanged();
                    ViewTableEditorPanel.this.columnsViewer.getTable().select(selectedIndex - 1);
                    ViewTableEditorPanel.this.downColumnButton.setEnabled(ViewTableEditorPanel.this.getRelationalReference().canMoveColumnDown(info));
                    ViewTableEditorPanel.this.upColumnButton.setEnabled(ViewTableEditorPanel.this.getRelationalReference().canMoveColumnUp(info));
                }
            }
        });
        this.downColumnButton = new Button(buttonPanel, 8);
        this.downColumnButton.setText(UILabelUtil.getLabel((int)5));
        GridDataFactory.fillDefaults().applyTo((Control)this.downColumnButton);
        this.downColumnButton.setEnabled(false);
        this.downColumnButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelationalColumn info = null;
                IStructuredSelection selection = (IStructuredSelection)ViewTableEditorPanel.this.columnsViewer.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof RelationalColumn) {
                        info = (RelationalColumn)obj;
                        break;
                    }
                    ++n2;
                }
                if (info != null) {
                    int selectedIndex = ViewTableEditorPanel.this.columnsViewer.getTable().getSelectionIndex();
                    ViewTableEditorPanel.this.getRelationalReference().moveColumnDown(info);
                    ViewTableEditorPanel.this.handleInfoChanged();
                    ViewTableEditorPanel.this.columnsViewer.getTable().select(selectedIndex + 1);
                    ViewTableEditorPanel.this.downColumnButton.setEnabled(ViewTableEditorPanel.this.getRelationalReference().canMoveColumnDown(info));
                    ViewTableEditorPanel.this.upColumnButton.setEnabled(ViewTableEditorPanel.this.getRelationalReference().canMoveColumnUp(info));
                }
            }
        });
        this.columnsViewer = new TableViewerBuilder(thePanel, 68356);
        TableViewerColumn column = this.columnsViewer.createColumn(16384, 30, 40, true);
        column.getColumn().setText(Messages.columnNameLabel);
        column.setEditingSupport((EditingSupport)new ColumnNameEditingSupport((ColumnViewer)this.columnsViewer.getTableViewer()));
        column.setLabelProvider((CellLabelProvider)new ColumnDataLabelProvider(0));
        column = this.columnsViewer.createColumn(16384, 30, 40, true);
        column.getColumn().setText(Messages.dataTypeLabel);
        column.setLabelProvider((CellLabelProvider)new ColumnDataLabelProvider(1));
        column.setEditingSupport((EditingSupport)new DatatypeEditingSupport((ColumnViewer)this.columnsViewer.getTableViewer()));
        column = this.columnsViewer.createColumn(16384, 30, 40, true);
        column.getColumn().setText(Messages.lengthLabel);
        column.setLabelProvider((CellLabelProvider)new ColumnDataLabelProvider(2));
        column.setEditingSupport((EditingSupport)new ColumnWidthEditingSupport((ColumnViewer)this.columnsViewer.getTableViewer()));
        if (this.getRelationalReference() != null) {
            for (RelationalColumn row : this.getRelationalReference().getColumns()) {
                this.columnsViewer.add((Object)row);
            }
        }
        this.columnsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.isEmpty()) {
                    ViewTableEditorPanel.this.deleteColumnButton.setEnabled(false);
                    ViewTableEditorPanel.this.upColumnButton.setEnabled(false);
                    ViewTableEditorPanel.this.downColumnButton.setEnabled(false);
                } else {
                    boolean enable = true;
                    Object[] objs = sel.toArray();
                    RelationalColumn columnInfo = null;
                    Object[] objectArray = objs;
                    int n = objs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object obj = objectArray[n2];
                        if (!(obj instanceof RelationalColumn)) {
                            enable = false;
                            break;
                        }
                        columnInfo = (RelationalColumn)obj;
                        ++n2;
                    }
                    if (objs.length == 0) {
                        enable = false;
                    }
                    ViewTableEditorPanel.this.deleteColumnButton.setEnabled(enable);
                    if (enable) {
                        ViewTableEditorPanel.this.upColumnButton.setEnabled(ViewTableEditorPanel.this.getRelationalReference().canMoveColumnUp(columnInfo));
                        ViewTableEditorPanel.this.downColumnButton.setEnabled(ViewTableEditorPanel.this.getRelationalReference().canMoveColumnDown(columnInfo));
                    }
                }
            }
        });
        return thePanel;
    }

    private Composite createSQLPanel(Composite parent) {
        Composite thePanel = WidgetFactory.createPanel((Composite)parent, (int)0, (int)1, (int)1);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(thePanel);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)thePanel);
        Button templateButton = new Button(thePanel, 16384);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)templateButton);
        templateButton.setText(Messages.selectSQLTemplateLabel);
        templateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLTemplateDialog templateDialog = new SQLTemplateDialog(UiUtil.getWorkbenchShellOnlyIfUiThread(), SQLTemplateDialog.TABLE_TEMPLATES);
                if (templateDialog.open() == 0) {
                    String originalSql = ViewTableEditorPanel.this.sqlDocument.get();
                    boolean okToInsertOrReplace = true;
                    if (templateDialog.getInsertOption() == 0 && originalSql != null && originalSql.trim().length() > 0) {
                        okToInsertOrReplace = MessageDialog.openConfirm((Shell)templateDialog.getShell(), (String)Messages.confirmSqlReplaceDialogTitle, (String)Messages.confirmSqlReplaceDialogMessage_2);
                    }
                    if (okToInsertOrReplace) {
                        int caretOffset = ViewTableEditorPanel.this.sqlTextViewer.getTextWidget().getCaretOffset();
                        String newSql = SqlStringUtil.insertSql((String)originalSql, (String)templateDialog.getSQL(), (int)templateDialog.getInsertOption(), (int)caretOffset);
                        ViewTableEditorPanel.this.getRelationalReference().setTransformationSQL(newSql);
                        ViewTableEditorPanel.this.sqlDocument.set(newSql);
                    }
                }
            }
        });
        this.createSqlGroup(thePanel);
        return thePanel;
    }

    private void createSqlGroup(Composite parent) {
        Group textTableOptionsGroup = WidgetFactory.createGroup((Composite)parent, (String)Messages.sqlDefinitionLabel, (int)0, (int)2, (int)1);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)textTableOptionsGroup);
        ColorManager colorManager = new ColorManager();
        int styles = 68162;
        this.sqlTextViewer = new SqlTextViewer((Composite)textTableOptionsGroup, (IVerticalRuler)new VerticalRuler(0), styles, colorManager);
        this.sqlDocument = new Document();
        this.sqlTextViewer.setInput(this.sqlDocument);
        this.sqlTextViewer.getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ViewTableEditorPanel.this.getRelationalReference().setTransformationSQL(ViewTableEditorPanel.this.sqlTextViewer.getTextWidget().getText());
                ViewTableEditorPanel.this.handleInfoChanged();
            }
        });
        this.sqlTextViewer.setEditable(true);
        this.sqlDocument.set("");
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.sqlTextViewer.getControl());
    }

    protected void validate() {
        this.getRelationalReference().validate();
        this.setCanFinish(this.getRelationalReference().nameIsValid());
        IStatus currentStatus = this.getRelationalReference().getStatus();
        if (currentStatus.isOK()) {
            this.setStatus(Status.OK_STATUS);
        } else {
            this.setStatus(currentStatus);
        }
    }

    private void handleBrowseWorkspaceForTablePressed() {
        ModelResource mr = ModelUtilities.getModelResourceForIFile((IFile)this.getModelFile(), (boolean)true);
        List childList = new ArrayList();
        try {
            childList = mr.getEObjects();
        }
        catch (ModelWorkspaceException ex) {
            ex.printStackTrace();
        }
        ArrayList<EObject> tablesOnlyList = new ArrayList<EObject>();
        for (EObject child : childList) {
            if (!(child instanceof Table)) continue;
            tablesOnlyList.add(child);
        }
        SelectFromEObjectListDialog sdDialog = this.createTableSelectionDialog(tablesOnlyList);
        sdDialog.open();
        if (sdDialog.getReturnCode() == 0) {
            Object[] selections = sdDialog.getResult();
            EObject tableObject = (EObject)selections[0];
            RelationalTable relTable = (RelationalTable)RelationalModelFactory.INSTANCE.getRelationalObject(tableObject);
            this.materializedTableText.setText(relTable.getName());
            this.getRelationalReference().setMaterializedTable((RelationalReference)relTable);
            this.columnsViewer.setInput((Object)relTable);
            this.handleInfoChanged();
        }
    }

    private SelectFromEObjectListDialog createTableSelectionDialog(List<EObject> tableList) {
        String title = Messages.tableSelectionTitle;
        String message = Messages.selectExistingTableForIndexInitialMessage;
        SelectFromEObjectListDialog dialog = new SelectFromEObjectListDialog(this.getShell(), tableList, false, title, message, (LabelProvider)ModelUtilities.getModelObjectLabelProvider());
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection == null || selection.length == 0 || selection[0] == null || !(selection[0] instanceof Table)) {
                    return new StatusInfo("org.teiid.designer.relational.ui", 4, Messages.noTableSelectedMessage);
                }
                return new StatusInfo("org.teiid.designer.relational.ui");
            }
        });
        return dialog;
    }

    class ColumnDataLabelProvider
    extends ColumnLabelProvider {
        private final int columnNumber;

        public ColumnDataLabelProvider(int columnNumber) {
            this.columnNumber = columnNumber;
        }

        public String getText(Object element) {
            if (element instanceof RelationalColumn) {
                switch (this.columnNumber) {
                    case 0: {
                        return ((RelationalColumn)element).getName();
                    }
                    case 1: {
                        return ((RelationalColumn)element).getDatatype();
                    }
                    case 2: {
                        return Integer.toString(((RelationalColumn)element).getLength());
                    }
                }
            }
            return "";
        }

        public String getToolTipText(Object element) {
            switch (this.columnNumber) {
                case 0: {
                    return "Tooltip 1";
                }
                case 1: {
                    return "Tooltip 2";
                }
            }
            return "unknown tooltip";
        }

        public Image getImage(Object element) {
            if (this.columnNumber == 0) {
                return UiPlugin.getDefault().getImage("icons/full/obj16/column.png");
            }
            return null;
        }
    }

    class ColumnNameEditingSupport
    extends EditingSupport {
        private TextCellEditor editor;

        public ColumnNameEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            if (element instanceof RelationalColumn) {
                return ((RelationalColumn)element).getName();
            }
            return 0;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof RelationalColumn) {
                String oldValue = ((RelationalColumn)element).getName();
                String newValue = (String)value;
                if (newValue != null && newValue.length() > 0 && !newValue.equalsIgnoreCase(oldValue)) {
                    ((RelationalColumn)element).setName(newValue);
                    ViewTableEditorPanel.this.columnsViewer.getTableViewer().refresh(element);
                    ViewTableEditorPanel.this.handleInfoChanged();
                }
            }
        }
    }

    class ColumnWidthEditingSupport
    extends EditingSupport {
        private TextCellEditor editor;

        public ColumnWidthEditingSupport(ColumnViewer viewer) {
            super(viewer);
            this.editor = new TextCellEditor((Composite)viewer.getControl());
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            if (element instanceof RelationalColumn) {
                return Integer.toString(((RelationalColumn)element).getLength());
            }
            return 0;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof RelationalColumn) {
                int oldValue;
                int newValue = oldValue = ((RelationalColumn)element).getLength();
                try {
                    newValue = Integer.parseInt((String)value);
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
                if (newValue != oldValue) {
                    ((RelationalColumn)element).setLength(newValue);
                    ViewTableEditorPanel.this.columnsViewer.getTableViewer().refresh(element);
                }
            }
        }
    }

    class DatatypeEditingSupport
    extends ComboBoxEditingSupport {
        private String[] datatypes;

        public DatatypeEditingSupport(ColumnViewer viewer) {
            super(viewer);
            Collection unsortedTypes = new ArrayList();
            try {
                unsortedTypes = DatatypeUtilities.getAllDesignTimeTypeNames();
            }
            catch (ModelerCoreException e) {
                UiConstants.Util.log((Throwable)e);
            }
            ArrayList<Object> dTypes = new ArrayList<Object>();
            Object[] sortedStrings = unsortedTypes.toArray(new String[unsortedTypes.size()]);
            Arrays.sort(sortedStrings);
            Object[] objectArray = sortedStrings;
            int n = sortedStrings.length;
            int n2 = 0;
            while (n2 < n) {
                Object dType = objectArray[n2];
                dTypes.add(dType);
                ++n2;
            }
            this.datatypes = dTypes.toArray(new String[dTypes.size()]);
        }

        protected String getElementValue(Object element) {
            return ((RelationalColumn)element).getDatatype();
        }

        protected String[] refreshItems(Object element) {
            return this.datatypes;
        }

        protected void setElementValue(Object element, String newValue) {
            ((RelationalColumn)element).setDatatype(newValue);
        }
    }

    class FKDataLabelProvider
    extends ColumnLabelProvider {
        private final int columnNumber;

        public FKDataLabelProvider(int columnNumber) {
            this.columnNumber = columnNumber;
        }

        public String getText(Object element) {
            if (element instanceof RelationalForeignKey) {
                switch (this.columnNumber) {
                    case 0: {
                        if (!(element instanceof RelationalForeignKey)) break;
                        return ((RelationalForeignKey)element).getName();
                    }
                }
            }
            return "";
        }

        public String getToolTipText(Object element) {
            switch (this.columnNumber) {
                case 0: {
                    return "Tooltip 1";
                }
                case 1: {
                    return "Tooltip 2";
                }
            }
            return "unknown tooltip";
        }

        public Image getImage(Object element) {
            if (this.columnNumber == 0) {
                return UiPlugin.getDefault().getImage("icons/full/obj16/foreign-key.png");
            }
            return null;
        }
    }

    class IndexDataLabelProvider
    extends ColumnLabelProvider {
        private final int columnNumber;

        public IndexDataLabelProvider(int columnNumber) {
            this.columnNumber = columnNumber;
        }

        public String getText(Object element) {
            if (element instanceof RelationalIndex) {
                switch (this.columnNumber) {
                    case 0: {
                        if (!(element instanceof RelationalIndex)) break;
                        RelationalIndex index = (RelationalIndex)element;
                        String value = index.getName();
                        if (!index.getColumns().isEmpty()) {
                            int i = 0;
                            value = String.valueOf(value) + " : ";
                            for (RelationalColumn col : index.getColumns()) {
                                value = String.valueOf(value) + col.getName();
                                if (++i >= index.getColumns().size()) continue;
                                value = String.valueOf(value) + ", ";
                            }
                        }
                        return value;
                    }
                }
            }
            return "";
        }

        public String getToolTipText(Object element) {
            switch (this.columnNumber) {
                case 0: {
                    return "Tooltip 1";
                }
                case 1: {
                    return "Tooltip 2";
                }
            }
            return "unknown tooltip";
        }

        public Image getImage(Object element) {
            if (this.columnNumber == 0) {
                return UiPlugin.getDefault().getImage("icons/full/obj16/column.png");
            }
            return null;
        }
    }

    class SelectColumnsDialog
    extends TitleAreaDialog {
        private final String TITLE;
        private RelationalTable theTable;
        TableViewer columnDataViewer;
        private Set<RelationalColumn> selectedColumns;
        private boolean isPrimaryKeyColumns;

        public SelectColumnsDialog(Shell parent, RelationalTable theTable, boolean isPrimaryKeyColumns) {
            super(parent);
            this.TITLE = Messages.selectColumnsTitle;
            this.selectedColumns = new HashSet<RelationalColumn>();
            this.isPrimaryKeyColumns = false;
            this.theTable = theTable;
            this.isPrimaryKeyColumns = isPrimaryKeyColumns;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(this.TITLE);
        }

        protected void setShellStyle(int newShellStyle) {
            super.setShellStyle(newShellStyle | 0x10 | 0x400);
        }

        protected Control createDialogArea(Composite parent) {
            this.setTitle(Messages.selectColumnsSubTitle);
            Composite composite = (Composite)super.createDialogArea(parent);
            GridLayoutFactory.fillDefaults().applyTo(composite);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
            Group columnsGroup = WidgetFactory.createGroup((Composite)composite, (String)Messages.selectColumnsTitle, (int)0, (int)1, (int)2);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)columnsGroup);
            org.eclipse.swt.widgets.Table table = new org.eclipse.swt.widgets.Table((Composite)columnsGroup, 2850);
            table.setHeaderVisible(false);
            table.setLinesVisible(true);
            table.setLayout((Layout)new TableLayout());
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)table);
            this.columnDataViewer = new TableViewer(table);
            GridDataFactory.fillDefaults().grab(true, true).applyTo(this.columnDataViewer.getControl());
            this.columnDataViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }

                public boolean hasChildren(Object element) {
                    return !SelectColumnsDialog.this.theTable.getColumns().isEmpty();
                }

                public Object getParent(Object element) {
                    return null;
                }

                public Object[] getElements(Object inputElement) {
                    if (inputElement instanceof RelationalTable) {
                        return SelectColumnsDialog.this.theTable.getColumns().toArray(new Object[0]);
                    }
                    return new Object[0];
                }

                public Object[] getChildren(Object parentElement) {
                    return new Object[0];
                }
            });
            this.columnDataViewer.setLabelProvider((IBaseLabelProvider)new ColumnDataLabelProvider(0));
            this.columnDataViewer.setInput((Object)this.theTable);
            if (this.isPrimaryKeyColumns) {
                for (RelationalColumn col : this.theTable.getPrimaryKey().getColumns()) {
                    TableItem[] tableItemArray = this.columnDataViewer.getTable().getItems();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        if (item.getData() == col) {
                            item.setChecked(true);
                        }
                        ++n2;
                    }
                }
            } else {
                for (RelationalColumn col : this.theTable.getUniqueContraint().getColumns()) {
                    TableItem[] tableItemArray = this.columnDataViewer.getTable().getItems();
                    int n = tableItemArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        TableItem item = tableItemArray[n3];
                        if (item.getData() == col) {
                            item.setChecked(true);
                        }
                        ++n3;
                    }
                }
            }
            this.setMessage(Messages.selectColumnsMessage);
            return composite;
        }

        public void create() {
            super.create();
            this.getButton(0).setEnabled(true);
        }

        protected void okPressed() {
            TableItem[] tableItemArray = this.columnDataViewer.getTable().getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item.getChecked()) {
                    this.selectedColumns.add((RelationalColumn)item.getData());
                }
                ++n2;
            }
            super.okPressed();
        }

        public Collection<RelationalColumn> getSelectedColumns() {
            return this.selectedColumns;
        }
    }
}

