/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.builder;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.query.IQueryFactory;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.sql.lang.ICompoundCriteria;
import org.teiid.designer.query.sql.lang.ICriteria;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.lang.INotCriteria;
import org.teiid.designer.query.sql.lang.IPredicateCriteria;
import org.teiid.designer.query.sql.symbol.IConstant;
import org.teiid.designer.query.sql.symbol.IFunction;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.builder.ILanguageObjectInputProvider;
import org.teiid.designer.transformation.ui.builder.util.LanguageObjectContentProvider;
import org.teiid.query.ui.builder.util.BuilderUtils;
import org.teiid.query.ui.builder.util.LanguageObjectLabelProvider;

public class LanguageObjectBuilderTreeViewer
extends TreeViewer
implements ILanguageObjectInputProvider,
UiConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(LanguageObjectBuilderTreeViewer.class);
    LanguageObjectContentProvider contentProvider = new LanguageObjectContentProvider();
    private ILanguageObject langObj;

    public LanguageObjectBuilderTreeViewer(Composite theParent) {
        super(theParent, 0);
        this.setContentProvider((IContentProvider)this.contentProvider);
        this.setLabelProvider((IBaseLabelProvider)new LanguageObjectLabelProvider());
        this.getTree().setLayoutData((Object)new GridData(1808));
    }

    public void addUndefinedAndCriteria() {
        this.addUndefinedCriteria((ICriteria)this.getSelectedObject(), true);
    }

    private void addUndefinedCriteria(ICriteria theCriteria, boolean theAndFlag) {
        CoreArgCheck.isNotNull((Object)theCriteria);
        Object newSelection = StructuredSelection.EMPTY;
        if (theCriteria instanceof ICompoundCriteria) {
            ICompoundCriteria criteria = (ICompoundCriteria)theCriteria;
            criteria.addCriteria(null);
            this.refresh(true);
            newSelection = this.contentProvider.getChildAt(criteria.getCriteriaCount() - 1, criteria);
        } else if (theCriteria instanceof INotCriteria) {
            this.addUndefinedCriteria(((INotCriteria)theCriteria).getCriteria(), theAndFlag);
        } else if (theCriteria instanceof IPredicateCriteria) {
            IQueryService queryService = ModelerCore.getTeiidQueryService();
            IQueryFactory factory = queryService.createQueryFactory();
            List<ICriteria> criteriaList = Arrays.asList(theCriteria, null);
            ICompoundCriteria compoundCriteria = factory.createCompoundCriteria(theAndFlag ? 0 : 1, criteriaList);
            ILanguageObject parent = (ILanguageObject)this.contentProvider.getParent(theCriteria);
            int index = this.contentProvider.getChildIndex(theCriteria);
            if (parent == null) {
                this.setLanguageObject((ILanguageObject)compoundCriteria);
                this.refresh(true);
                newSelection = this.contentProvider.getChildAt(1, this.contentProvider.getRoot());
                this.expandToLevel(newSelection, -1);
            } else if (parent instanceof INotCriteria || parent instanceof ICompoundCriteria) {
                ICompoundCriteria criteria = null;
                criteria = parent instanceof INotCriteria ? (ICompoundCriteria)((INotCriteria)parent).getCriteria() : (ICompoundCriteria)parent;
                List crits = criteria.getCriteria();
                crits.set(index, compoundCriteria);
                this.refresh(true);
                newSelection = this.contentProvider.getChildAt(1, compoundCriteria);
            } else {
                CoreArgCheck.isTrue((boolean)false, (String)Util.getString(String.valueOf(PREFIX) + "unexpectedType", new Object[]{"addUndefinedCriteria", parent.getClass()}));
            }
        }
        final StructuredSelection selection = newSelection;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                LanguageObjectBuilderTreeViewer.this.setSelection((ISelection)new StructuredSelection(selection));
            }
        });
    }

    public void addUndefinedOrCriteria() {
        this.addUndefinedCriteria((ICriteria)this.getSelectedObject(), false);
    }

    private boolean canDelete(Object theLangObj) {
        boolean result = true;
        ILanguageObject parent = (ILanguageObject)this.contentProvider.getParent(theLangObj);
        if (parent == null) {
            result = !this.isUndefined(theLangObj);
        } else if (parent instanceof IFunction) {
            if (theLangObj instanceof IConstant) {
                result = !BuilderUtils.isConversionType((IConstant)((IConstant)theLangObj));
            }
        } else if (parent instanceof INotCriteria) {
            INotCriteria notCrit = (INotCriteria)parent;
            ICriteria criteria = notCrit.getCriteria();
            while (!(criteria instanceof ICompoundCriteria)) {
                criteria = ((INotCriteria)criteria).getCriteria();
                result = this.canDelete(criteria);
            }
        }
        return result;
    }

    public boolean canDeleteSelection() {
        return this.canDelete(this.getSelectedObject());
    }

    private void delete(Object theLangObj) {
        if (this.canDelete(theLangObj)) {
            boolean doSelect = true;
            Object newSelection = StructuredSelection.EMPTY;
            ILanguageObject parent = (ILanguageObject)this.contentProvider.getParent(theLangObj);
            if (parent == null) {
                this.setLanguageObject(null);
                this.refresh(true);
                newSelection = this.contentProvider.getRoot();
                this.expandToLevel(newSelection, -1);
            } else if (parent instanceof IFunction) {
                int index = this.contentProvider.getChildIndex(theLangObj);
                IExpression[] args = ((IFunction)parent).getArgs();
                args[index] = null;
                this.refresh(true);
                newSelection = this.contentProvider.getChildAt(index, parent);
            } else if (parent instanceof ICriteria && this.contentProvider.getChildCount(parent) > 1) {
                ICompoundCriteria compoundCriteria = null;
                if (parent instanceof ICompoundCriteria) {
                    compoundCriteria = (ICompoundCriteria)parent;
                } else {
                    INotCriteria notCrit = (INotCriteria)parent;
                    ICriteria criteria = notCrit.getCriteria();
                    while (!(criteria instanceof ICompoundCriteria)) {
                        criteria = ((INotCriteria)criteria).getCriteria();
                    }
                    compoundCriteria = (ICompoundCriteria)criteria;
                }
                List crits = compoundCriteria.getCriteria();
                int index = this.contentProvider.getChildIndex(theLangObj);
                if (this.contentProvider.getChildCount(parent) == 2) {
                    int siblingIndex;
                    int n = siblingIndex = index == 0 ? 1 : 0;
                    if (this.isUndefined(this.contentProvider.getChildAt(siblingIndex, parent))) {
                        this.delete(parent);
                    } else if (this.isUndefined(theLangObj)) {
                        crits.remove(index);
                    } else {
                        crits.set(index, null);
                        this.refresh(true);
                        newSelection = this.contentProvider.getChildAt(index, parent);
                    }
                } else {
                    crits.remove(index);
                    this.refresh(true);
                    newSelection = parent;
                }
                if (crits.size() == 1) {
                    this.modifyLanguageObject(parent, (ILanguageObject)this.contentProvider.getChildAt(0, parent), false);
                    doSelect = false;
                }
            }
            if (doSelect) {
                final StructuredSelection selection = newSelection;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        LanguageObjectBuilderTreeViewer.this.setSelection((ISelection)new StructuredSelection(selection));
                    }
                });
            }
        }
    }

    public void deleteSelection() {
        this.delete(this.getSelectedObject());
    }

    @Override
    public ILanguageObject getLanguageObject() {
        return this.langObj;
    }

    public Object getSelectedObject() {
        Object result = null;
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        if (selection.size() == 1) {
            result = selection.getFirstElement();
        }
        return result;
    }

    public boolean hasUndefinedChild(Object theLangObj) {
        boolean result = false;
        Object[] kids = this.contentProvider.getChildren(theLangObj);
        if (kids.length > 0) {
            int i = kids.length - 1;
            while (i >= 0) {
                result = this.isUndefined(kids[i]) ? true : this.hasUndefinedChild(kids[i]);
                if (result) break;
                --i;
            }
        }
        return result;
    }

    public boolean isComplete() {
        Object root = this.contentProvider.getRoot();
        boolean result = root == null || this.isUndefined(root) ? false : !this.hasUndefinedChild(root);
        return result;
    }

    public boolean isUndefined(Object theLangObj) {
        return theLangObj == null || theLangObj.equals("<undefined>");
    }

    private void modifyLanguageObject(Object theObject, ILanguageObject theNewValue, boolean retainSelection) {
        CoreArgCheck.isNotNull((Object)theNewValue);
        Object newSelection = StructuredSelection.EMPTY;
        ILanguageObject parent = (ILanguageObject)this.contentProvider.getParent(theObject);
        ILanguageObject newValue = theNewValue;
        if (parent == null) {
            IFunction function;
            this.setLanguageObject(newValue);
            this.refresh(true);
            newSelection = this.contentProvider.getRoot();
            this.expandToLevel(newSelection, -1);
            if (newSelection instanceof IFunction && (function = (IFunction)newSelection).getArgs().length > 0) {
                newSelection = this.contentProvider.getChildAt(0, function);
            }
        } else if (parent instanceof IFunction) {
            int index = this.contentProvider.getChildIndex(theObject);
            IExpression[] args = ((IFunction)parent).getArgs();
            args[index] = (IExpression)newValue;
            this.refresh(true);
            this.expandToLevel(parent, -1);
            newSelection = this.contentProvider.getChildAt(index, parent);
            if (!retainSelection) {
                if (newSelection instanceof IFunction) {
                    if (this.contentProvider.getChildCount(newSelection) > 0) {
                        newSelection = this.contentProvider.getChildAt(0, newSelection);
                    }
                } else {
                    newSelection = args.length - 1 > index ? this.contentProvider.getChildAt(index + 1, parent) : (index > 0 ? this.contentProvider.getChildAt(0, parent) : this.contentProvider.getChildAt(index, parent));
                }
            }
        } else if (parent instanceof ICriteria) {
            ICriteria newCriteria = (ICriteria)newValue;
            int index = this.contentProvider.getChildIndex(theObject);
            if (parent instanceof ICompoundCriteria || parent instanceof INotCriteria) {
                ICompoundCriteria compoundCriteria = null;
                compoundCriteria = parent instanceof ICompoundCriteria ? (ICompoundCriteria)parent : (ICompoundCriteria)((INotCriteria)parent).getCriteria();
                List criteriaCollection = compoundCriteria.getCriteria();
                criteriaCollection.set(index, newCriteria);
                this.refresh(true);
                newSelection = retainSelection ? criteriaCollection.get(index) : (criteriaCollection.size() - 1 > index ? criteriaCollection.get(index + 1) : (index > 0 ? criteriaCollection.get(0) : this.contentProvider.getChildAt(index + 1, parent)));
            } else {
                CoreArgCheck.isTrue((boolean)false, (String)Util.getString(String.valueOf(PREFIX) + "unexpectedType", new Object[]{"modifyLanguageObject", parent.getClass().getName()}));
            }
            this.expandToLevel(parent, -1);
        }
        this.setSelection((ISelection)(newSelection == null ? StructuredSelection.EMPTY : new StructuredSelection(newSelection)));
    }

    public void modifyNotCriteriaStatus() {
        Object selectedObj = this.getSelectedObject();
        CoreArgCheck.isNotNull((Object)selectedObj);
        if (selectedObj instanceof INotCriteria) {
            this.modifySelectedItem((ILanguageObject)((INotCriteria)selectedObj).getCriteria(), true);
        } else if (selectedObj instanceof ICriteria) {
            IQueryService queryService = ModelerCore.getTeiidQueryService();
            IQueryFactory factory = queryService.createQueryFactory();
            this.modifySelectedItem((ILanguageObject)factory.createNotCriteria((ICriteria)selectedObj), true);
        } else if (this.isUndefined(selectedObj)) {
            CoreArgCheck.isTrue((boolean)false, (String)Util.getString(String.valueOf(PREFIX) + "unexpectedType", new Object[]{"modifyNotCriteriaStatus", "<undefined>"}));
        } else {
            CoreArgCheck.isTrue((boolean)false, (String)Util.getString(String.valueOf(PREFIX) + "unexpectedType", new Object[]{"modifyNotCriteriaStatus", selectedObj.getClass()}));
        }
    }

    public void modifySelectedItem(ILanguageObject theLangObj, boolean retainSelection) {
        this.modifyLanguageObject(this.getSelectedObject(), theLangObj, retainSelection);
    }

    public void selectRoot() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                LanguageObjectBuilderTreeViewer.this.setSelection((ISelection)new StructuredSelection(LanguageObjectBuilderTreeViewer.this.contentProvider.getRoot()));
            }
        });
    }

    public void setLanguageObject(ILanguageObject theLangObj) {
        this.langObj = theLangObj;
        this.setInput(this);
    }
}

