/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspect;
import org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.transformation.MappingClassColumn;
import org.teiid.designer.metamodels.transformation.SqlAlias;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.query.sql.lang.ICommand;
import org.teiid.designer.query.sql.lang.ISetQuery;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.actions.AliasEntryDialog;
import org.teiid.designer.transformation.ui.editors.TransformationObjectEditorPage;
import org.teiid.designer.transformation.ui.util.SqlAliasAccumulatorSource;
import org.teiid.designer.transformation.util.SqlMappingRootCache;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.transformation.util.TransformationSqlHelper;
import org.teiid.designer.ui.common.widget.ListMessageDialog;
import org.teiid.designer.ui.common.widget.accumulator.AccumulatorDialog;
import org.teiid.designer.ui.common.widget.accumulator.IAccumulatorSource;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelObjectEditorPage;
import org.teiid.designer.ui.editors.MultiPageModelEditor;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.query.ui.tree.AddGroupSelectionValidator;
import org.teiid.query.ui.tree.QueryTreeSelectionDialog;

public class TransformationSourceManager
implements UiConstants {
    private static final String ALIAS_ENTRY_DIALOG_TITLE = UiConstants.Util.getString("TransformationSourceManager.aliasEntryDialogTitle", new Object[0]);

    public static boolean canAdd(EObject transformationEObject, EObject sourceEObject, Object source) {
        boolean canAdd = false;
        if (!ModelObjectUtilities.isReadOnly((EObject)transformationEObject) && transformationEObject instanceof SqlTransformationMappingRoot && sourceEObject != null && ModelObjectUtilities.shareCommonProject((EObject)transformationEObject, (EObject)sourceEObject) && !TransformationHelper.isMappingClass((Object)sourceEObject) && TransformationHelper.isValidSource((Object)transformationEObject, (Object)sourceEObject) && !TransformationSourceManager.isInvalidStagingTable(sourceEObject, source) && !sourceEObject.equals(TransformationHelper.getTransformationLinkTarget((EObject)transformationEObject))) {
            canAdd = true;
        }
        return canAdd;
    }

    public static boolean isProcedureWithParm(EObject sourceEObject) {
        List lstParms;
        boolean bResult = false;
        if (TransformationHelper.isSqlProcedure((Object)sourceEObject) && (lstParms = TransformationHelper.getInAndInoutParameters((EObject)sourceEObject)) != null && lstParms.size() > 0) {
            bResult = true;
        }
        return bResult;
    }

    public static boolean canAdd(EObject transformationEObject, List sourceEObjects, Object source) {
        boolean canAdd = false;
        if (!ModelObjectUtilities.isReadOnly((EObject)transformationEObject) && transformationEObject instanceof SqlTransformationMappingRoot && sourceEObjects != null && !sourceEObjects.isEmpty()) {
            Iterator iter = sourceEObjects.iterator();
            EObject nextSource = null;
            canAdd = true;
            while (iter.hasNext() && canAdd) {
                nextSource = (EObject)iter.next();
                canAdd = TransformationSourceManager.canAdd(transformationEObject, nextSource, source);
            }
        }
        return canAdd;
    }

    public static boolean canAddUnionSource(EObject transformationEObject, EObject sourceEObject, Object source) {
        boolean canAdd = false;
        if (!ModelObjectUtilities.isReadOnly((EObject)transformationEObject) && transformationEObject instanceof SqlTransformationMappingRoot && sourceEObject != null && ModelObjectUtilities.shareCommonProject((EObject)transformationEObject, (EObject)sourceEObject) && TransformationHelper.isValidSource((Object)transformationEObject, (Object)sourceEObject) && !TransformationSourceManager.isInvalidStagingTable(sourceEObject, source) && !TransformationHelper.isMappingClass((Object)sourceEObject)) {
            boolean sourceIsTarget = sourceEObject.equals(TransformationHelper.getTransformationLinkTarget((EObject)transformationEObject));
            boolean isInitialOrEmptySql = TransformationHelper.isEmptySelect((Object)transformationEObject);
            if (!sourceIsTarget && !isInitialOrEmptySql) {
                canAdd = true;
            }
        }
        return canAdd;
    }

    public static boolean canAddUnionSource(EObject transformationEObject, List sourceEObjects, Object source) {
        boolean canAdd = false;
        if (!ModelObjectUtilities.isReadOnly((EObject)transformationEObject) && transformationEObject instanceof SqlTransformationMappingRoot && sourceEObjects != null && !sourceEObjects.isEmpty()) {
            Iterator iter = sourceEObjects.iterator();
            EObject linkTarget = TransformationHelper.getTransformationLinkTarget((EObject)transformationEObject);
            boolean sourceIsTarget = false;
            boolean invalidST = false;
            boolean invalidSource = false;
            while (iter.hasNext() && !sourceIsTarget && !invalidST && !invalidSource) {
                EObject sourceEObj = (EObject)iter.next();
                invalidST = TransformationSourceManager.isInvalidStagingTable(sourceEObj, source) || !ModelObjectUtilities.shareCommonProject((EObject)transformationEObject, (EObject)sourceEObj) || TransformationHelper.isMappingClass((Object)sourceEObj) || !TransformationHelper.isValidSource((Object)transformationEObject, (Object)sourceEObj);
                sourceIsTarget = sourceEObj.equals(linkTarget);
                if (!(sourceEObj instanceof MappingClassColumn)) continue;
                invalidSource = true;
            }
            if (!(sourceIsTarget || invalidST || invalidSource)) {
                canAdd = true;
            }
        }
        return canAdd;
    }

    public static boolean canRemove(EObject transformationEObject, EObject sourceEObject) {
        boolean canRemove = false;
        if (!ModelObjectUtilities.isReadOnly((EObject)transformationEObject) && transformationEObject instanceof SqlTransformationMappingRoot && sourceEObject != null && TransformationHelper.isValidSource((Object)transformationEObject, (Object)sourceEObject)) {
            SqlTransformationMappingRoot mappingRoot = (SqlTransformationMappingRoot)transformationEObject;
            EList inputEObjects = mappingRoot.getInputs();
            if (sourceEObject instanceof SqlAlias) {
                EObject aliasedEObj = ((SqlAlias)sourceEObject).getAliasedObject();
                if (inputEObjects.contains(aliasedEObj)) {
                    canRemove = true;
                }
            } else if (inputEObjects.contains(sourceEObject)) {
                canRemove = true;
            }
        }
        return canRemove;
    }

    public static boolean canRemove(EObject transformationEObject, List sourceEObjects) {
        boolean canRemove = false;
        if (!ModelObjectUtilities.isReadOnly((EObject)transformationEObject) && transformationEObject instanceof SqlTransformationMappingRoot && sourceEObjects != null && !sourceEObjects.isEmpty()) {
            SqlTransformationMappingRoot mappingRoot = (SqlTransformationMappingRoot)transformationEObject;
            EList inputEObjects = mappingRoot.getInputs();
            Iterator iter = sourceEObjects.iterator();
            EObject sourceEObject = null;
            while (iter.hasNext()) {
                sourceEObject = (EObject)iter.next();
                if (sourceEObject instanceof SqlAlias) {
                    EObject aliasedEObj = ((SqlAlias)sourceEObject).getAliasedObject();
                    if (!inputEObjects.contains(aliasedEObj)) continue;
                    canRemove = true;
                    break;
                }
                if (!inputEObjects.contains(sourceEObject)) continue;
                canRemove = true;
                break;
            }
        }
        return canRemove;
    }

    public static boolean canClear(EObject transformationEObject) {
        SqlTransformationMappingRoot stmr;
        boolean canClear = false;
        if (transformationEObject != null && transformationEObject.eContainer() != null && transformationEObject.eResource() != null && !ModelObjectUtilities.isReadOnly((EObject)transformationEObject) && transformationEObject instanceof SqlTransformationMappingRoot && (stmr = (SqlTransformationMappingRoot)transformationEObject).getTarget() != null) {
            canClear = true;
        }
        return canClear;
    }

    public static void addSource(Object mappingRoot, EObject sourceEObject) {
        SqlTransformationMappingRoot transMappingRoot = null;
        if (TransformationHelper.isSqlTransformationMappingRoot((Object)mappingRoot)) {
            transMappingRoot = (SqlTransformationMappingRoot)mappingRoot;
        }
        if (transMappingRoot != null && sourceEObject != null) {
            if (TransformationHelper.isUnionCommand((Object)transMappingRoot)) {
                ISetQuery unionQuery = (ISetQuery)SqlMappingRootCache.getSelectCommand((Object)transMappingRoot);
                Shell shell = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
                QueryTreeSelectionDialog addToUnionDialog = new QueryTreeSelectionDialog(shell, (ICommand)unionQuery);
                addToUnionDialog.setValidator((ISelectionStatusValidator)new AddGroupSelectionValidator());
                addToUnionDialog.setTitle(AddGroupSelectionValidator.DIALOG_TITLE);
                addToUnionDialog.setMessage(AddGroupSelectionValidator.DIALOG_MESSAGE);
                int selectedUnionSegment = TransformationSourceManager.getCurrentSqlEditorUnionSegment();
                if (selectedUnionSegment != -1) {
                    addToUnionDialog.setInitialUnionSelection(selectedUnionSegment);
                } else {
                    addToUnionDialog.setInitialUnionSelection(0);
                }
                addToUnionDialog.open();
                if (addToUnionDialog.getReturnCode() == 0) {
                    if (addToUnionDialog.unionQueryFromClauseSelected()) {
                        int segmentIndex = addToUnionDialog.getUnionQuerySegmentIndexForFromClause();
                        if (segmentIndex != -1) {
                            TransformationSourceManager.addSourceToUnionSegment(mappingRoot, sourceEObject, segmentIndex);
                        }
                    } else {
                        boolean unionAll = addToUnionDialog.isUnionAllSelected();
                        TransformationSourceManager.addUnionSource(transMappingRoot, sourceEObject, unionAll);
                    }
                }
            } else {
                boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Add Source", null);
                boolean succeeded = false;
                try {
                    String aliasName = null;
                    aliasName = sourceEObject instanceof SqlAlias ? ((SqlAlias)sourceEObject).getAlias() : TransformationSourceManager.getSqlEObjectName(sourceEObject);
                    if (!TransformationHelper.containsSqlAliasName((Object)transMappingRoot, (String)aliasName, (Object)sourceEObject)) {
                        if (sourceEObject instanceof SqlAlias) {
                            TransformationHelper.addSqlAlias((Object)transMappingRoot, (SqlAlias)((SqlAlias)sourceEObject), (boolean)true, null);
                        } else {
                            TransformationHelper.addSqlAlias((Object)transMappingRoot, (EObject)sourceEObject, (String)TransformationSourceManager.getSqlEObjectName(sourceEObject), (boolean)true, null);
                        }
                    } else {
                        String sourceTableName = ModelerCore.getModelEditor().getName(sourceEObject);
                        Shell shell = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
                        AliasEntryDialog reconcilerDialog = new AliasEntryDialog(shell, ALIAS_ENTRY_DIALOG_TITLE, sourceTableName, transMappingRoot, sourceEObject);
                        reconcilerDialog.open();
                        String newAliasName = reconcilerDialog.getAliasName();
                        if (newAliasName != null) {
                            EObject eObj = null;
                            eObj = sourceEObject instanceof SqlAlias ? ((SqlAlias)sourceEObject).getAliasedObject() : sourceEObject;
                            TransformationHelper.addSqlAlias((Object)transMappingRoot, (EObject)eObj, (String)newAliasName, (boolean)true, null);
                        }
                    }
                    succeeded = true;
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        }
    }

    public static void addSources(Object mappingRoot, List sourceEObjects) {
        SqlTransformationMappingRoot transMappingRoot = null;
        if (TransformationHelper.isSqlTransformationMappingRoot((Object)mappingRoot)) {
            transMappingRoot = (SqlTransformationMappingRoot)mappingRoot;
        }
        if (transMappingRoot != null && sourceEObjects != null && !sourceEObjects.isEmpty()) {
            if (TransformationHelper.isUnionCommand((Object)transMappingRoot)) {
                ISetQuery unionQuery = (ISetQuery)SqlMappingRootCache.getSelectCommand((Object)transMappingRoot);
                Shell shell = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
                QueryTreeSelectionDialog addToUnionDialog = new QueryTreeSelectionDialog(shell, (ICommand)unionQuery);
                addToUnionDialog.setValidator((ISelectionStatusValidator)new AddGroupSelectionValidator());
                addToUnionDialog.setTitle(AddGroupSelectionValidator.DIALOG_TITLE);
                addToUnionDialog.setMessage(AddGroupSelectionValidator.DIALOG_MESSAGE);
                int selectedUnionSegment = TransformationSourceManager.getCurrentSqlEditorUnionSegment();
                if (selectedUnionSegment != -1) {
                    addToUnionDialog.setInitialUnionSelection(selectedUnionSegment);
                } else {
                    addToUnionDialog.setInitialUnionSelection(0);
                }
                addToUnionDialog.open();
                if (addToUnionDialog.getReturnCode() == 0) {
                    if (addToUnionDialog.unionQueryFromClauseSelected()) {
                        int segmentIndex = addToUnionDialog.getUnionQuerySegmentIndexForFromClause();
                        if (segmentIndex != -1) {
                            TransformationSourceManager.addSourcesToUnionSegment(mappingRoot, sourceEObjects, segmentIndex);
                        }
                    } else {
                        boolean unionAll = addToUnionDialog.isUnionAllSelected();
                        TransformationSourceManager.addUnionSources(transMappingRoot, sourceEObjects, unionAll);
                    }
                }
            } else {
                boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Add Sources", null);
                boolean succeeded = false;
                try {
                    Iterator iter = sourceEObjects.iterator();
                    while (iter.hasNext()) {
                        TransformationSourceManager.addSource(mappingRoot, (EObject)iter.next());
                    }
                    succeeded = true;
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        }
    }

    public static void addUnionSource(Object mappingRoot, EObject sourceEObject, boolean useAll) {
        SqlTransformationMappingRoot transMappingRoot = null;
        if (TransformationHelper.isSqlTransformationMappingRoot((Object)mappingRoot)) {
            transMappingRoot = (SqlTransformationMappingRoot)mappingRoot;
        }
        if (transMappingRoot != null && sourceEObject != null) {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Add Union Source", null);
            boolean succeeded = false;
            try {
                ArrayList<EObject> grpList = new ArrayList<EObject>(1);
                grpList.add(sourceEObject);
                Object txnSource = ModelerCore.getCurrentUoW().getSource();
                TransformationHelper.addSqlAlias((Object)transMappingRoot, (EObject)sourceEObject, (String)TransformationSourceManager.getSqlEObjectName(sourceEObject), (boolean)true, null);
                TransformationSqlHelper.updateUnionSelectOnGroupsAdded((EObject)transMappingRoot, grpList, (boolean)useAll, (Object)txnSource);
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    public static void addUnionSources(Object mappingRoot, List sourceEObjects, boolean useAll) {
        SqlTransformationMappingRoot transMappingRoot = null;
        if (TransformationHelper.isSqlTransformationMappingRoot((Object)mappingRoot)) {
            transMappingRoot = (SqlTransformationMappingRoot)mappingRoot;
        }
        if (transMappingRoot != null && sourceEObjects != null && !sourceEObjects.isEmpty()) {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Add Union Sources", null);
            boolean succeeded = false;
            try {
                Object txnSource = ModelerCore.getCurrentUoW().getSource();
                for (EObject sourceEObject : sourceEObjects) {
                    TransformationHelper.addSqlAlias((Object)transMappingRoot, (EObject)sourceEObject, (String)TransformationSourceManager.getSqlEObjectName(sourceEObject), (boolean)true, null);
                }
                TransformationSqlHelper.updateUnionSelectOnGroupsAdded((EObject)transMappingRoot, (List)sourceEObjects, (boolean)useAll, (Object)txnSource);
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    public static void addSourceToUnionSegment(Object mappingRoot, EObject sourceEObject, int nSegmentIndex) {
        SqlTransformationMappingRoot transMappingRoot = null;
        if (TransformationHelper.isSqlTransformationMappingRoot((Object)mappingRoot)) {
            transMappingRoot = (SqlTransformationMappingRoot)mappingRoot;
        }
        if (transMappingRoot != null && sourceEObject != null) {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Add Union Source", null);
            boolean succeeded = false;
            try {
                ArrayList<EObject> grpList = new ArrayList<EObject>(1);
                grpList.add(sourceEObject);
                Object txnSource = ModelerCore.getCurrentUoW().getSource();
                TransformationSqlHelper.updateUnionSelectAddGroupsToSegment((EObject)transMappingRoot, grpList, (int)nSegmentIndex, (Object)txnSource);
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    public static void addSourcesToUnionSegment(Object mappingRoot, List sourceEObjects, int nSegmentIndex) {
        SqlTransformationMappingRoot transMappingRoot = null;
        if (TransformationHelper.isSqlTransformationMappingRoot((Object)mappingRoot)) {
            transMappingRoot = (SqlTransformationMappingRoot)mappingRoot;
        }
        if (transMappingRoot != null && sourceEObjects != null && !sourceEObjects.isEmpty()) {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Add Union Sources", null);
            boolean succeeded = false;
            try {
                Object txnSource = ModelerCore.getCurrentUoW().getSource();
                TransformationSqlHelper.updateUnionSelectAddGroupsToSegment((EObject)transMappingRoot, (List)sourceEObjects, (int)nSegmentIndex, (Object)txnSource);
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    public static void removeSource(EObject transformationEObject, EObject sourceEObject) {
        if (transformationEObject instanceof SqlTransformationMappingRoot && sourceEObject != null) {
            List sqlAliases = TransformationSourceManager.getSqlAliasesToRemove(transformationEObject, sourceEObject);
            TransformationHelper.removeSourceAliases((Object)transformationEObject, (EObject)sourceEObject, (List)sqlAliases, (boolean)false, null);
        }
    }

    public static void removeSources(EObject transformationEObject, List sourceEObjects) {
        if (transformationEObject instanceof SqlTransformationMappingRoot && sourceEObjects != null && !sourceEObjects.isEmpty()) {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Remove Sources", null);
            boolean succeeded = false;
            try {
                Iterator iter = sourceEObjects.iterator();
                EObject sourceEObject = null;
                while (iter.hasNext()) {
                    sourceEObject = (EObject)iter.next();
                    if (sourceEObject instanceof SqlAlias) {
                        TransformationSourceManager.removeSource(transformationEObject, ((SqlAlias)sourceEObject).getAliasedObject());
                        continue;
                    }
                    TransformationSourceManager.removeSource(transformationEObject, sourceEObject);
                }
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    public static void clear(EObject transformationEObject, boolean removeAttributes) {
        if (transformationEObject instanceof SqlTransformationMappingRoot) {
            boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Clear Transformation", null);
            boolean succeeded = false;
            try {
                TransformationHelper.clearTransformation((Object)transformationEObject, (boolean)true, null, (boolean)removeAttributes);
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
    }

    public static Object getTransformationForObject(Object object) {
        IWorkbenchPage page;
        IEditorPart result = null;
        IFile file = null;
        ModelResource mdlRsrc = null;
        if (object instanceof EObject && (mdlRsrc = ModelUtilities.getModelResourceForModelObject((EObject)((EObject)object))) != null) {
            file = (IFile)mdlRsrc.getResource();
        }
        if ((page = DiagramUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null) {
            IEditorReference[] editors = page.getEditorReferences();
            int i = 0;
            while (i < editors.length) {
                IEditorInput input;
                IEditorPart editor = editors[i].getEditor(false);
                if (editor != null && (input = editor.getEditorInput()) instanceof IFileEditorInput && file.equals((Object)((IFileEditorInput)input).getFile())) {
                    if (!(editor instanceof ModelEditor)) break;
                    result = editor;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public static EObject getTransformationFromDiagram(Diagram diagram) {
        EObject targetEObject;
        EObject transformationEObject = null;
        ModelResource mdlRsrc = ModelUtilities.getModelResourceForModelObject((EObject)diagram);
        if (mdlRsrc != null && TransformationHelper.isValidSqlTransformationTarget((Object)(targetEObject = diagram.getTarget()))) {
            transformationEObject = TransformationHelper.getTransformationMappingRoot((EObject)targetEObject);
        }
        return transformationEObject;
    }

    public static List getSourceEObjects(EObject transformationEObject) {
        SqlTransformationMappingRoot mappingRoot;
        EList inputEObjects;
        if (transformationEObject instanceof SqlTransformationMappingRoot && (inputEObjects = (mappingRoot = (SqlTransformationMappingRoot)transformationEObject).getInputs()) != null) {
            return inputEObjects;
        }
        return Collections.EMPTY_LIST;
    }

    public static String getSqlEObjectName(EObject eObject) {
        String returnString = "NULL";
        SqlAspect aspect = SqlAspectHelper.getSqlAspect((EObject)eObject);
        if (aspect != null) {
            returnString = aspect.getName(eObject);
        }
        return returnString;
    }

    public static List getSqlAliasesToRemove(EObject transformationEObject, EObject sourceEObject) {
        ArrayList sqlAliases = new ArrayList();
        if (sourceEObject instanceof SqlAlias) {
            sqlAliases.addAll(TransformationHelper.getSqlAliasesForSource((Object)transformationEObject, (EObject)((SqlAlias)sourceEObject).getAliasedObject()));
        } else {
            sqlAliases.addAll(TransformationHelper.getSqlAliasesForSource((Object)transformationEObject, (EObject)sourceEObject));
        }
        if (!sqlAliases.isEmpty()) {
            if (sqlAliases.size() == 1) {
                return sqlAliases;
            }
            return TransformationSourceManager.getUserSelectedSqlAliases(sqlAliases);
        }
        return Collections.EMPTY_LIST;
    }

    private static List getUserSelectedSqlAliases(List sqlAliases) {
        ArrayList initialSelectionList = new ArrayList(sqlAliases);
        ArrayList resultList = Collections.EMPTY_LIST;
        SqlAliasAccumulatorSource accumulatorSource = new SqlAliasAccumulatorSource(TransformationSourceManager.getCurrentDiagramLabelProvider(), new ArrayList());
        String keepLabel = "Keep SQL Alias List";
        String removeLabel = "Remove SQL Alias List";
        AccumulatorDialog accumulatorDialog = new AccumulatorDialog(UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell(), (IAccumulatorSource)accumulatorSource, "Remove Selected Aliased Sources from SQL", initialSelectionList, TransformationSourceManager.getCurrentDiagramLabelProvider(), keepLabel, removeLabel);
        accumulatorDialog.open();
        if (!accumulatorDialog.wasCancelled()) {
            resultList = new ArrayList(accumulatorDialog.getSelectedItems());
        }
        return resultList;
    }

    private static ILabelProvider getCurrentDiagramLabelProvider() {
        return DiagramUiPlugin.getDiagramNotationManager().getLabelProvider();
    }

    private static int getCurrentSqlEditorUnionSegment() {
        ModelObjectEditorPage moep;
        int selectedUnionSegment = -1;
        IEditorPart editor = UiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor instanceof MultiPageModelEditor && (moep = ((MultiPageModelEditor)editor).getActiveObjectEditor()) != null && moep instanceof TransformationObjectEditorPage) {
            TransformationObjectEditorPage transOEP = (TransformationObjectEditorPage)moep;
            selectedUnionSegment = transOEP.getCurrentSqlEditor().getCurrentUnionCommandSegmentIndex();
        }
        return selectedUnionSegment;
    }

    private static boolean isInvalidStagingTable(EObject eObject, Object source) {
        return eObject != null && TransformationHelper.isStagingTable((Object)eObject) && !(source instanceof ModelEditor);
    }

    public static void warnUserAboutInvalidSources(List invalidSourceList) {
        String title = UiConstants.Util.getString("TransformationSourceManager.invalidSourceListTitle", new Object[0]);
        String msg = UiConstants.Util.getString("TransformationSourceManager.invalidSourceListMessage", new Object[0]);
        ArrayList<String> copyOfList = new ArrayList<String>(invalidSourceList.size());
        for (Object nextObj : invalidSourceList) {
            String path = ModelObjectUtilities.getTrimmedFullPath((EObject)((EObject)nextObj));
            String name = ModelerCore.getModelEditor().getName((EObject)nextObj);
            String row = String.valueOf(path) + "/" + name;
            copyOfList.add(row);
        }
        ListMessageDialog.openWarning((Shell)UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell(), (String)title, null, (String)msg, copyOfList, null);
    }
}

