/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.teiid.designer.diagram.ui.actions.DiagramGlobalActionsMap;
import org.teiid.designer.diagram.ui.actions.RefreshAction;
import org.teiid.designer.diagram.ui.actions.SaveDiagramAction;
import org.teiid.designer.diagram.ui.editor.DiagramActionAdapter;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.diagram.ui.editor.DiagramToolBarManager;
import org.teiid.designer.diagram.ui.pakkage.actions.RenameAction;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.transformation.TransformationMappingRoot;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.actions.AddJoinExpressionAction;
import org.teiid.designer.transformation.ui.actions.AddToSqlSelectAction;
import org.teiid.designer.transformation.ui.actions.AddTransformationSourceAction;
import org.teiid.designer.transformation.ui.actions.AddUnionSourceAction;
import org.teiid.designer.transformation.ui.actions.ClearTransformationAction;
import org.teiid.designer.transformation.ui.actions.CloneAction;
import org.teiid.designer.transformation.ui.actions.CopyAction;
import org.teiid.designer.transformation.ui.actions.CutAction;
import org.teiid.designer.transformation.ui.actions.DeleteAction;
import org.teiid.designer.transformation.ui.actions.ITransformationDiagramActionConstants;
import org.teiid.designer.transformation.ui.actions.LockAction;
import org.teiid.designer.transformation.ui.actions.PasteAction;
import org.teiid.designer.transformation.ui.actions.ReconcileTransformationAction;
import org.teiid.designer.transformation.ui.actions.RemoveTransformationSourceAction;
import org.teiid.designer.transformation.ui.actions.ShowDependencyTargetDiagramAction;
import org.teiid.designer.transformation.ui.actions.ShowParentDiagramAction;
import org.teiid.designer.transformation.ui.actions.TransformationAction;
import org.teiid.designer.transformation.ui.actions.TransformationSelectionHelper;
import org.teiid.designer.transformation.ui.actions.TransformationSourceManager;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.actions.CopyFullNameAction;
import org.teiid.designer.ui.actions.CopyNameAction;
import org.teiid.designer.ui.actions.EditAction;
import org.teiid.designer.ui.actions.IModelObjectActionContributor;
import org.teiid.designer.ui.actions.IModelerActionConstants;
import org.teiid.designer.ui.actions.ModelerActionBarIdManager;
import org.teiid.designer.ui.actions.ModelerActionService;
import org.teiid.designer.ui.common.actions.AbstractAction;
import org.teiid.designer.ui.common.actions.GlobalActionsMap;
import org.teiid.designer.ui.common.actions.IActionConstants;
import org.teiid.designer.ui.editors.ModelEditorPage;

public class TransformationActionAdapter
extends DiagramActionAdapter
implements UiConstants,
ITransformationDiagramActionConstants {
    private static final String D_MARKER = "transformationDiagramStart";
    private static final String T_MARKER = "transformationStart";
    private List<Object> modelObjectContributors;
    private AddTransformationSourceAction addSourcesAction;
    private AddUnionSourceAction addUnionSourcesAction;
    private TransformationAction removeSourcesAction;
    private TransformationAction clearSourcesAction;
    private TransformationAction reconcileAction;
    private TransformationAction addToSqlSelectAction;
    private TransformationAction addJoinExpressionAction;
    private AbstractAction lockAction;
    private RefreshAction refreshDiagramAction;
    private ShowParentDiagramAction upPackageDiagramAction;
    private ShowDependencyTargetDiagramAction showDependencyTargetDiagramAction;
    private AbstractAction saveDiagramAction;
    private TransformationAction deleteAction;
    private TransformationAction cutAction;
    private TransformationAction copyAction;
    private TransformationAction pasteAction;
    private TransformationAction cloneAction;
    private AbstractAction renameAction;
    private DiagramGlobalActionsMap actionsMap;

    public TransformationActionAdapter(ModelEditorPage page) {
        super(page);
    }

    public GlobalActionsMap getGlobalActions() {
        if (this.actionsMap == null) {
            this.actionsMap = new DiagramGlobalActionsMap();
            this.actionsMap.reset();
            this.actionsMap.put((Object)IActionConstants.EclipseGlobalActions.DELETE, (Object)this.deleteAction);
            this.actionsMap.put((Object)IActionConstants.EclipseGlobalActions.CUT, (Object)this.cutAction);
            this.actionsMap.put((Object)IActionConstants.EclipseGlobalActions.COPY, (Object)this.copyAction);
            this.actionsMap.put((Object)IActionConstants.EclipseGlobalActions.PASTE, (Object)this.pasteAction);
            this.actionsMap.put((Object)IModelerActionConstants.ModelerGlobalActions.CLONE, (Object)this.cloneAction);
            ((RenameAction)this.renameAction).setDiagramEditor((DiagramEditor)this.getEditorPage());
            this.actionsMap.put((Object)IActionConstants.EclipseGlobalActions.RENAME, (Object)this.renameAction);
        }
        return this.actionsMap;
    }

    protected void initActions() {
        super.initActions();
        Diagram currentDiagram = ((DiagramEditor)this.getEditorPage()).getDiagram();
        EObject transformationEObject = TransformationSourceManager.getTransformationFromDiagram(currentDiagram);
        this.addSourcesAction = (AddTransformationSourceAction)this.getRegisteredAction(AddTransformationSourceAction.class.getName());
        if (this.addSourcesAction == null) {
            this.addSourcesAction = new AddTransformationSourceAction(transformationEObject, currentDiagram);
            this.registerAction((AbstractAction)this.addSourcesAction);
        }
        this.addUnionSourcesAction = (AddUnionSourceAction)this.getRegisteredAction(AddUnionSourceAction.class.getName());
        if (this.addUnionSourcesAction == null) {
            this.addUnionSourcesAction = new AddUnionSourceAction(transformationEObject, currentDiagram);
            this.registerAction((AbstractAction)this.addUnionSourcesAction);
        }
        this.removeSourcesAction = (TransformationAction)this.getRegisteredAction(RemoveTransformationSourceAction.class.getName());
        if (this.removeSourcesAction == null) {
            this.removeSourcesAction = new RemoveTransformationSourceAction(transformationEObject, currentDiagram);
            this.registerAction((AbstractAction)this.removeSourcesAction);
        }
        this.clearSourcesAction = (TransformationAction)this.getRegisteredAction(ClearTransformationAction.class.getName());
        if (this.clearSourcesAction == null) {
            this.clearSourcesAction = new ClearTransformationAction(transformationEObject, currentDiagram);
            this.registerAction((AbstractAction)this.clearSourcesAction);
        }
        this.reconcileAction = (TransformationAction)this.getRegisteredAction(ReconcileTransformationAction.class.getName());
        if (this.reconcileAction == null) {
            this.reconcileAction = new ReconcileTransformationAction(transformationEObject, currentDiagram);
            this.registerAction((AbstractAction)this.reconcileAction);
        }
        this.addToSqlSelectAction = (TransformationAction)this.getRegisteredAction(AddToSqlSelectAction.class.getName());
        if (this.addToSqlSelectAction == null) {
            this.addToSqlSelectAction = new AddToSqlSelectAction(transformationEObject, currentDiagram);
            this.registerAction((AbstractAction)this.addToSqlSelectAction);
        }
        this.addJoinExpressionAction = (TransformationAction)this.getRegisteredAction(AddJoinExpressionAction.class.getName());
        if (this.addJoinExpressionAction == null) {
            this.addJoinExpressionAction = new AddJoinExpressionAction(transformationEObject, currentDiagram);
            this.registerAction((AbstractAction)this.addJoinExpressionAction);
        }
        this.lockAction = (AbstractAction)this.getRegisteredAction(LockAction.class.getName());
        if (this.lockAction == null) {
            this.lockAction = new LockAction(transformationEObject, currentDiagram);
            this.registerAction(this.lockAction);
        }
        this.deleteAction = (TransformationAction)this.getRegisteredAction(DeleteAction.class.getName());
        if (this.deleteAction == null) {
            this.deleteAction = new DeleteAction(transformationEObject, currentDiagram);
            this.registerAction((AbstractAction)this.deleteAction);
        }
        this.cutAction = (TransformationAction)this.getRegisteredAction(CutAction.class.getName());
        if (this.cutAction == null) {
            this.cutAction = new CutAction(transformationEObject, currentDiagram);
            this.registerAction((AbstractAction)this.cutAction);
        }
        this.copyAction = (TransformationAction)this.getRegisteredAction(CopyAction.class.getName());
        if (this.copyAction == null) {
            this.copyAction = new CopyAction(transformationEObject, currentDiagram);
            this.registerAction((AbstractAction)this.copyAction);
        }
        this.pasteAction = (TransformationAction)this.getRegisteredAction(PasteAction.class.getName());
        if (this.pasteAction == null) {
            this.pasteAction = new PasteAction(transformationEObject, currentDiagram);
            this.registerAction((AbstractAction)this.pasteAction);
        }
        this.cloneAction = (TransformationAction)this.getRegisteredAction(CloneAction.class.getName());
        if (this.cloneAction == null) {
            this.cloneAction = new CloneAction(transformationEObject, currentDiagram);
            this.registerAction((AbstractAction)this.cloneAction);
        }
        this.renameAction = (AbstractAction)this.getRegisteredAction(RenameAction.class.getName());
        if (this.renameAction == null) {
            this.renameAction = new RenameAction();
            this.registerAction(this.renameAction);
        }
        this.refreshDiagramAction = (RefreshAction)this.getRegisteredAction(RefreshAction.class.getName());
        if (this.refreshDiagramAction == null) {
            this.refreshDiagramAction = new RefreshAction();
            this.registerAction((AbstractAction)this.refreshDiagramAction);
        }
        this.upPackageDiagramAction = (ShowParentDiagramAction)this.getRegisteredAction(ShowParentDiagramAction.class.getName());
        if (this.upPackageDiagramAction == null) {
            this.upPackageDiagramAction = new ShowParentDiagramAction();
            this.registerAction((AbstractAction)this.upPackageDiagramAction);
        }
        this.showDependencyTargetDiagramAction = (ShowDependencyTargetDiagramAction)this.getRegisteredAction(ShowDependencyTargetDiagramAction.class.getName());
        if (this.showDependencyTargetDiagramAction == null) {
            this.showDependencyTargetDiagramAction = new ShowDependencyTargetDiagramAction();
            this.registerAction((AbstractAction)this.showDependencyTargetDiagramAction);
        }
        this.saveDiagramAction = (AbstractAction)this.getRegisteredAction(SaveDiagramAction.class.getName());
        if (this.saveDiagramAction == null) {
            this.saveDiagramAction = new SaveDiagramAction((DiagramEditor)this.getEditorPage());
            this.registerAction(this.saveDiagramAction);
        }
    }

    private void resetTransformationActions() {
        Diagram currentDiagram = ((DiagramEditor)this.getEditorPage()).getDiagram();
        EObject transformationEObject = TransformationSourceManager.getTransformationFromDiagram(currentDiagram);
        this.addSourcesAction.setTransformation(transformationEObject);
        this.addUnionSourcesAction.setTransformation(transformationEObject);
        this.removeSourcesAction.setTransformation(transformationEObject);
        this.clearSourcesAction.setTransformation(transformationEObject);
        this.reconcileAction.setTransformation(transformationEObject);
        this.addToSqlSelectAction.setTransformation(transformationEObject);
        this.addJoinExpressionAction.setTransformation(transformationEObject);
        this.deleteAction.setTransformation(transformationEObject);
        this.cutAction.setTransformation(transformationEObject);
        this.copyAction.setTransformation(transformationEObject);
        this.pasteAction.setTransformation(transformationEObject);
        this.cloneAction.setTransformation(transformationEObject);
        ((TransformationAction)this.lockAction).setTransformation(transformationEObject);
        this.addSourcesAction.setDiagram(currentDiagram);
        this.addUnionSourcesAction.setDiagram(currentDiagram);
        this.removeSourcesAction.setDiagram(currentDiagram);
        this.clearSourcesAction.setDiagram(currentDiagram);
        this.reconcileAction.setDiagram(currentDiagram);
        this.addToSqlSelectAction.setDiagram(currentDiagram);
        this.addJoinExpressionAction.setDiagram(currentDiagram);
        this.deleteAction.setDiagram(currentDiagram);
        this.cutAction.setDiagram(currentDiagram);
        this.copyAction.setDiagram(currentDiagram);
        this.pasteAction.setDiagram(currentDiagram);
        this.cloneAction.setDiagram(currentDiagram);
    }

    public void contributeExportedActions(IMenuManager theMenuMgr) {
        this.resetTransformationActions();
        if (!this.isDependencyDiagram()) {
            if (theMenuMgr.getId() != null && theMenuMgr.getId().equals("TempMenuID")) {
                this.setEditMenu(theMenuMgr);
                theMenuMgr.add((IAction)this.addSourcesAction);
                theMenuMgr.add((IAction)this.addUnionSourcesAction);
            } else {
                if (this.addSourcesAction.isEnabled()) {
                    theMenuMgr.add((IAction)this.addSourcesAction);
                }
                if (this.addUnionSourcesAction.isEnabled()) {
                    theMenuMgr.add((IAction)this.addUnionSourcesAction);
                }
            }
        }
    }

    public void createContextMenu() {
        this.createContextMenu("diagramEditorPage.contextMenu", this.getEditorPage().getControl());
    }

    public void contributeToMenuManager(IMenuManager theMenuMgr, ISelection selection) {
        block55: {
            block53: {
                TransformationSelectionHelper selectionHelper;
                block54: {
                    this.removeDiagramActions(theMenuMgr);
                    if (this.isDependencyDiagram()) break block53;
                    Diagram currentDiagram = ((DiagramEditor)this.getEditorPage()).getDiagram();
                    EObject transformationEObject = TransformationSourceManager.getTransformationFromDiagram(currentDiagram);
                    selectionHelper = new TransformationSelectionHelper(transformationEObject, selection);
                    if (selectionHelper.getCountType() != 1) break block54;
                    switch (selectionHelper.getType()) {
                        case 9: {
                            this.resetTransformationActions();
                            IAction editAction = this.getAction(IModelerActionConstants.ModelerGlobalActions.EDIT);
                            if (editAction != null) {
                                TransformationMappingRoot root = (TransformationMappingRoot)selectionHelper.getSingleEObject();
                                if (TransformationHelper.isOperation((Object)root.getTarget())) {
                                    ((EditAction)editAction).setEnabledOnce();
                                }
                                theMenuMgr.add(editAction);
                            }
                            theMenuMgr.add((IContributionItem)new Separator());
                            theMenuMgr.add((IAction)this.clearSourcesAction);
                            break;
                        }
                        case 12: {
                            this.resetTransformationActions();
                            IAction editAction = this.getAction(IModelerActionConstants.ModelerGlobalActions.EDIT);
                            if (editAction != null) {
                                TransformationMappingRoot root = (TransformationMappingRoot)selectionHelper.getSingleEObject();
                                if (TransformationHelper.isOperation((Object)root.getTarget())) {
                                    ((EditAction)editAction).setEnabledOnce();
                                }
                                theMenuMgr.add(editAction);
                                break;
                            }
                            break block55;
                        }
                        case 10: {
                            this.resetTransformationActions();
                            IAction editAction = this.getAction(IModelerActionConstants.ModelerGlobalActions.EDIT);
                            if (editAction != null) {
                                TransformationMappingRoot root = (TransformationMappingRoot)selectionHelper.getSingleEObject();
                                if (TransformationHelper.isOperation((Object)root.getTarget())) {
                                    ((EditAction)editAction).setEnabledOnce();
                                }
                                theMenuMgr.add(editAction);
                                break;
                            }
                            break block55;
                        }
                        case 4: {
                            IAction editAction;
                            this.resetTransformationActions();
                            IAction newChildAction = this.getAction(ModelerActionBarIdManager.getInsertChildMenuId());
                            if (newChildAction != null) {
                                theMenuMgr.add(newChildAction);
                            }
                            if ((editAction = this.getAction(IModelerActionConstants.ModelerGlobalActions.EDIT)) != null) {
                                theMenuMgr.add(editAction);
                                break;
                            }
                            break block55;
                        }
                        case 5: 
                        case 6: {
                            this.resetTransformationActions();
                            this.addDiagramActions(theMenuMgr);
                            break;
                        }
                        case 3: {
                            this.resetTransformationActions();
                            IAction existingAction = this.getAction(IModelerActionConstants.ModelerGlobalActions.OPEN);
                            if (existingAction != null) {
                                theMenuMgr.add(existingAction);
                            }
                            theMenuMgr.add((IContributionItem)new Separator());
                            theMenuMgr.add((IContributionItem)new GroupMarker(T_MARKER));
                            theMenuMgr.appendToGroup(T_MARKER, (IAction)this.removeSourcesAction);
                            theMenuMgr.appendToGroup(T_MARKER, (IAction)this.clearSourcesAction);
                            theMenuMgr.appendToGroup(T_MARKER, (IAction)this.addToSqlSelectAction);
                            theMenuMgr.appendToGroup(T_MARKER, (IAction)this.addJoinExpressionAction);
                            theMenuMgr.add((IContributionItem)new Separator("transformationEnd"));
                            MenuManager copyMenu = this.getCopyNameSubMenu(selection);
                            if (copyMenu != null) {
                                theMenuMgr.add((IContributionItem)new Separator());
                                theMenuMgr.add((IContributionItem)copyMenu);
                                theMenuMgr.add((IContributionItem)new Separator());
                                break;
                            }
                            break block55;
                        }
                        case 2: {
                            IAction editAction;
                            IAction existingAction;
                            this.resetTransformationActions();
                            MenuManager menuMgr = this.getModelingActionMenu(selection);
                            if (menuMgr.getItems().length > 0) {
                                theMenuMgr.add((IContributionItem)menuMgr);
                                theMenuMgr.add((IContributionItem)new Separator());
                            }
                            if ((existingAction = this.getAction(IModelerActionConstants.ModelerGlobalActions.OPEN)) != null) {
                                theMenuMgr.add(existingAction);
                            }
                            if (selectionHelper.isVirtual() && (editAction = this.getAction(IModelerActionConstants.ModelerGlobalActions.EDIT)) != null) {
                                theMenuMgr.add(editAction);
                            }
                            theMenuMgr.add((IContributionItem)new Separator());
                            theMenuMgr.add((IContributionItem)new GroupMarker(T_MARKER));
                            theMenuMgr.appendToGroup(T_MARKER, (IAction)this.removeSourcesAction);
                            theMenuMgr.appendToGroup(T_MARKER, (IAction)this.clearSourcesAction);
                            if (selectionHelper.isVirtual()) {
                                this.addExternalExportedActions(theMenuMgr, selection);
                            }
                            theMenuMgr.add((IContributionItem)new Separator("transformationEnd"));
                            MenuManager copyMenu = this.getCopyNameSubMenu(selection);
                            if (copyMenu != null) {
                                theMenuMgr.add((IContributionItem)new Separator());
                                theMenuMgr.add((IContributionItem)copyMenu);
                                theMenuMgr.add((IContributionItem)new Separator());
                                break;
                            }
                            break block55;
                        }
                        case 0: 
                        case 1: {
                            IAction editAction;
                            this.resetTransformationActions();
                            theMenuMgr.add((IContributionItem)new GroupMarker(T_MARKER));
                            theMenuMgr.appendToGroup(T_MARKER, (IAction)this.lockAction);
                            this.addDiagramActions(theMenuMgr);
                            IAction openAction = this.getAction(IModelerActionConstants.ModelerGlobalActions.OPEN);
                            if (openAction != null && theMenuMgr.find(openAction.getId()) != null) {
                                theMenuMgr.remove(openAction.getId());
                            }
                            if ((editAction = this.getAction(IModelerActionConstants.ModelerGlobalActions.EDIT)) != null && theMenuMgr.find(editAction.getId()) != null) {
                                theMenuMgr.remove(editAction.getId());
                                break;
                            }
                            break block55;
                        }
                        case -1: {
                            break;
                        }
                        case 11: {
                            this.resetTransformationActions();
                            this.addDiagramActions(theMenuMgr);
                            break;
                        }
                    }
                    break block55;
                }
                if (selectionHelper.getCountType() == -1) {
                    switch (selectionHelper.getType()) {
                        case 9: {
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 5: {
                            break;
                        }
                        case 3: {
                            this.resetTransformationActions();
                            theMenuMgr.add((IContributionItem)new GroupMarker(T_MARKER));
                            theMenuMgr.appendToGroup(T_MARKER, (IAction)this.removeSourcesAction);
                            theMenuMgr.appendToGroup(T_MARKER, (IAction)this.clearSourcesAction);
                            theMenuMgr.appendToGroup(T_MARKER, (IAction)this.addToSqlSelectAction);
                            theMenuMgr.appendToGroup(T_MARKER, (IAction)this.addJoinExpressionAction);
                            theMenuMgr.add((IContributionItem)new Separator());
                            break;
                        }
                        case 2: {
                            this.resetTransformationActions();
                            IAction existingAction = this.getAction(IModelerActionConstants.ModelerGlobalActions.OPEN);
                            if (existingAction != null) {
                                theMenuMgr.add(existingAction);
                            }
                            theMenuMgr.add((IContributionItem)new Separator());
                            theMenuMgr.add((IContributionItem)new GroupMarker(T_MARKER));
                            theMenuMgr.appendToGroup(T_MARKER, (IAction)this.removeSourcesAction);
                            theMenuMgr.appendToGroup(T_MARKER, (IAction)this.clearSourcesAction);
                            if (selectionHelper.isVirtual()) {
                                this.addExternalExportedActions(theMenuMgr, selection);
                            }
                            theMenuMgr.add((IContributionItem)new Separator());
                            break;
                        }
                        case 0: 
                        case 1: {
                            this.resetTransformationActions();
                            this.addDiagramActions(theMenuMgr);
                            break;
                        }
                        case -1: {
                            break;
                        }
                        default: {
                            break;
                        }
                    }
                }
                break block55;
            }
            Diagram currentDiagram = ((DiagramEditor)this.getEditorPage()).getDiagram();
            EObject transformationEObject = TransformationSourceManager.getTransformationFromDiagram(currentDiagram);
            TransformationSelectionHelper selectionHelper = new TransformationSelectionHelper(transformationEObject, selection);
            if (selectionHelper.getCountType() == 1) {
                switch (selectionHelper.getType()) {
                    case 3: {
                        this.resetTransformationActions();
                        IAction existingAction = this.getAction(IModelerActionConstants.ModelerGlobalActions.OPEN);
                        if (existingAction != null) {
                            theMenuMgr.add(existingAction);
                        }
                        theMenuMgr.add((IContributionItem)new Separator("transformationEnd"));
                        break;
                    }
                    case 2: {
                        this.resetTransformationActions();
                        IAction existingAction = this.getAction(IModelerActionConstants.ModelerGlobalActions.OPEN);
                        if (existingAction != null) {
                            theMenuMgr.add(existingAction);
                        }
                        if (selectionHelper.isVirtual()) {
                            IAction editAction = this.getAction(IModelerActionConstants.ModelerGlobalActions.EDIT);
                            if (editAction != null) {
                                theMenuMgr.add(editAction);
                            }
                            this.addExternalExportedActions(theMenuMgr, selection);
                        }
                        theMenuMgr.add((IContributionItem)new Separator("transformationEnd"));
                        break;
                    }
                    case 9: {
                        IAction editAction = this.getAction(IModelerActionConstants.ModelerGlobalActions.EDIT);
                        if (editAction != null) {
                            theMenuMgr.add(editAction);
                        }
                        theMenuMgr.add((IContributionItem)new Separator());
                        break;
                    }
                    case 10: {
                        IAction editAction = this.getAction(IModelerActionConstants.ModelerGlobalActions.EDIT);
                        if (editAction == null) break;
                        theMenuMgr.add(editAction);
                        break;
                    }
                }
            }
            this.addDiagramActions(theMenuMgr);
        }
    }

    private void addExternalExportedActions(IMenuManager theMenuMgr, ISelection selection) {
        List<Object> contributors = this.getModelObjectActionContributors();
        int size = contributors.size();
        int i = 0;
        while (i < size) {
            IModelObjectActionContributor contributor = (IModelObjectActionContributor)contributors.get(i);
            contributor.contributeToContextMenu(theMenuMgr, selection);
            ++i;
        }
    }

    private void removeDiagramActions(IMenuManager theMenuMgr) {
        if (theMenuMgr.find(T_MARKER) != null) {
            theMenuMgr.remove(T_MARKER);
        }
        if (theMenuMgr.find(this.removeSourcesAction.getId()) != null) {
            theMenuMgr.remove(this.removeSourcesAction.getId());
        }
        if (theMenuMgr.find(this.clearSourcesAction.getId()) != null) {
            theMenuMgr.remove(this.clearSourcesAction.getId());
        }
        if (theMenuMgr.find(this.lockAction.getId()) != null) {
            theMenuMgr.remove(this.lockAction.getId());
        }
        if (theMenuMgr.find(this.refreshDiagramAction.getId()) != null) {
            theMenuMgr.remove(this.refreshDiagramAction.getId());
        }
        if (theMenuMgr.find(this.upPackageDiagramAction.getId()) != null) {
            theMenuMgr.remove(this.upPackageDiagramAction.getId());
        }
        if (theMenuMgr.find(this.showDependencyTargetDiagramAction.getId()) != null) {
            theMenuMgr.remove(this.showDependencyTargetDiagramAction.getId());
        }
        if (theMenuMgr.find(this.saveDiagramAction.getId()) != null) {
            theMenuMgr.remove(this.saveDiagramAction.getId());
        }
        if (theMenuMgr.find("transformationEnd") != null) {
            theMenuMgr.remove("transformationEnd");
        }
    }

    private void addDiagramActions(IMenuManager theMenuMgr) {
        if (!this.isDependencyDiagram()) {
            theMenuMgr.add((IContributionItem)new Separator());
            theMenuMgr.add((IContributionItem)new GroupMarker(D_MARKER));
            theMenuMgr.appendToGroup(D_MARKER, (IAction)this.removeSourcesAction);
            theMenuMgr.appendToGroup(D_MARKER, (IAction)this.clearSourcesAction);
            theMenuMgr.add((IContributionItem)new Separator());
            theMenuMgr.appendToGroup(D_MARKER, (IAction)this.refreshDiagramAction);
            theMenuMgr.appendToGroup(D_MARKER, (IAction)this.upPackageDiagramAction);
            theMenuMgr.appendToGroup(D_MARKER, (IAction)this.saveDiagramAction);
        } else {
            theMenuMgr.add((IContributionItem)new Separator());
            theMenuMgr.add((IContributionItem)new GroupMarker(D_MARKER));
            theMenuMgr.appendToGroup(D_MARKER, (IAction)this.refreshDiagramAction);
            theMenuMgr.appendToGroup(D_MARKER, (IAction)this.showDependencyTargetDiagramAction);
            theMenuMgr.appendToGroup(D_MARKER, (IAction)this.saveDiagramAction);
        }
    }

    public void dispose() {
        super.dispose();
        this.reconcileAction.dispose();
        this.clearSourcesAction.dispose();
        this.setEditorPage(null);
    }

    public void contributeToDiagramToolBar() {
        DiagramToolBarManager tbm = (DiagramToolBarManager)((DiagramEditor)this.getEditorPage()).getToolBarManager();
        tbm.removeAll();
        tbm.add((IAction)this.refreshDiagramAction);
        if (this.isDependencyDiagram()) {
            tbm.add((IAction)this.showDependencyTargetDiagramAction);
        } else {
            tbm.add((IAction)this.upPackageDiagramAction);
        }
        tbm.add((IContributionItem)new Separator());
        this.resetTransformationActions();
        ActionContributionItem addSourcesItem = null;
        ActionContributionItem addUnionSourcesItem = null;
        if (!this.isDependencyDiagram()) {
            addSourcesItem = new ActionContributionItem((IAction)this.addSourcesAction);
            tbm.add((IContributionItem)addSourcesItem);
            addUnionSourcesItem = new ActionContributionItem((IAction)this.addUnionSourcesAction);
            tbm.add((IAction)this.addUnionSourcesAction);
            tbm.add((IAction)this.removeSourcesAction);
            tbm.add((IAction)this.clearSourcesAction);
            tbm.add((IAction)this.reconcileAction);
        }
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this.saveDiagramAction);
        this.refreshDiagramAction.setDiagramEditor((DiagramEditor)this.getEditorPage());
        this.upPackageDiagramAction.setDiagramEditor((DiagramEditor)this.getEditorPage());
        this.showDependencyTargetDiagramAction.setDiagramEditor((DiagramEditor)this.getEditorPage());
        if (!this.isDependencyDiagram()) {
            this.addSourcesAction.setToolBarManager(tbm);
            this.addSourcesAction.setItem(addSourcesItem);
            this.addUnionSourcesAction.setToolBarManager(tbm);
            this.addUnionSourcesAction.setItem(addUnionSourcesItem);
        }
        tbm.update(true);
    }

    private boolean isDependencyDiagram() {
        DiagramEditor editor = (DiagramEditor)this.getEditorPage();
        return editor.getDiagram() != null && editor.getDiagram().getType() != null && editor.getDiagram().getType().equals("dependencyDiagramType");
    }

    public void handleNotification(Notification theNotification) {
    }

    public void enableDiagramToolbarActions() {
        if (this.upPackageDiagramAction != null) {
            this.upPackageDiagramAction.determineEnablement();
        }
        if (this.showDependencyTargetDiagramAction != null) {
            this.showDependencyTargetDiagramAction.determineEnablement();
        }
    }

    public boolean shouldOverrideMenu(ISelection selection) {
        boolean value = false;
        Diagram currentDiagram = ((DiagramEditor)this.getEditorPage()).getDiagram();
        EObject transformationEObject = TransformationSourceManager.getTransformationFromDiagram(currentDiagram);
        TransformationSelectionHelper selectionHelper = new TransformationSelectionHelper(transformationEObject, selection);
        if (selectionHelper.getCountType() == 1) {
            switch (selectionHelper.getType()) {
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    value = true;
                    break;
                }
            }
        } else if (selectionHelper.getCountType() == -1) {
            switch (selectionHelper.getType()) {
                case 2: 
                case 3: {
                    value = true;
                    break;
                }
            }
        }
        return value;
    }

    private MenuManager getCopyNameSubMenu(Object selection) {
        MenuManager menu = new MenuManager(org.teiid.designer.ui.UiConstants.Util.getString("ModelerActionService.copyNameSubMenu.title", new Object[0]));
        CopyFullNameAction action1 = new CopyFullNameAction();
        action1.getActionWorker().selectionChanged(selection);
        menu.add((IAction)action1);
        CopyNameAction action2 = new CopyNameAction();
        action1.getActionWorker().selectionChanged(selection);
        menu.add((IAction)action2);
        return menu;
    }

    private IAction getAction(String theActionId) {
        IAction action = null;
        try {
            action = this.getActionService().getAction(theActionId);
        }
        catch (CoreException coreException) {}
        return action;
    }

    private MenuManager getModelingActionMenu(ISelection theSelection) {
        IWorkbenchWindow window = UiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        ModelerActionService service = (ModelerActionService)org.teiid.designer.ui.UiPlugin.getDefault().getActionService(window.getActivePage());
        return service.getModelingActionMenu(theSelection);
    }

    private List<Object> getModelObjectActionContributors() {
        if (this.modelObjectContributors == null) {
            String ID = "modelObjectActionContributor";
            String CLASSNAME = "name";
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.ui", ID);
            IExtension[] extensions = extensionPoint.getExtensions();
            if (extensions.length > 0) {
                this.modelObjectContributors = new ArrayList<Object>(extensions.length);
                int i = 0;
                while (i < extensions.length) {
                    IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                    Object extension = null;
                    String uniqueID = extensions[i].getSimpleIdentifier();
                    if (uniqueID.startsWith("transformationDiagramModelObjectActionContributor")) {
                        int j = 0;
                        while (j < elements.length) {
                            try {
                                extension = elements[j].createExecutableExtension(CLASSNAME);
                                if (extension instanceof IModelObjectActionContributor) {
                                    this.modelObjectContributors.add(extension);
                                } else {
                                    org.teiid.designer.ui.UiConstants.Util.log(4, org.teiid.designer.ui.UiConstants.Util.getString("ModelerActionService.wrongContributorClass", new Object[]{extension.getClass().getName()}));
                                }
                            }
                            catch (Exception theException) {
                                org.teiid.designer.ui.UiConstants.Util.log(4, (Throwable)theException, org.teiid.designer.ui.UiConstants.Util.getString("ModelerActionService.contributorProblem", new Object[]{elements[j].getAttribute(CLASSNAME)}));
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            } else {
                this.modelObjectContributors = Collections.emptyList();
            }
        }
        return this.modelObjectContributors;
    }
}

