/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.actions;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelTransformations;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.transformation.ui.UiConstants;
import org.teiid.designer.transformation.ui.actions.TransformationAction;
import org.teiid.designer.transformation.ui.util.DependencyReportDialog;
import org.teiid.designer.transformation.ui.util.SqlDependencyHelper;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class GenerateDependencyReportAction
extends TransformationAction
implements UiConstants {
    static final String PREFIX = I18nUtil.getPropertyPrefix(GenerateDependencyReportAction.class);

    public GenerateDependencyReportAction() {
        super(null);
        this.setUseWaitCursor(false);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        this.determineEnablement();
    }

    @Override
    protected void doRun() {
        ModelResource modelResource;
        EObject eObject = SelectionUtilities.getSelectedEObject((ISelection)this.getSelection());
        if (eObject != null && (modelResource = ModelUtilities.getModelResourceForModelObject((EObject)eObject)) != null && ModelUtilities.isVirtual((ModelResource)modelResource)) {
            try {
                DependencyReportDialog dialog;
                List transformations = modelResource.getModelTransformations().getTransformations(eObject);
                if (transformations != null && transformations.size() == 1 && (dialog = new DependencyReportDialog(UiUtil.getWorkbenchShellOnlyIfUiThread(), eObject)).open() == 0) {
                    SqlDependencyHelper helper = new SqlDependencyHelper(eObject, dialog.isIncludeIntermediate(), dialog.getColumnDelimeter(), dialog.getNullValue());
                    this.writeReport(dialog.getReportFileName(), helper.getFileString());
                }
            }
            catch (ModelWorkspaceException e) {
                String message = Util.getString("GenerateDependencyReportAction.generateDependencyReportError", (Object)modelResource.toString());
                Util.log(4, (Throwable)e, message);
            }
        }
        this.determineEnablement();
    }

    public void writeReport(final String theFileName, final String theContents) {
        UiBusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            @Override
            public void run() {
                block11: {
                    try {
                        File file = new File(theFileName);
                        if (!file.exists()) {
                            file.createNewFile();
                        }
                        if (file.canWrite()) {
                            Writer output = null;
                            try {
                                try {
                                    output = new BufferedWriter(new FileWriter(file));
                                    output.write(theContents);
                                }
                                catch (IOException theException) {
                                    Util.log((Throwable)theException);
                                    WidgetUtil.showError((Throwable)theException);
                                    if (output != null) {
                                        output.close();
                                    }
                                    break block11;
                                }
                            }
                            finally {
                                if (output != null) {
                                    output.close();
                                }
                            }
                        }
                        WidgetUtil.showError((String)Util.getString(String.valueOf(PREFIX) + "dialog.errorMsg", new Object[]{theFileName}));
                    }
                    catch (Exception theException) {
                        Util.log((Throwable)theException);
                        WidgetUtil.showError((Throwable)theException);
                    }
                }
            }
        });
    }

    private void determineEnablement() {
        ModelResource modelResource;
        EObject eObject = SelectionUtilities.getSelectedEObject((ISelection)this.getSelection());
        if (eObject != null && this.canLegallyEditResource() && (modelResource = ModelUtilities.getModelResourceForModelObject((EObject)eObject)) != null && ModelUtilities.isVirtual((ModelResource)modelResource)) {
            try {
                List transformations;
                ModelTransformations modelTransformations = modelResource.getModelTransformations();
                if (modelTransformations != null && (transformations = modelTransformations.getTransformations(eObject)) != null && transformations.size() == 1) {
                    this.setEnabled(true);
                    return;
                }
            }
            catch (ModelWorkspaceException e) {
                String message = Util.getString("GenerateDependencyReportAction.generateDependencyReportError", (Object)modelResource.toString());
                Util.log(4, (Throwable)e, message);
            }
        }
        this.setEnabled(false);
    }
}

