/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.transformation.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.actions.TransformationAction;
import org.teiid.designer.transformation.ui.editors.TransformationObjectEditorPage;
import org.teiid.designer.transformation.ui.editors.sqleditor.SqlEditorPanel;
import org.teiid.designer.transformation.ui.util.TransformationUiResourceHelper;
import org.teiid.designer.transformation.util.SqlAspectHelper;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelObjectEditorPage;
import org.teiid.designer.ui.editors.MultiPageModelEditor;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;

public class AddToSqlSelectAction
extends TransformationAction {
    public AddToSqlSelectAction(EObject transformationEObject, Diagram diagram) {
        super(transformationEObject, diagram);
    }

    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        super.selectionChanged(thePart, theSelection);
        boolean enable = this.shouldEnable();
        this.setEnabled(enable);
    }

    @Override
    protected void doRun() {
        ModelObjectEditorPage moep;
        ISelection theSelection = this.getSelection();
        List selectedEObjs = SelectionUtilities.getSelectedEObjects((ISelection)theSelection);
        ArrayList<String> elemNames = new ArrayList<String>(selectedEObjs.size());
        ArrayList<String> parentNames = new ArrayList<String>(selectedEObjs.size());
        for (EObject eObj : selectedEObjs) {
            String elemFullName = TransformationHelper.getSqlEObjectFullName((EObject)eObj);
            EObject parentEObj = eObj.eContainer();
            String groupFullName = TransformationHelper.getSqlEObjectFullName((EObject)parentEObj);
            if (elemFullName == null || groupFullName == null) continue;
            elemNames.add(elemFullName);
            parentNames.add(groupFullName);
        }
        IEditorPart editor = UiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor instanceof MultiPageModelEditor && (moep = ((MultiPageModelEditor)editor).getActiveObjectEditor()) != null && moep instanceof TransformationObjectEditorPage) {
            TransformationObjectEditorPage transOEP = (TransformationObjectEditorPage)moep;
            SqlEditorPanel sqlEditor = transOEP.getCurrentSqlEditor();
            if (sqlEditor.isCurrentCaretWithinSelect()) {
                sqlEditor.insertElements(elemNames, parentNames, sqlEditor.getCaretOffset(), null);
            } else {
                sqlEditor.insertElementsAtEndOfSelect(elemNames, parentNames, null);
            }
        }
    }

    private boolean shouldEnable() {
        boolean enable = false;
        List selectedEObjs = SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection());
        if (!selectedEObjs.isEmpty() && !ModelObjectUtilities.isReadOnly((EObject)this.getTransformation()) && !this.isDependencyDiagram() && this.getTransformation() != null && TransformationUiResourceHelper.isSqlTransformationResource(this.getTransformation()) && this.areEObjectsSelected()) {
            TransformationObjectEditorPage transOEP;
            SqlEditorPanel sqlEditor;
            ModelObjectEditorPage moep;
            boolean editorOpen = false;
            IEditorPart editor = UiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage().getActiveEditor();
            if (editor instanceof MultiPageModelEditor && (moep = ((MultiPageModelEditor)editor).getActiveObjectEditor()) != null && moep instanceof TransformationObjectEditorPage && (sqlEditor = (transOEP = (TransformationObjectEditorPage)moep).getCurrentSqlEditor()) != null) {
                editorOpen = true;
            }
            if (editorOpen) {
                selectedEObjs = SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection());
                for (EObject eObj : selectedEObjs) {
                    if (eObj == null) continue;
                    if (org.teiid.designer.core.metamodel.aspect.sql.SqlAspectHelper.isColumn((EObject)eObj) && !SqlAspectHelper.isInputParameter((EObject)eObj)) {
                        if (((SqlTransformationMappingRoot)this.getTransformation()).getOutputs().contains((Object)eObj.eContainer())) {
                            return false;
                        }
                        enable = true;
                        continue;
                    }
                    return false;
                }
            }
        }
        return enable;
    }
}

