/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.profiles.ldap;

import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.io.jndi.JNDIConnectionWrapper;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.drivers.jdbc.JDBCConnection;
import org.teiid.core.designer.util.StringConstants;
import org.teiid.designer.datatools.profiles.ldap.ILdapProfileConstants;
import org.teiid.designer.datatools.profiles.ldap.LDAPConnectionFactory;

public class JndiLdapConnection
extends JDBCConnection
implements ILdapProfileConstants,
StringConstants {
    public JndiLdapConnection(IConnectionProfile profile, Class factoryClass) {
        super(profile, factoryClass);
    }

    public void open() {
        if (this.mConnection != null) {
            this.close();
        }
        this.mConnection = null;
        this.mConnectException = null;
        try {
            this.initializeLDAPContext(this.getConnectionProfile());
        }
        catch (Exception e) {
            this.mConnectException = e;
        }
    }

    protected Object createConnection(ClassLoader cl) throws Throwable {
        this.initializeLDAPContext(this.getConnectionProfile());
        return this.mConnection;
    }

    private void initializeLDAPContext(IConnectionProfile connectionProfile) throws Exception {
        LDAPConnectionFactory factory = new LDAPConnectionFactory();
        Connection connection = factory.convert(connectionProfile);
        JNDIConnectionWrapper wrapper = new JNDIConnectionWrapper(connection);
        NullProgressMonitor ipm = new NullProgressMonitor();
        StudioProgressMonitor monitor = new StudioProgressMonitor((IProgressMonitor)ipm);
        wrapper.connect(monitor);
        wrapper.bind(monitor);
        Exception exception = monitor.getException();
        if (exception != null) {
            throw exception;
        }
        this.mConnection = wrapper;
    }

    public void close() {
        if (this.mConnection instanceof JNDIConnectionWrapper) {
            ((JNDIConnectionWrapper)this.mConnection).disconnect();
            this.mConnection = null;
        }
    }
}

