/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.core.dto;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fusesource.ide.fabric8.core.connector.Fabric8Facade;
import org.fusesource.ide.fabric8.core.dto.BaseDTO;
import org.fusesource.ide.fabric8.core.utils.JsonHelper;
import org.jboss.dmr.ModelNode;

public class ProfileRequirementsDTO
extends BaseDTO {
    private static final String JSON_PROFILE = "profile";
    private static final String JSON_MIN_INSTANCES = "minimumInstances";
    private static final String JSON_MAX_INSTANCES = "maximumInstances";
    private static final String JSON_DEP_PROFILES = "dependentProfiles";

    public ProfileRequirementsDTO(Fabric8Facade fabric8, Map<String, Object> jsonAttribs) {
        super(fabric8, jsonAttribs);
    }

    @Override
    public void create() {
    }

    @Override
    public void delete() {
    }

    @Override
    public void update() {
    }

    public String getProfile() {
        return (String)this.getFieldValue(JSON_PROFILE);
    }

    public BigInteger getMinimumInstances() {
        return (BigInteger)this.getFieldValue(JSON_MIN_INSTANCES);
    }

    public void setMinimumInstances(BigInteger min) {
        this.setFieldValue(JSON_MIN_INSTANCES, min);
    }

    public BigInteger getMaximumInstances() {
        return (BigInteger)this.getFieldValue(JSON_MAX_INSTANCES);
    }

    public void setMaximumInstances(BigInteger max) {
        this.setFieldValue(JSON_MAX_INSTANCES, max);
    }

    public List<String> getDependentProfiles() {
        return this.getFieldValue(JSON_DEP_PROFILES) != null ? (List)this.getFieldValue(JSON_DEP_PROFILES) : new ArrayList();
    }

    public void setDependentProfiles(List<String> depList) {
        this.setFieldValue(JSON_DEP_PROFILES, depList);
    }

    public boolean checkIsEmpty() {
        return ProfileRequirementsDTO.isEmpty(this.getMinimumInstances()) && ProfileRequirementsDTO.isEmpty(this.getDependentProfiles()) && this.getMaximumInstances() == null;
    }

    protected static boolean isEmpty(BigInteger number) {
        return number == null || number.intValue() == 0;
    }

    protected static boolean isEmpty(Collection<?> coll) {
        return coll == null || coll.isEmpty();
    }

    public static ProfileRequirementsDTO createEmpty(Fabric8Facade fabric8, String profileId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(JSON_DEP_PROFILES, new ArrayList());
        map.put(JSON_PROFILE, profileId);
        map.put(JSON_MAX_INSTANCES, null);
        map.put(JSON_MIN_INSTANCES, BigInteger.ZERO);
        return new ProfileRequirementsDTO(fabric8, map);
    }

    public ModelNode toJson() {
        ModelNode root = new ModelNode();
        root.get(JSON_PROFILE).set(this.getProfile());
        if (this.getMaximumInstances() != null) {
            root.get(JSON_MAX_INSTANCES).set(this.getMaximumInstances());
        }
        if (this.getMinimumInstances() != null) {
            root.get(JSON_MIN_INSTANCES).set(this.getMinimumInstances());
        }
        ModelNode listNode = root.get(JSON_DEP_PROFILES).setEmptyList();
        for (String entry : this.getDependentProfiles()) {
            listNode.add(entry);
        }
        return root;
    }

    public static ProfileRequirementsDTO fromJson(Fabric8Facade fabricFacade, ModelNode node) {
        Map<String, Object> map = JsonHelper.getAsMap(node);
        ProfileRequirementsDTO profReq = new ProfileRequirementsDTO(fabricFacade, map);
        return profReq;
    }
}

