/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.core.dto;

import io.fabric8.insight.log.support.Objects;
import java.util.Date;
import java.util.Map;
import org.fusesource.ide.commons.util.BeanSupport;
import org.fusesource.ide.commons.util.Strings;
import org.fusesource.ide.fabric8.core.dto.LogResultsDTO;
import org.fusesource.ide.fabric8.core.utils.JsonHelper;
import org.jboss.dmr.ModelNode;

public class LogEventDTO
extends BeanSupport
implements Comparable<LogEventDTO> {
    private static final String PROPERTY_VALUE_UNDEFINED = "?";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final String PROPERTY_LOGEVENT_HOST = "host";
    private static final String PROPERTY_LOGEVENT_SEQ = "seq";
    private static final String PROPERTY_LOGEVENT_TIMESTAMP = "timestamp";
    private static final String PROPERTY_LOGEVENT_LOGLEVEL = "level";
    private static final String PROPERTY_LOGEVENT_LOGGER = "logger";
    private static final String PROPERTY_LOGEVENT_THREAD = "thread";
    private static final String PROPERTY_LOGEVENT_MESSAGE = "message";
    private static final String PROPERTY_LOGEVENT_EXCEPTION = "exception";
    private static final String PROPERTY_LOGEVENT_PROPERTIES = "properties";
    private static final String PROPERTY_LOGEVENT_CLASS = "className";
    private static final String PROPERTY_LOGEVENT_FILE = "fileName";
    private static final String PROPERTY_LOGEVENT_METHOD = "methodName";
    private static final String PROPERTY_LOGEVENT_CONTAINER = "containerName";
    private static final String PROPERTY_LOGEVENT_LINE = "lineNumber";
    public static final String PROPERTY_LOGEVENT_PROPERTIES_BUNDLEID = "bundle.id";
    public static final String PROPERTY_LOGEVENT_PROPERTIES_BUNDLEVERSION = "bundle.version";
    public static final String PROPERTY_LOGEVENT_PROPERTIES_MAVEN_COORDS = "maven.coordinates";
    public static final String PROPERTY_LOGEVENT_PROPERTIES_BUNDLENAME = "bundle.name";
    private String className;
    private String container;
    private String[] exception;
    private String fileName;
    private String eventhost;
    private String logLevel;
    private String lineNo;
    private String logger;
    private String logMessage;
    private String methodName;
    private Long seq;
    private String threadName;
    private Date eventTimestamp;
    private Map<String, String> propertiesMap;

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getContainer() {
        return this.container;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public String[] getException() {
        return this.exception;
    }

    public void setException(String[] exception) {
        this.exception = exception;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getEventhost() {
        return this.eventhost;
    }

    public void setEventhost(String eventhost) {
        this.eventhost = eventhost;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public String getLineNo() {
        return this.lineNo;
    }

    public void setLineNo(String lineNo) {
        this.lineNo = lineNo;
    }

    public String getLogger() {
        return this.logger;
    }

    public void setLogger(String logger) {
        this.logger = logger;
    }

    public String getLogMessage() {
        return this.logMessage;
    }

    public void setLogMessage(String logMessage) {
        this.logMessage = logMessage.replaceAll("tat", "\tat");
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Long getSeq() {
        return this.seq;
    }

    public void setSeq(Long seq) {
        this.seq = seq;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public Date getEventTimestamp() {
        return this.eventTimestamp;
    }

    public void setEventTimestamp(Date eventTimestamp) {
        this.eventTimestamp = eventTimestamp;
    }

    public Map<String, String> getPropertiesMap() {
        return this.propertiesMap;
    }

    public void setPropertiesMap(Map<String, String> propertiesMap) {
        this.propertiesMap = propertiesMap;
    }

    public static LogEventDTO fromJson(LogResultsDTO parent, ModelNode ev) throws Exception {
        String className = JsonHelper.getAsString(ev, PROPERTY_LOGEVENT_CLASS);
        String container = JsonHelper.getAsString(ev, PROPERTY_LOGEVENT_CONTAINER);
        String[] exception = JsonHelper.getAsStringArray(ev, PROPERTY_LOGEVENT_EXCEPTION);
        String fileName = JsonHelper.getAsString(ev, PROPERTY_LOGEVENT_FILE);
        String eventhost = JsonHelper.getAsString(ev, PROPERTY_LOGEVENT_HOST);
        String logLevel = JsonHelper.getAsString(ev, PROPERTY_LOGEVENT_LOGLEVEL);
        String lineNo = JsonHelper.getAsString(ev, PROPERTY_LOGEVENT_LINE);
        String logger = JsonHelper.getAsString(ev, PROPERTY_LOGEVENT_LOGGER);
        String logMessage = JsonHelper.getAsString(ev, PROPERTY_LOGEVENT_MESSAGE);
        String methodName = JsonHelper.getAsString(ev, PROPERTY_LOGEVENT_METHOD);
        Long seq = JsonHelper.getAsLong(ev, PROPERTY_LOGEVENT_SEQ);
        String threadName = JsonHelper.getAsString(ev, PROPERTY_LOGEVENT_THREAD);
        Date eventTimestamp = new Date(JsonHelper.getAsLong(ev, PROPERTY_LOGEVENT_TIMESTAMP));
        Map<String, String> propertiesMap = JsonHelper.getAsPropertiesMap(ev, PROPERTY_LOGEVENT_PROPERTIES);
        LogEventDTO event = new LogEventDTO();
        event.setClassName(className);
        event.setContainer(container);
        event.setException(exception);
        event.setFileName(fileName);
        event.setEventhost(Strings.isBlank((String)eventhost) ? parent.getHost() : eventhost);
        event.setLogLevel(logLevel);
        event.setLineNo(lineNo);
        event.setLogger(logger);
        event.setLogMessage(logMessage);
        event.setMethodName(methodName);
        event.setSeq(seq);
        event.setThreadName(threadName);
        event.setEventTimestamp(eventTimestamp);
        event.setPropertiesMap(propertiesMap);
        return event;
    }

    public int hashCode() {
        int result = this.eventhost != null ? this.eventhost.hashCode() : 0;
        result = 31 * result + (this.container != null ? this.container.hashCode() : 0);
        result = 31 * result + (this.seq != null ? this.seq.hashCode() : 0);
        result = 31 * result + (this.eventTimestamp != null ? this.eventTimestamp.hashCode() : 0);
        result = 31 * result + (this.logger != null ? this.logger.hashCode() : 0);
        result = 31 * result + (this.threadName != null ? this.threadName.hashCode() : 0);
        result = 31 * result + (this.logMessage != null ? this.logMessage.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogEventDTO logEvent = (LogEventDTO)o;
        if (this.eventhost != null ? !this.eventhost.equals(logEvent.eventhost) : logEvent.eventhost != null) {
            return false;
        }
        if (this.container != null ? !this.container.equals(logEvent.container) : logEvent.container != null) {
            return false;
        }
        if (this.logger != null ? !this.logger.equals(logEvent.logger) : logEvent.logger != null) {
            return false;
        }
        if (this.logMessage != null ? !this.logMessage.equals(logEvent.logMessage) : logEvent.logMessage != null) {
            return false;
        }
        if (this.seq != null ? !this.seq.equals(logEvent.seq) : logEvent.seq != null) {
            return false;
        }
        if (this.threadName != null ? !this.threadName.equals(logEvent.threadName) : logEvent.threadName != null) {
            return false;
        }
        return !(this.eventTimestamp != null ? !this.eventTimestamp.equals(logEvent.eventTimestamp) : logEvent.eventTimestamp != null);
    }

    @Override
    public int compareTo(LogEventDTO that) {
        int answer = Objects.compare((Object)this.eventTimestamp, (Object)that.eventTimestamp);
        if (answer == 0 && (answer = Objects.compare((Object)this.seq, (Object)that.seq)) == 0 && (answer = Objects.compare((Object)this.eventhost, (Object)that.eventhost)) == 0 && (answer = Objects.compare((Object)this.container, (Object)that.container)) == 0 && (answer = Objects.compare((Object)this.threadName, (Object)that.threadName)) == 0 && (answer = Objects.compare((Object)this.logger, (Object)that.logger)) == 0) {
            answer = Objects.compare((Object)this.logMessage, (Object)that.logMessage);
        }
        return answer;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.getLogLevel().equalsIgnoreCase("error")) {
            String[] lines = this.getException();
            if (lines != null && lines.length > 0) {
                buf.append(this.getLogMessage()).append(NEW_LINE);
                int i = 0;
                while (i < lines.length) {
                    String line = lines[i];
                    if (line.startsWith("t... ")) {
                        buf.append(line.replaceFirst("t... ", "... ")).append(NEW_LINE);
                    } else if (line.startsWith("tat ")) {
                        buf.append(line.replaceFirst("tat ", "   at ")).append(NEW_LINE);
                    } else {
                        buf.append(line).append(NEW_LINE);
                    }
                    ++i;
                }
            } else {
                String className = this.getClassName();
                String methodName = this.getMethodName();
                String fileName = this.getFileName();
                String lineNumber = this.getLineNo();
                buf.append(this.getLogMessage()).append(NEW_LINE);
                buf.append('\t');
                buf.append("at " + className + "." + methodName + "(" + fileName + ":" + lineNumber + ")");
                buf.append(NEW_LINE);
            }
        } else {
            buf.append(String.format("Timestamp: %s\nContainer:%s\n\n[%s] %s   -   %s\n", this.getEventTimestamp(), this.getContainer(), this.getLogLevel(), this.getLogger(), this.getLogMessage()));
        }
        return buf.toString();
    }
}

