/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.core.dto;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fusesource.ide.fabric8.core.connector.Fabric8Facade;
import org.fusesource.ide.fabric8.core.dto.BaseDTO;
import org.fusesource.ide.fabric8.core.dto.ProfileStatusDTO;
import org.fusesource.ide.fabric8.core.dto.RequirementsDTO;
import org.fusesource.ide.fabric8.core.utils.JsonHelper;
import org.jboss.dmr.ModelNode;

public class FabricStatusDTO
extends BaseDTO {
    public static final String JSON_PROFILE_STATUS_MAP = "profileStatusMap";
    public static final String JSON_REQUIREMENTS = "requirements";
    private Map<String, ProfileStatusDTO> profileStatusMap = new HashMap<String, ProfileStatusDTO>();
    private RequirementsDTO requirements;

    public FabricStatusDTO(Fabric8Facade fabric8, Map<String, Object> jsonAttribs) {
        super(fabric8, jsonAttribs);
    }

    public RequirementsDTO getRequirements() {
        return this.requirements;
    }

    public void setRequirements(RequirementsDTO requirements) {
        this.requirements = requirements;
    }

    public void addProfileStatus(ProfileStatusDTO req) {
        if (!this.profileStatusMap.containsKey(req.getProfile())) {
            this.profileStatusMap.put(req.getProfile(), req);
        }
    }

    @Override
    public void create() {
    }

    @Override
    public void delete() {
    }

    @Override
    public void update() {
    }

    public Map<String, ProfileStatusDTO> getProfileStatusMap() {
        return this.profileStatusMap;
    }

    public static FabricStatusDTO fromJson(Fabric8Facade fabricFacade, ModelNode rootNode) {
        FabricStatusDTO status = new FabricStatusDTO(fabricFacade, new HashMap<String, Object>());
        List<ModelNode> nodes = JsonHelper.getAsList(rootNode, JSON_PROFILE_STATUS_MAP);
        for (ModelNode mn : nodes) {
            status.addProfileStatus(ProfileStatusDTO.fromJson(fabricFacade, mn));
        }
        nodes = JsonHelper.getAsList(rootNode, JSON_REQUIREMENTS);
        RequirementsDTO ro = RequirementsDTO.fromJson(fabricFacade, nodes);
        status.setRequirements(ro);
        return status;
    }
}

