/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.fabric8.core.connector;

import io.fabric8.api.CreateContainerOptions;
import io.fabric8.insight.log.LogFilter;
import java.util.List;
import org.fusesource.ide.fabric8.core.connector.Fabric8ConnectorType;
import org.fusesource.ide.fabric8.core.dto.ContainerDTO;
import org.fusesource.ide.fabric8.core.dto.CreateContainerMetadataDTO;
import org.fusesource.ide.fabric8.core.dto.CreateContainerOptionsDTO;
import org.fusesource.ide.fabric8.core.dto.FabricStatusDTO;
import org.fusesource.ide.fabric8.core.dto.LogResultsDTO;
import org.fusesource.ide.fabric8.core.dto.ProfileDTO;
import org.fusesource.ide.fabric8.core.dto.RequirementsDTO;
import org.fusesource.ide.fabric8.core.dto.VersionDTO;

public class Fabric8Facade {
    private Fabric8ConnectorType connection;

    public Fabric8Facade(Fabric8ConnectorType connection) {
        this.connection = connection;
    }

    public List<ContainerDTO> getContainers() {
        return this.connection.getContainers();
    }

    public ContainerDTO getContainer(String containerId) {
        return this.connection.getContainer(containerId);
    }

    public ContainerDTO getCurrentContainer() {
        return this.connection.getCurrentContainer();
    }

    public void startContainer(ContainerDTO container) {
        this.startContainer(container.getId());
    }

    public void startContainer(String containerId) {
        this.connection.startContainer(containerId);
    }

    public void stopContainer(ContainerDTO container) {
        this.stopContainer(container.getId());
    }

    public void stopContainer(String containerId) {
        this.connection.stopContainer(containerId);
    }

    public void destroyContainer(ContainerDTO container) {
        this.destroyContainer(container.getId());
    }

    public void destroyContainer(String containerId) {
        this.connection.destroyContainer(containerId);
    }

    public void setVersionForContainer(String containerId, String versionId) {
        this.connection.setVersionForContainer(containerId, versionId);
    }

    public String getWebUrl() {
        return this.connection.getWebUrl();
    }

    public String getGitUrl() {
        return this.connection.getGitUrl();
    }

    public String getMavenUploadProxyUrl() {
        return this.connection.getMavenProxyUploadUrl();
    }

    public String getMavenDownloadProxyUrl() {
        return this.connection.getMavenProxyDownloadUrl();
    }

    public VersionDTO getDefaultVersion() {
        return this.connection.getDefaultVersion();
    }

    public void setDefaultVersion(VersionDTO version) {
        this.setDefaultVersion(version.getId());
    }

    public void setDefaultVersion(String versionId) {
        this.connection.setDefaultVersion(versionId);
    }

    public List<VersionDTO> getVersions() {
        return this.connection.getVersions();
    }

    public void deleteVersion(VersionDTO version) {
        this.deleteVersion(version.getId());
    }

    public void deleteVersion(String versionId) {
        this.connection.deleteVersion(versionId);
    }

    public VersionDTO createVersion(String versionId) {
        return this.connection.createVersion(versionId);
    }

    public VersionDTO createVersion(String parentVersionId, String versionId) {
        return this.connection.createVersion(parentVersionId, versionId);
    }

    public List<ProfileDTO> getProfiles(String versionId) {
        return this.connection.getProfiles(versionId);
    }

    public ProfileDTO getProfile(String versionId, String profileId) {
        return this.connection.getProfile(versionId, profileId);
    }

    public ProfileDTO createProfile(String versionId, String profileId) {
        return this.connection.createProfile(versionId, profileId);
    }

    public void deleteProfile(String versionId, String profileId) {
        this.connection.deleteProfile(versionId, profileId);
    }

    public void setProfilesForContainer(String containerId, String versionId, List<String> profileIds) {
        this.connection.setProfilesForContainer(containerId, versionId, profileIds);
    }

    public void addProfilesToContainer(String containerId, String ... profileIds) {
        this.connection.addProfilesToContainer(containerId, profileIds);
    }

    public void removeProfiles(String containerId, String ... profileIds) {
        this.connection.removeProfilesFromContainer(containerId, profileIds);
    }

    public void setProfileBundles(String versionId, String profileId, List<String> bundles) {
        this.connection.setProfileBundles(versionId, profileId, bundles);
    }

    public void setProfileFabs(String versionId, String profileId, List<String> fabs) {
        this.connection.setProfileFabs(versionId, profileId, fabs);
    }

    public void setProfileFeatures(String versionId, String profileId, List<String> features) {
        this.connection.setProfileFeatures(versionId, profileId, features);
    }

    public void setProfileOptionals(String versionId, String profileId, List<String> optionals) {
        this.connection.setProfileOptionals(versionId, profileId, optionals);
    }

    public void setProfileOverrides(String versionId, String profileId, List<String> overrides) {
        this.connection.setProfileOverrides(versionId, profileId, overrides);
    }

    public void setProfileParentIds(String versionId, String profileId, List<String> parentIds) {
        this.connection.setProfileParentIds(versionId, profileId, parentIds);
    }

    public void setProfileRepositories(String versionId, String profileId, List<String> repositories) {
        this.connection.setProfileRepositories(versionId, profileId, repositories);
    }

    public String getZookeeperUrl() {
        return this.connection.getZookeeperUrl();
    }

    public String getMavenRepoURI() {
        return this.connection.getMavenRepoURI();
    }

    public RequirementsDTO getRequirements() {
        return this.connection.getRequirements();
    }

    public void setRequirements(RequirementsDTO requirements) {
        this.connection.setRequirements(requirements);
    }

    public FabricStatusDTO getFabricStatus() {
        return this.connection.getFabricStatus();
    }

    public CreateContainerMetadataDTO[] createContainers(CreateContainerOptionsDTO options) {
        return this.connection.createContainers(options);
    }

    public CreateContainerMetadataDTO[] createContainers(CreateContainerOptions options) {
        return this.connection.createContainers(options);
    }

    public LogResultsDTO queryLog(LogFilter filter) {
        return this.connection.queryLog(filter);
    }
}

