/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.metadata.impl;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.core.runtime.IStatus;
import org.teiid.designer.jdbc.JdbcPlugin;
import org.teiid.designer.jdbc.JdbcUtil;
import org.teiid.designer.jdbc.data.MetadataRequest;
import org.teiid.designer.jdbc.data.Response;

public class GetIndexesRequest
extends MetadataRequest {
    public static final String NAME = JdbcPlugin.Util.getString("GetIndexesRequestName", new Object[0]);
    private static final String METHOD_NAME = "getIndexInfo";

    public GetIndexesRequest(DatabaseMetaData metadata, String catalogNamePattern, String schemaNamePattern, String tableNamePattern, boolean uniqueValuesOnly, boolean approximateAllowed) {
        super(NAME, metadata, METHOD_NAME, new Object[]{catalogNamePattern, schemaNamePattern, tableNamePattern, new Boolean(uniqueValuesOnly), new Boolean(approximateAllowed)});
    }

    @Override
    protected IStatus performInvocation(Response results) {
        IStatus status;
        block14: {
            DatabaseMetaData dbmd = this.getDatabaseMetaData();
            ResultSet resultSet = null;
            status = null;
            try {
                try {
                    String catalogPattern = (String)this.getParameters()[0];
                    String schemaPattern = (String)this.getParameters()[1];
                    String tablePattern = (String)this.getParameters()[2];
                    boolean unique = (Boolean)this.getParameters()[3];
                    boolean approximate = (Boolean)this.getParameters()[4];
                    resultSet = dbmd.getIndexInfo(catalogPattern, schemaPattern, tablePattern, unique, approximate);
                    Response.addResults(results, resultSet, this.isMetadataRequested());
                }
                catch (SQLException e) {
                    status = JdbcUtil.createIStatus(e, e.getLocalizedMessage());
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {}
                }
                throw throwable;
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return status;
    }
}

