/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.core.runtime;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.jboss.tools.esb.core.ESBProjectCorePlugin;
import org.jboss.tools.esb.core.facet.IJBossESBFacetDataModelProperties;
import org.jboss.tools.esb.core.messages.JBossFacetCoreMessages;
import org.jboss.tools.esb.core.runtime.IESBRuntimeResolver;
import org.jboss.tools.esb.core.runtime.IRuntimeManagerListener;
import org.jboss.tools.esb.core.runtime.JBossESBRuntime;
import org.jboss.tools.esb.core.runtime.JBossRuntimeListConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossRuntimeManager {
    private static JBossRuntimeListConverter converter = new JBossRuntimeListConverter();
    private Map<String, JBossESBRuntime> runtimes = new HashMap<String, JBossESBRuntime>();
    private ArrayList<IRuntimeManagerListener> listeners = new ArrayList();
    static final String PLUGIN_ID = "org.jboss.tools.esb.project.core";
    static String ATT_CLASS = "class";
    static String ATT_VERSION = "esbVersion";
    static String ATT_ID = "id";
    static String VERSION_SEPARATOR = ",";
    static String VERSION_FILE_NAME = "VERSION";
    static String VERSION_PROPERTIES_KEY = "Version";
    static String VERSION_PROPERTIES_SEPERATOR = "_";
    static Map<String, IESBRuntimeResolver> parserMap = new HashMap<String, IESBRuntimeResolver>();

    private JBossRuntimeManager() {
        this.load();
    }

    public static JBossRuntimeManager getInstance() {
        return JBossRuntimeManagerHolder.INSTANCE;
    }

    public void addListener(IRuntimeManagerListener l) {
        this.listeners.add(l);
    }

    public void removeListener(IRuntimeManagerListener l) {
        this.listeners.remove(l);
    }

    private void fireRuntimeAdded(JBossESBRuntime rt) {
        for (IRuntimeManagerListener l : this.listeners) {
            l.runtimeAdded(rt);
        }
    }

    private void fireRuntimeRemoved(JBossESBRuntime rt) {
        for (IRuntimeManagerListener l : this.listeners) {
            l.runtimeRemoved(rt);
        }
    }

    public JBossESBRuntime[] getRuntimes() {
        Collection<JBossESBRuntime> c = this.runtimes.values();
        return c.toArray(new JBossESBRuntime[this.runtimes.size()]);
    }

    public void addRuntime(JBossESBRuntime runtime) {
        JBossESBRuntime oldDefaultRuntime;
        if (this.runtimes.size() == 0) {
            runtime.setDefault(true);
        }
        if ((oldDefaultRuntime = this.getDefaultRuntime()) != null && runtime.isDefault()) {
            oldDefaultRuntime.setDefault(false);
        }
        this.runtimes.put(runtime.getName(), runtime);
        this.save();
        this.fireRuntimeAdded(runtime);
    }

    public void addRuntime(String name, String path, String version, boolean defaultRt) {
        JBossESBRuntime jbossWSRt = new JBossESBRuntime();
        jbossWSRt.setHomeDir(path);
        jbossWSRt.setName(name);
        jbossWSRt.setVersion(version);
        jbossWSRt.setDefault(defaultRt);
        this.addRuntime(jbossWSRt);
    }

    public JBossESBRuntime findRuntimeByName(String name) {
        for (JBossESBRuntime jbossWSRuntime : this.runtimes.values()) {
            if (!jbossWSRuntime.getName().equals(name)) continue;
            return jbossWSRuntime;
        }
        return null;
    }

    public JBossESBRuntime[] findRuntimeByVersion(String version) {
        if (version == null || "".equals(version)) {
            return this.getRuntimes();
        }
        ArrayList<JBossESBRuntime> rts = new ArrayList<JBossESBRuntime>();
        for (JBossESBRuntime jbossWSRuntime : this.runtimes.values()) {
            if (!jbossWSRuntime.getVersion().equals(version)) continue;
            rts.add(jbossWSRuntime);
        }
        return rts.toArray(new JBossESBRuntime[0]);
    }

    public List<String> getAllRuntimeJars(JBossESBRuntime rt, String esbVersion) {
        List<String> jarList = new ArrayList<String>();
        if (rt != null) {
            if (rt.isUserConfigClasspath()) {
                jarList.addAll(rt.getLibraries());
            } else {
                jarList = this.getAllRuntimeJars(rt.getHomeDir(), esbVersion, rt.getConfiguration());
            }
        }
        return jarList;
    }

    public List<String> getAllRuntimeJars(String runtimeLocation, String esbVersion, String configuration) {
        ArrayList<String> jarList = new ArrayList<String>();
        IESBRuntimeResolver resolver = null;
        if (parserMap.get(esbVersion) != null) {
            resolver = parserMap.get(esbVersion);
        }
        if (resolver != null) {
            List<File> jars = resolver.getAllRuntimeJars(runtimeLocation, configuration);
            for (File file : jars) {
                jarList.add(file.getAbsolutePath());
            }
        } else {
            ESBProjectCorePlugin.log("No ESB runtime resolver defined for ESB " + esbVersion, null, 2);
        }
        return jarList;
    }

    public void removeRuntime(JBossESBRuntime rt) {
        this.runtimes.remove(rt.getName());
        this.fireRuntimeRemoved(rt);
    }

    public void save() {
        ESBProjectCorePlugin.getDefault().getPreferenceStore().setValue(JBossFacetCoreMessages.ESB_Location, converter.getString(this.runtimes));
        IPreferenceStore store = ESBProjectCorePlugin.getDefault().getPreferenceStore();
        if (store instanceof IPersistentPreferenceStore) {
            try {
                ((IPersistentPreferenceStore)store).save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void setDefaultRuntime(JBossESBRuntime runtime) {
        JBossESBRuntime[] runtimes = this.getRuntimes();
        int i = 0;
        while (i < runtimes.length) {
            runtimes[i].setDefault(false);
            ++i;
        }
        runtime.setDefault(true);
    }

    public JBossESBRuntime getDefaultRuntime() {
        for (JBossESBRuntime rt : this.runtimes.values()) {
            if (!rt.isDefault()) continue;
            return rt;
        }
        return null;
    }

    public List<String> getRuntimeNames() {
        JBossESBRuntime[] rts = this.getRuntimes();
        ArrayList<String> result = new ArrayList<String>();
        JBossESBRuntime[] jBossESBRuntimeArray = rts;
        int n = rts.length;
        int n2 = 0;
        while (n2 < n) {
            JBossESBRuntime jbossWSRuntime = jBossESBRuntimeArray[n2];
            result.add(jbossWSRuntime.getName());
            ++n2;
        }
        return result;
    }

    public List<String> getAllRuntimeNames() {
        JBossESBRuntime[] rts = this.getRuntimes();
        ArrayList<String> result = new ArrayList<String>();
        JBossESBRuntime[] jBossESBRuntimeArray = rts;
        int n = rts.length;
        int n2 = 0;
        while (n2 < n) {
            JBossESBRuntime jbossWSRuntime = jBossESBRuntimeArray[n2];
            result.add(jbossWSRuntime.getName());
            ++n2;
        }
        return result;
    }

    public void changeRuntimeName(String oldName, String newName) {
        JBossESBRuntime o = this.findRuntimeByName(oldName);
        if (o == null) {
            return;
        }
        o.setName(newName);
        this.onRuntimeNameChanged(oldName, newName);
    }

    private void onRuntimeNameChanged(String oldName, String newName) {
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)"jst.jboss.esb");
        Set facetedProjects = null;
        try {
            facetedProjects = ProjectFacetsManager.getFacetedProjects((IProjectFacet)facet);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        for (IFacetedProject facetedProject : facetedProjects) {
            QualifiedName qRuntimeName = IJBossESBFacetDataModelProperties.PERSISTENCE_PROPERTY_QNAME_RUNTIME_NAME;
            String name = null;
            try {
                name = facetedProject.getProject().getPersistentProperty(qRuntimeName);
                if (name == null || !name.equals(oldName)) continue;
                facetedProject.getProject().setPersistentProperty(qRuntimeName, newName);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isRuntimeUsed(String name) {
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)"jst.jboss.esb");
        Set facetedProjects = null;
        try {
            facetedProjects = ProjectFacetsManager.getFacetedProjects((IProjectFacet)facet);
        }
        catch (CoreException coreException) {
            return false;
        }
        for (IFacetedProject facetedProject : facetedProjects) {
            QualifiedName qRuntimeName = IJBossESBFacetDataModelProperties.PERSISTENCE_PROPERTY_QNAME_RUNTIME_NAME;
            try {
                if (!name.equals(facetedProject.getProject().getPersistentProperty(qRuntimeName))) continue;
                return true;
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public void load() {
        IPreferenceStore ps = ESBProjectCorePlugin.getDefault().getPreferenceStore();
        String runtimeListString = ps.getString(JBossFacetCoreMessages.ESB_Location);
        this.runtimes = converter.getMap(runtimeListString);
    }

    public static boolean isValidESBServer(String path, String version, String configuration) {
        return JBossRuntimeManager.isValidESBStandaloneRuntimeDir(path, version, configuration);
    }

    public static boolean isValidESBStandaloneRuntimeDir(String path, String version, String configuration) {
        IESBRuntimeResolver resolver = null;
        if (parserMap.get(version) != null) {
            resolver = parserMap.get(version);
        }
        if (resolver != null) {
            return resolver.isValidESBRuntime(path, version, configuration);
        }
        ESBProjectCorePlugin.log("No ESB runtime resolver defined for ESB " + version, null, 2);
        return false;
    }

    public String getESBVersionNumber(File rosettaJar) {
        return "";
    }

    public static void loadParsers() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, "esbRuntimeResolver");
        IConfigurationElement[] iConfigurationElementArray = extensionPoint.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String clazz = element.getAttribute(ATT_CLASS);
            String esbVersion = element.getAttribute(ATT_VERSION);
            IConfigurationElement[] supportedRTs = element.getChildren("supportedRuntimeType");
            ArrayList<String> runtimeTypeIds = new ArrayList<String>();
            IConfigurationElement[] iConfigurationElementArray2 = supportedRTs;
            int n3 = supportedRTs.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement supportedRT = iConfigurationElementArray2[n4];
                runtimeTypeIds.add(supportedRT.getAttribute(ATT_ID));
                ++n4;
            }
            if (clazz != null && (esbVersion != null || runtimeTypeIds.size() != 0)) {
                IESBRuntimeResolver parser = null;
                try {
                    parser = (IESBRuntimeResolver)element.createExecutableExtension(ATT_CLASS);
                    if (esbVersion != null && !"".equals(esbVersion.trim())) {
                        String[] versions;
                        String[] stringArray = versions = esbVersion.split(VERSION_SEPARATOR);
                        int n5 = versions.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            String version = stringArray[n6];
                            parserMap.put(version, parser);
                            ++n6;
                        }
                    }
                    for (String typeId : runtimeTypeIds) {
                        parserMap.put(typeId, parser);
                    }
                }
                catch (CoreException e) {
                    ESBProjectCorePlugin.log(e.getLocalizedMessage(), e);
                }
            }
            ++n2;
        }
    }

    public List<String> getESBFacetVersions() {
        ArrayList<String> versions = new ArrayList<String>();
        IProjectFacet esbfacet = ProjectFacetsManager.getProjectFacet((String)"jst.jboss.esb");
        for (IProjectFacetVersion version : esbfacet.getVersions()) {
            versions.add(version.getVersionString());
        }
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int o22;
                int o21;
                int o12;
                int o11;
                if (o1 == null || o2 == null) {
                    return 0;
                }
                String[] split1 = o1.split("\\.");
                String[] split2 = o2.split("\\.");
                if (split1.length != 2 || split2.length != 2) {
                    return o1.compareTo(o2);
                }
                try {
                    o11 = new Integer(split1[0]);
                    o12 = new Integer(split1[1]);
                    o21 = new Integer(split2[0]);
                    o22 = new Integer(split2[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    return o1.compareTo(o2);
                }
                if (o11 > o21) {
                    return 1;
                }
                if (o11 < o21) {
                    return -1;
                }
                if (o12 > o22) {
                    return 1;
                }
                if (o12 < o22) {
                    return -1;
                }
                return 0;
            }
        };
        Collections.sort(versions, comparator);
        versions.add("");
        return versions;
    }

    public String getVersion(String location, String configuration) {
        String version;
        block16: {
            ZipEntry entry;
            ZipFile zfile;
            block15: {
                version = "";
                File rosettaJar = null;
                Collection<IESBRuntimeResolver> resolvers = parserMap.values();
                for (IESBRuntimeResolver resolver : resolvers) {
                    rosettaJar = resolver.getRosettaJar(location, configuration);
                    if (rosettaJar != null && rosettaJar.exists()) break;
                }
                if (rosettaJar == null || !rosettaJar.exists()) {
                    return "";
                }
                zfile = new ZipFile(rosettaJar);
                entry = zfile.getEntry(VERSION_FILE_NAME);
                if (entry != null) break block15;
                return "";
            }
            InputStream input = zfile.getInputStream(entry);
            Properties properties = new Properties();
            properties.load(input);
            version = properties.getProperty(VERSION_PROPERTIES_KEY);
            if (version != null) break block16;
            return "";
        }
        try {
            List<String> facets;
            if (version.indexOf(VERSION_PROPERTIES_SEPERATOR) > 0) {
                version = version.substring(0, version.indexOf(VERSION_PROPERTIES_SEPERATOR));
            } else if (version.equals("4.3.0")) {
                version = "4.4";
            } else if (version.length() > 3 && (version.charAt(version.length() - 1) < '0' || version.charAt(version.length() - 1) >= '9')) {
                version = version.substring(0, 3);
            }
            int pos1 = version.indexOf(46);
            int pos2 = version.indexOf(46, pos1 + 1);
            if (pos2 > -1) {
                version = version.substring(0, pos2);
            }
            if (!(facets = this.getESBFacetVersions()).isEmpty() && !facets.contains(version)) {
                int i = facets.size() - 1;
                String tempFacetVersion = facets.get(i--);
                while (tempFacetVersion.trim().length() < 1) {
                    tempFacetVersion = facets.get(i--);
                }
                version = tempFacetVersion;
            }
        }
        catch (ZipException e) {
            ESBProjectCorePlugin.log(e.getLocalizedMessage(), e);
        }
        catch (IOException e) {
            ESBProjectCorePlugin.log(e.getLocalizedMessage(), e);
        }
        return version;
    }

    public String getRuntimeESBVersion(String location, String configuration) {
        String version;
        block9: {
            ZipEntry entry;
            ZipFile zfile;
            block8: {
                version = "";
                File rosettaJar = null;
                Collection<IESBRuntimeResolver> resolvers = parserMap.values();
                for (IESBRuntimeResolver resolver : resolvers) {
                    rosettaJar = resolver.getRosettaJar(location, configuration);
                    if (rosettaJar != null && rosettaJar.exists()) break;
                }
                if (rosettaJar == null || !rosettaJar.exists()) {
                    return "";
                }
                zfile = new ZipFile(rosettaJar);
                entry = zfile.getEntry(VERSION_FILE_NAME);
                if (entry != null) break block8;
                return "";
            }
            InputStream input = zfile.getInputStream(entry);
            Properties properties = new Properties();
            properties.load(input);
            version = properties.getProperty(VERSION_PROPERTIES_KEY);
            if (version != null) break block9;
            return "";
        }
        try {
            if (version.indexOf(VERSION_PROPERTIES_SEPERATOR) > 0) {
                version = version.substring(0, version.indexOf(VERSION_PROPERTIES_SEPERATOR));
            }
        }
        catch (ZipException e) {
            ESBProjectCorePlugin.log(e.getLocalizedMessage(), e);
        }
        catch (IOException e) {
            ESBProjectCorePlugin.log(e.getLocalizedMessage(), e);
        }
        return version;
    }

    /* synthetic */ JBossRuntimeManager(JBossRuntimeManager jBossRuntimeManager) {
        this();
    }

    static class JBossRuntimeManagerHolder {
        private static final JBossRuntimeManager INSTANCE = new JBossRuntimeManager(null);

        JBossRuntimeManagerHolder() {
        }
    }
}

