/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.core.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jboss.tools.esb.core.runtime.JBossESBRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossRuntimeListConverter {
    private static final String REGEXP_ESCAPE = "\\";
    private static final String COMMA = ",";
    private static final String LIBRARY_SEPARATOR = ";";
    private static final String EMPTY_STRING = "";
    private static final String FIELD_SEPARATOR = "|";
    private static final String DEFAULT = "default";
    private static final String HOME_DIR = "homeDir";
    private static final String VERSION = "version";
    private static final String CONFIGURATION = "configuration";
    private static final String NAME = "name";
    private static final String USER_CONFIG_CLASSPATH = "userConfig";
    private static final String LIBRARY = "libraries";

    public Map<String, JBossESBRuntime> getMap(String input) {
        HashMap<String, JBossESBRuntime> result = new HashMap<String, JBossESBRuntime>();
        if (input == null || EMPTY_STRING.equals(input.trim())) {
            return result;
        }
        StringTokenizer runtimes = new StringTokenizer(input, COMMA);
        while (runtimes.hasMoreTokens()) {
            String runtime = runtimes.nextToken();
            String[] map = runtime.split("\\|");
            JBossESBRuntime rt = new JBossESBRuntime();
            int i = 0;
            while (i < map.length) {
                String value;
                String name = map[i];
                String string = value = i + 1 < map.length ? map[i + 1] : EMPTY_STRING;
                if (NAME.equals(name)) {
                    rt.setName(value);
                } else if (HOME_DIR.equals(name)) {
                    rt.setHomeDir(value);
                } else if (VERSION.equals(name)) {
                    rt.setVersion(value);
                } else if (CONFIGURATION.equals(name)) {
                    rt.setConfiguration(value);
                } else if (DEFAULT.equals(name)) {
                    rt.setDefault(Boolean.parseBoolean(value));
                } else if (USER_CONFIG_CLASSPATH.equals(name)) {
                    rt.setUserConfigClasspath(Boolean.parseBoolean(value));
                } else if (LIBRARY.equals(name) && value != null && !EMPTY_STRING.equals(value)) {
                    rt.setLibraries(this.getLibrariesFromString(value));
                }
                i += 2;
            }
            result.put(rt.getName(), rt);
        }
        return result;
    }

    private List<String> getLibrariesFromString(String strLibraries) {
        ArrayList<String> libraries = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(strLibraries, LIBRARY_SEPARATOR);
        while (st.hasMoreTokens()) {
            String library = st.nextToken();
            if (libraries.contains(library)) continue;
            libraries.add(library);
        }
        return libraries;
    }

    private String convertListToString(List<String> libraries) {
        String strLib = EMPTY_STRING;
        for (String library : libraries) {
            strLib = EMPTY_STRING.equals(strLib) ? library : String.valueOf(strLib) + LIBRARY_SEPARATOR + library;
        }
        return strLib;
    }

    public String getString(Map<String, JBossESBRuntime> runtimeMap) {
        StringBuffer buffer = new StringBuffer();
        JBossESBRuntime[] runtimes = runtimeMap.values().toArray(new JBossESBRuntime[runtimeMap.size()]);
        int i = 0;
        while (i < runtimes.length) {
            buffer.append(NAME).append(FIELD_SEPARATOR);
            buffer.append(runtimes[i].getName());
            buffer.append(FIELD_SEPARATOR).append(VERSION).append(FIELD_SEPARATOR);
            buffer.append(runtimes[i].getVersion());
            buffer.append(FIELD_SEPARATOR).append(HOME_DIR).append(FIELD_SEPARATOR);
            buffer.append(runtimes[i].getHomeDir());
            buffer.append(FIELD_SEPARATOR).append(CONFIGURATION).append(FIELD_SEPARATOR);
            buffer.append(runtimes[i].getConfiguration());
            buffer.append(FIELD_SEPARATOR).append(DEFAULT).append(FIELD_SEPARATOR);
            buffer.append(runtimes[i].isDefault());
            buffer.append(FIELD_SEPARATOR).append(USER_CONFIG_CLASSPATH).append(FIELD_SEPARATOR);
            buffer.append(runtimes[i].isUserConfigClasspath());
            buffer.append(FIELD_SEPARATOR).append(LIBRARY).append(FIELD_SEPARATOR);
            buffer.append(this.convertListToString(runtimes[i].getLibraries()));
            if (i != runtimes.length - 1) {
                buffer.append(COMMA);
            }
            ++i;
        }
        return buffer.toString();
    }
}

