/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime.client.admin;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.SourceMappingMetadata;
import org.teiid.adminapi.impl.VDBImportMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.runtime.client.admin.StringConstants;
import org.teiid.runtime.client.admin.TeiidOptionsUtil;

public class VdbManifestGenerator
implements StringConstants {
    public static String DATA_ROLE_PERMISSION_CONDITION_XML = "condition";
    private static final String UNDEFINED = "undefined";
    private final StringWriter strWriter;
    private XMLStreamWriter writer;
    private final ITeiidServer teiidServer;
    private final VDBMetaData vdb;

    public VdbManifestGenerator(ITeiidServer server, VDBMetaData vdb) {
        this.teiidServer = server;
        this.vdb = vdb;
        this.strWriter = new StringWriter();
        this.writer = null;
        try {
            XMLOutputFactory xof = XMLOutputFactory.newInstance();
            this.writer = xof.createXMLStreamWriter(this.strWriter);
            this.virtualDatabase(vdb);
        }
        catch (FactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public String getManifest() {
        if (this.strWriter != null) {
            return this.strWriter.toString();
        }
        return "";
    }

    protected String undefined() {
        return UNDEFINED;
    }

    private void writeNewLine(int total) throws XMLStreamException {
        int i = 0;
        while (i < total) {
            this.writer.writeCharacters("\n");
            ++i;
        }
    }

    private void writeNewLine() throws XMLStreamException {
        this.writeNewLine(1);
    }

    private void writeTab(int total) throws XMLStreamException {
        int i = 0;
        while (i < total) {
            this.writer.writeCharacters("\t");
            ++i;
        }
    }

    private void writeStartDocument() throws XMLStreamException {
        this.writer.writeStartDocument("UTF-8", "1.0");
        this.writeNewLine();
    }

    private void writeStartElement(String tag) throws XMLStreamException {
        this.writer.writeStartElement(tag);
    }

    private void writeAttribute(String name, String value) throws XMLStreamException {
        this.writer.writeAttribute(name, value);
    }

    private void writeCData(String data) throws XMLStreamException {
        this.writer.writeCData(data);
    }

    private void writeCharacters(String characters) throws XMLStreamException {
        this.writer.writeCharacters(characters);
    }

    private void writeEndElement() throws XMLStreamException {
        this.writer.writeEndElement();
        this.writeNewLine();
    }

    private void writeElementWithText(String name, String text) throws XMLStreamException {
        this.writeStartElement(name);
        this.writeCharacters(text);
        this.writeEndElement();
    }

    private void writeEndDocument() throws XMLStreamException {
        this.writer.writeEndDocument();
        this.writer.close();
    }

    private void properties(int numTabs, Properties exportableProps) throws XMLStreamException {
        for (Object key : exportableProps.keySet()) {
            String name = (String)key;
            String value = exportableProps.getProperty(name);
            this.writeTab(numTabs);
            this.writeStartElement("property");
            this.writeAttribute("name", name);
            this.writeAttribute("value", value);
            this.writeEndElement();
        }
    }

    private void mask(DataPolicyMetadata.PermissionMetaData permission) throws XMLStreamException {
        String mask = permission.getMask();
        if (this.isNotEmpty(mask)) {
            this.writeTab(3);
            this.writeStartElement("mask");
            if (permission.getOrder() > 0) {
                this.writeAttribute("order", Integer.toString(permission.getOrder()));
            }
            this.writeCharacters(mask);
            this.writeEndElement();
        }
    }

    private void condition(DataPolicyMetadata.PermissionMetaData permission) throws XMLStreamException {
        String condition = permission.getCondition();
        if (this.isNotEmpty(condition)) {
            this.writeTab(3);
            this.writeStartElement("condition");
            if (!permission.getConstraint().booleanValue()) {
                this.writeAttribute("constraint", Boolean.toString(false));
            }
            this.writeCharacters(condition);
            this.writeEndElement();
        }
    }

    private void permission(DataPolicyMetadata.PermissionMetaData permission) throws XMLStreamException {
        this.writeTab(2);
        this.writeStartElement("permission");
        this.writeNewLine();
        this.writeTab(3);
        this.writeElementWithText("resource-name", permission.getResourceName());
        this.writeTab(3);
        try {
            this.writeElementWithText("allow-alter", Boolean.toString(permission.getAllowAlter()));
        }
        catch (NullPointerException nullPointerException) {
            this.writeElementWithText("allow-alter", Boolean.toString(false));
        }
        this.writeTab(3);
        try {
            this.writeElementWithText("allow-create", Boolean.toString(permission.getAllowCreate()));
        }
        catch (NullPointerException nullPointerException) {
            this.writeElementWithText("allow-create", Boolean.toString(false));
        }
        this.writeTab(3);
        try {
            this.writeElementWithText("allow-delete", Boolean.toString(permission.getAllowDelete()));
        }
        catch (NullPointerException nullPointerException) {
            this.writeElementWithText("allow-delete", Boolean.toString(false));
        }
        this.writeTab(3);
        try {
            this.writeElementWithText("allow-execute", Boolean.toString(permission.getAllowExecute()));
        }
        catch (NullPointerException nullPointerException) {
            this.writeElementWithText("allow-execute", Boolean.toString(false));
        }
        this.writeTab(3);
        try {
            this.writeElementWithText("allow-read", Boolean.toString(permission.getAllowRead()));
        }
        catch (NullPointerException nullPointerException) {
            this.writeElementWithText("allow-read", Boolean.toString(false));
        }
        this.writeTab(3);
        try {
            this.writeElementWithText("allow-update", Boolean.toString(permission.getAllowUpdate()));
        }
        catch (NullPointerException nullPointerException) {
            this.writeElementWithText("allow-update", Boolean.toString(false));
        }
        this.writeTab(3);
        try {
            this.writeElementWithText("allow-language", Boolean.toString(permission.getAllowLanguage()));
        }
        catch (NullPointerException nullPointerException) {
            this.writeElementWithText("allow-language", Boolean.toString(false));
        }
        this.condition(permission);
        this.mask(permission);
        this.writeTab(2);
        this.writeEndElement();
    }

    private void dataRole(List<DataPolicyMetadata> dataPolicies) throws XMLStreamException {
        for (DataPolicyMetadata policy : dataPolicies) {
            this.writeTab(1);
            this.writeStartElement("data-role");
            this.writeAttribute("name", policy.getName());
            this.writeAttribute("any-authenticated", Boolean.toString(policy.isAnyAuthenticated()));
            this.writeAttribute("allow-create-temporary-tables", Boolean.toString(policy.isAllowCreateTemporaryTables()));
            this.writeAttribute("grant-all", Boolean.toString(policy.isGrantAll()));
            this.writeNewLine();
            this.description(policy.getDescription(), 2);
            for (DataPolicyMetadata.PermissionMetaData permission : policy.getPermissionMap().values()) {
                this.permission(permission);
            }
            for (String mrName : policy.getMappedRoleNames()) {
                this.writeTab(2);
                this.writeElementWithText("mapped-role-name", mrName);
            }
            this.writeTab(1);
            this.writeEndElement();
        }
    }

    private void translator(List<VDBTranslatorMetaData> translators) throws XMLStreamException {
        for (VDBTranslatorMetaData translator : translators) {
            this.writeTab(1);
            this.writeStartElement("translator");
            this.writeAttribute("name", translator.getName());
            this.writeAttribute("type", translator.getType());
            if (translator.getDescription() != null) {
                this.writeAttribute("description", translator.getDescription());
            }
            this.writeNewLine();
            this.writeTab(1);
            this.writeEndElement();
        }
    }

    private void source(SourceMappingMetadata source) throws XMLStreamException {
        this.writeTab(2);
        this.writeStartElement("source");
        this.writeAttribute("name", source.getName());
        this.writeAttribute("translator-name", source.getTranslatorName());
        this.writeAttribute("connection-jndi-name", source.getConnectionJndiName());
        this.writeEndElement();
    }

    private void model(ModelMetaData model) throws XMLStreamException {
        this.writeTab(1);
        this.writeStartElement("model");
        this.writeAttribute("name", model.getName());
        model.getModelType().equals((Object)Model.Type.VIRTUAL);
        this.writeAttribute("type", model.getModelType().toString());
        if (!model.isVisible()) {
            this.writeAttribute("visible", Boolean.toString(false));
        }
        this.writeNewLine();
        this.description(model.getDescription(), 2);
        Properties exportableProps = new Properties();
        for (Object key : model.getProperties().keySet()) {
            String keyStr = (String)key;
            if (keyStr.equalsIgnoreCase("type") || keyStr.equalsIgnoreCase("modelUuid") || keyStr.equalsIgnoreCase("modelClass") || keyStr.equalsIgnoreCase("indexName") || keyStr.equalsIgnoreCase("builtIn") || keyStr.equalsIgnoreCase("imports") || keyStr.equalsIgnoreCase("checksum")) continue;
            exportableProps.put(keyStr, model.getProperties().get(key));
        }
        this.properties(1, exportableProps);
        for (SourceMappingMetadata source : model.getSourceMappings()) {
            this.source(source);
        }
        if (model.getSchemaText() != null && model.getSchemaText().length() > 0) {
            this.writeTab(2);
            this.writeStartElement("metadata");
            this.writeAttribute("type", "DDL");
            this.writeNewLine();
            this.writeTab(3);
            this.writeCData(model.getSchemaText());
            this.writeNewLine();
            this.writeTab(3);
            this.writeNewLine();
            this.writeTab(2);
            this.writeEndElement();
        } else {
            try {
                String ddl = this.teiidServer.getSchema(this.vdb.getName(), this.vdb.getVersion(), model.getName());
                if (ddl != null) {
                    this.writeTab(2);
                    this.writeStartElement("metadata");
                    this.writeAttribute("type", "DDL");
                    this.writeNewLine();
                    this.writeTab(3);
                    String filteredDdl = TeiidOptionsUtil.filterUuidsFromOptions(ddl);
                    this.writeCData(filteredDdl);
                    this.writeNewLine();
                    this.writeTab(3);
                    this.writeNewLine();
                    this.writeTab(2);
                    this.writeEndElement();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.writeTab(1);
        this.writeEndElement();
    }

    private void importVdbs(List<VDBImportMetadata> vdbImports) throws XMLStreamException {
        for (VDBImportMetadata vdbImport : vdbImports) {
            this.writeTab(1);
            this.writeStartElement("import-vdb");
            this.writeAttribute("name", vdbImport.getName());
            this.writeAttribute("version", Integer.toString(vdbImport.getVersion()));
            this.writeAttribute("import-data-policies", Boolean.toString(vdbImport.isImportDataPolicies()));
            this.writeTab(1);
            this.writeEndElement();
        }
    }

    private void description(String description, int numTabs) throws XMLStreamException {
        if (this.isNotEmpty(description)) {
            this.writeTab(numTabs);
            this.writeElementWithText("description", description);
        }
    }

    private void virtualDatabase(VDBMetaData vdb) throws XMLStreamException {
        this.writeStartDocument();
        this.writeTab(0);
        this.writeStartElement("vdb");
        this.writeAttribute("name", vdb.getName());
        this.writeAttribute("version", Integer.toString(vdb.getVersion()));
        this.writeNewLine(2);
        this.description(vdb.getDescription(), 1);
        if (vdb.getConnectionType() != null) {
            this.writeTab(1);
            this.writeElementWithText("connection-type", vdb.getConnectionType().toString());
        }
        Properties exportableProps = new Properties();
        for (Object key : vdb.getProperties().keySet()) {
            String keyStr = (String)key;
            if (keyStr.equalsIgnoreCase("description") || keyStr.equalsIgnoreCase("connection-type") || keyStr.equalsIgnoreCase("version") || keyStr.equalsIgnoreCase("deployment-name")) continue;
            if (keyStr.equalsIgnoreCase("preview")) {
                String value = vdb.getPropertyValue(keyStr);
                if (Boolean.FALSE.toString().toUpperCase().equalsIgnoreCase(value)) continue;
            }
            exportableProps.put(keyStr, vdb.getProperties().get(key));
        }
        this.properties(1, exportableProps);
        this.writeNewLine();
        this.importVdbs(vdb.getVDBImports());
        for (ModelMetaData model : vdb.getModelMetaDatas().values()) {
            this.model(model);
        }
        ArrayList<VDBTranslatorMetaData> overrides = new ArrayList<VDBTranslatorMetaData>();
        for (VDBTranslatorMetaData override : vdb.getOverrideTranslatorsMap().values()) {
            overrides.add(override);
        }
        this.translator(overrides);
        ArrayList<DataPolicyMetadata> dataroles = new ArrayList<DataPolicyMetadata>();
        for (DataPolicyMetadata datarole : vdb.getDataPolicyMap().values()) {
            dataroles.add(datarole);
        }
        this.dataRole(dataroles);
        this.writeNewLine();
        this.writeTab(0);
        this.writeEndElement();
        this.writeEndDocument();
    }

    private boolean isNotEmpty(String str) {
        return str != null && str.trim().length() > 0;
    }

    private static interface ElementTabValue {
        public static final int VIRTUAL_DATABASE = 0;
        public static final int VDB_PROPERTY = 1;
        public static final int DESCRIPTION = 1;
        public static final int CONNECTION_TYPE = 1;
        public static final int IMPORT_VDB = 1;
        public static final int MODEL = 1;
        public static final int MODEL_PROPERTY = 2;
        public static final int MODEL_DESCRIPTION = 2;
        public static final int MODEL_METADATA = 2;
        public static final int MODEL_VALIDATION = 2;
        public static final int MODEL_SOURCE = 2;
        public static final int TRANSLATOR = 1;
        public static final int TRANSLATOR_PROPERTY = 2;
        public static final int DATA_ROLE = 1;
        public static final int DATA_ROLE_DESCRIPTION = 2;
        public static final int PERMISSION = 2;
        public static final int MAPPED_ROLE_NAME = 2;
        public static final int RESOURCE_NAME = 3;
        public static final int PERMISSION_ALLOW = 3;
        public static final int CONDITION = 3;
        public static final int MASK = 3;
        public static final int ENTRY = 1;
        public static final int ENTRY_PROPERTY = 2;
        public static final int ENTRY_DESCRIPTION = 2;
    }
}

